/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.dlight.sendto.api.ConfigurationsModel;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class ConfigurationsRegistry {
    private static final ConfigurationsRegistry instance = new ConfigurationsRegistry();
    private final ConfigurationsModel model = ConfigurationsModel.getDefault();

    private ConfigurationsRegistry() {
    }

    public static ConfigurationsRegistry getDefault() {
        return instance;
    }

    public static void update(ConfigurationsModel newModel) {
        ConfigurationsRegistry.instance.model.setDataFrom(newModel);
    }

    public static void store() {
        try {
            Preferences registry = NbPreferences.forModule(ConfigurationsRegistry.class);
            registry.clear();
            int h_idx = 1;
            for (Configuration cfg : ConfigurationsRegistry.instance.model.getConfigurations()) {
                String prefix = Integer.toString(h_idx++) + '_';
                Map<String, String> properties = cfg.getProperties();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    registry.put(prefix + entry.getKey(), entry.getValue());
                }
            }
            registry.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void restore() {
        try {
            Preferences registry = NbPreferences.forModule(ConfigurationsRegistry.class);
            if (registry.keys().length == 0) {
                String s;
                registry.absolutePath();
                InputStream is = ConfigurationsRegistry.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/sendto/resources/initialConfiguration");
                if (is == null) {
                    return;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((s = br.readLine()) != null) {
                    int idx = s.indexOf(61);
                    if (idx <= 0) continue;
                    registry.put(s.substring(0, idx), s.substring(idx + 1).replace("\\n", "\n"));
                }
            }
            HashMap<String, Configuration> configs = new HashMap<String, Configuration>();
            for (String key : registry.keys()) {
                int idx = key.indexOf(95);
                if (idx < 0) continue;
                String prefix = key.substring(0, idx);
                if (!configs.containsKey(prefix)) {
                    configs.put(prefix, new Configuration());
                }
                Configuration cfg = (Configuration)configs.get(prefix);
                String property = key.substring(idx + 1);
                String val = registry.get(key, "<error>");
                cfg.set(property, val);
            }
            for (Configuration cfg : configs.values()) {
                ConfigurationsRegistry.instance.model.add(cfg);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static ConfigurationsModel getModelCopy() {
        return (ConfigurationsModel)ConfigurationsRegistry.instance.model.clone();
    }

    public static List<Configuration> getConfigurations() {
        return ConfigurationsRegistry.instance.model.getConfigurations();
    }

    static {
        ConfigurationsRegistry.restore();
    }
}

