/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.java.impl;

import org.clang.lex.PTHManager;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.llvm.support.OnDiskChainedHashTable;
import org.llvm.support.llvm;

public final class PTHStringIdLookup
extends OnDiskChainedHashTable<std_pair.pairTypeInt<char.ptr>, std_pair.pairTypeInt<char.ptr>, Number> {
    private boolean $IKeyInUse = false;
    private final std_pair.pairTypeInt<char.ptr> $IKey = new std_pair.pairTypeInt(null, 0);
    private final char.ptr.array $IKeyCharPtr = (char.ptr.array)NativePointer.create_reusable_char$ptr();

    private PTHStringIdLookup(int NumBuckets, int NumEntries, char.ptr Buckets, char.ptr Base, PTHManager.PTHStringLookupTrait Info) {
        super(NumBuckets, NumEntries, Buckets, Base, (OnDiskChainedHashTable.InfoInterface)Info);
    }

    public static PTHStringIdLookup CreatePTHStringIdLookup(char.ptr Buckets, char.ptr Base, PTHManager.PTHStringLookupTrait Info) {
        assert (Buckets.$greater((Object)Base)) : Buckets.$index() + " vs. " + Base.$index() + ":" + Base;
        assert ((Buckets.$index() & 3) == 0) : "buckets should be 4-byte aligned. " + Buckets.$index();
        int NumBuckets = llvm.support.endian.readNext_uint32((char.ptr)Buckets, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        int NumEntries = llvm.support.endian.readNext_uint32((char.ptr)Buckets, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        return new PTHStringIdLookup(NumBuckets, NumEntries, Native.$noClone((char.ptr)Buckets), Native.$noClone((char.ptr)Base), Info);
    }

    public Number get(char.ptr Name, int NameLen) {
        int KeyHash = llvm.HashString((char.ptr)Name, (int)NameLen);
        int Offset = this.getOffsetImpl(KeyHash);
        if (Offset == 0) {
            return null;
        }
        std_pair.pairTypeInt<char.ptr> IKey = this.$getIKey(Name, NameLen);
        Number out = this.getImpl(IKey, KeyHash, Offset);
        this.$releaseIKey(IKey);
        return out;
    }

    public Number get(byte[] Name, int NameStIndex, int NameLen) {
        int KeyHash = llvm.HashString((byte[])Name, (int)NameStIndex, (int)NameLen);
        int Offset = this.getOffsetImpl(KeyHash);
        if (Offset == 0) {
            return null;
        }
        std_pair.pairTypeInt<char.ptr> IKey = this.$getIKey(Name, NameStIndex, NameLen);
        Number out = this.getImpl(IKey, KeyHash, Offset);
        this.$releaseIKey(IKey);
        return out;
    }

    private int getOffsetImpl(int KeyHash) {
        int Idx = KeyHash & this.NumBuckets - 1;
        assert (Idx >= 0) : "negative " + Idx + " for " + KeyHash + " with " + this.NumBuckets;
        int Bucket = NativeType.sizeof$uint32() * Idx;
        int Offset = llvm.support.endian.read_uint32((char.ptr)this.Buckets, (int)Bucket, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        return Offset;
    }

    private Number getImpl(std_pair.pairTypeInt<char.ptr> IKey, int KeyHash, int Offset) {
        assert (Offset > 0);
        PTHManager.PTHStringLookupTrait InfoPtr = (PTHManager.PTHStringLookupTrait)this.InfoObj;
        int Items = Offset;
        int Len = llvm.support.endian.read_uint16((char.ptr)this.Base, (int)Items, (llvm.support.endianness)llvm.support.endianness.little, (int)1);
        Items += NativeType.sizeof$uint16();
        for (int i = 0; i < Len; ++i) {
            int ItemHash = llvm.support.endian.read_uint32((char.ptr)this.Base, (int)Items, (llvm.support.endianness)llvm.support.endianness.little, (int)1);
            long L = InfoPtr.ReadKeyDataLength(this.Base, Items += NativeType.sizeof$uint32());
            Items += InfoPtr.getReadKeyDataLengthBytes();
            int KeyLen = std_pair.$first_int((long)L);
            int DataLen = std_pair.$second_int((long)L);
            int ItemLen = KeyLen + DataLen;
            if (ItemHash != KeyHash) {
                Items += ItemLen;
                continue;
            }
            std_pair.pairTypeInt<char.ptr> X = InfoPtr.ReadKey(this.Base, Items, KeyLen);
            if (!InfoPtr.EqualKey(X, IKey)) {
                Items += ItemLen;
                InfoPtr.$releaseKey(X);
                continue;
            }
            Number Out = InfoPtr.ReadData(X, this.Base, Items += KeyLen, DataLen);
            InfoPtr.$releaseKey(X);
            return Out;
        }
        return null;
    }

    private std_pair.pairTypeInt<char.ptr> $getIKey(byte[] Name, int NameStIndex, int NameLen) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$IKeyInUse) break block3;
                this.$IKeyInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        Native.$setArrayAndIndex((char.ptr.array)this.$IKeyCharPtr, (byte[])Name, (int)NameStIndex);
        this.$IKey.first = this.$IKeyCharPtr;
        this.$IKey.second = NameLen;
        return this.$IKey;
    }

    private std_pair.pairTypeInt<char.ptr> $getIKey(char.ptr Name, int NameLen) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$IKeyInUse) break block3;
                this.$IKeyInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        this.$IKey.first = Name;
        this.$IKey.second = NameLen;
        return this.$IKey;
    }

    private void $releaseIKey(std_pair.pairTypeInt<char.ptr> IKey) {
        assert (IKey == this.$IKey);
        assert (this.$IKeyInUse);
        if (!$assertionsDisabled) {
            this.$IKeyInUse = false;
            if (!false) {
                // empty if block
            }
        }
        this.$IKey.first = null;
    }
}

