/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.symbol;

import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class CppSymbolDescriptor
extends SymbolDescriptor
implements Runnable {
    private final Icon icon;
    private final CsmProject project;
    private final CharSequence filePath;
    private final int offset;
    private final CharSequence ownerName;
    private final CharSequence name;

    public CppSymbolDescriptor(CsmOffsetable csmObj) {
        this(csmObj, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CppSymbolDescriptor(CsmOffsetable csmObj, CsmOffsetable toOpen) {
        CsmFile csmFile;
        Parameters.notNull((CharSequence)"csmObj", (Object)csmObj);
        if (toOpen != null) {
            csmFile = toOpen.getContainingFile();
            this.offset = toOpen.getStartOffset();
        } else {
            csmFile = csmObj.getContainingFile();
            this.offset = csmObj.getStartOffset();
        }
        this.filePath = csmFile.getAbsolutePath();
        this.project = csmFile.getProject();
        if (CsmKindUtilities.isClass((CsmObject)csmObj) && CsmKindUtilities.isTemplate((CsmObject)csmObj)) {
            this.name = ((CsmTemplate)csmObj).getDisplayName();
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObj)) {
            this.name = ((CsmFunction)csmObj).getSignature();
        } else {
            if (!CsmKindUtilities.isNamedElement((CsmObject)csmObj)) throw new IllegalArgumentException("should be CsmNamedElement, in fact " + csmObj.getClass().getName());
            this.name = ((CsmNamedElement)csmObj).getName();
        }
        CharSequence fileName = csmFile.getName();
        if (CsmKindUtilities.isMacro((CsmObject)csmObj)) {
            this.ownerName = fileName;
        } else {
            if (!CsmKindUtilities.isOffsetableDeclaration((Object)csmObj)) throw new IllegalArgumentException("should be either CsmMacro or CsmDeclaration, in fact " + csmObj.getClass().getName());
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)csmObj;
            CsmScope scope = decl.getScope();
            if (CsmKindUtilities.isFile((CsmObject)scope)) {
                this.ownerName = fileName;
            } else {
                if (!CsmKindUtilities.isQualified((CsmObject)scope)) throw new IllegalArgumentException("should be either CsmFile or CsmQualifiedNamedElement, in fact " + csmObj.getClass().getName());
                CharSequence qName = ((CsmQualifiedNamedElement)scope).getQualifiedName();
                this.ownerName = qName.length() > 0 ? NbBundle.getMessage(this.getClass(), (String)"CPP_Descriptor_In_Compound", (Object)qName, (Object)fileName) : fileName;
            }
        }
        this.icon = CsmImageLoader.getIcon((CsmObject)csmObj);
    }

    public FileObject getFileObject() {
        CndUtils.assertNonUiThread();
        return new FSPath(this.project.getFileSystem(), this.filePath.toString()).getFileObject();
    }

    public String getFileDisplayPath() {
        return this.filePath.toString();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOwnerName() {
        return this.ownerName.toString();
    }

    public Icon getProjectIcon() {
        return CsmImageLoader.getIcon((CsmObject)this.project);
    }

    public String getProjectName() {
        CharSequence prjName = this.project.getName();
        if (this.project.isArtificial()) {
            prjName = CsmDisplayUtilities.shrinkPath((CharSequence)prjName, (int)32, (int)2, (int)2);
        }
        return prjName.toString();
    }

    public String getSymbolName() {
        return this.name.toString();
    }

    public String getSimpleName() {
        for (int i = 0; i < this.name.length(); ++i) {
            if (this.name.charAt(i) != '(' || i + 2 < this.name.length() && this.name.charAt(i + 1) == ')' && this.name.charAt(i + 2) == '(') continue;
            return this.name.subSequence(0, i).toString();
        }
        return this.name.toString();
    }

    public void open() {
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        CsmUtilities.openSource((FileObject)this.getFileObject(), (int)this.offset);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.project != null ? this.project.hashCode() : 0);
        hash = 41 * hash + (this.filePath != null ? this.filePath.hashCode() : 0);
        hash = 41 * hash + this.offset;
        hash = 41 * hash + (this.ownerName != null ? this.ownerName.hashCode() : 0);
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CppSymbolDescriptor other = (CppSymbolDescriptor)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (!(this.project == other.project || this.project != null && this.project.equals(other.project))) {
            return false;
        }
        if (!(this.filePath == other.filePath || this.filePath != null && this.filePath.equals(other.filePath))) {
            return false;
        }
        if (!(this.ownerName == other.ownerName || this.ownerName != null && this.ownerName.equals(other.ownerName))) {
            return false;
        }
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }
}

