/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.ValueItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.spi.editor.completion.CompletionItem;

public class ConstantCompleter
implements Completer,
Completer.Factory {
    private CompletionContext ctx;
    private FxNewInstance instance;
    private static final String ICON_CONSTANT_VALUE = "org/netbeans/modules/javafx2/editor/resources/property.png";

    ConstantCompleter(CompletionContext ctx, FxNewInstance instance) {
        this.ctx = ctx;
        this.instance = instance;
    }

    public ConstantCompleter() {
    }

    @Override
    public List<? extends CompletionItem> complete() {
        ArrayList<String> allValues = new ArrayList<String>(this.instance.getDefinition().getConstants());
        Collections.sort(allValues);
        String prefix = this.ctx.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            Iterator it = allValues.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.startsWith(prefix)) continue;
                it.remove();
            }
        }
        if (allValues.isEmpty()) {
            return null;
        }
        ArrayList<ValueItem> items = new ArrayList<ValueItem>();
        for (String v : allValues) {
            ValueItem vi = new ValueItem(this.ctx, v, ICON_CONSTANT_VALUE);
            items.add(vi);
        }
        return items;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        FxInstance i = ctx.getInstanceElement();
        if (!(i instanceof FxNewInstance)) {
            return null;
        }
        FxNewInstance newInst = (FxNewInstance)i;
        String s = ctx.getPropertyName();
        if (s == null || !s.endsWith(":constant")) {
            return null;
        }
        return new ConstantCompleter(ctx, newInst);
    }
}

