/*
 * Decompiled with CFR 0.152.
 */
package org.clang.ast;

import org.clang.ast.ExternalASTSource;

public abstract class LazyOffsetPtr<T> {
    public long Offset;
    public T Ptr;

    protected abstract T get(ExternalASTSource var1, long var2);

    public LazyOffsetPtr() {
        this.Ptr = null;
        this.Offset = 0L;
    }

    public LazyOffsetPtr(T Ptr) {
        this.Ptr = Ptr;
        this.Offset = 0L;
    }

    public LazyOffsetPtr(long Offset) {
        this.Ptr = null;
        this.Offset = Offset;
    }

    public LazyOffsetPtr<T> $assign(T Ptr) {
        this.Ptr = Ptr;
        this.Offset = 0L;
        return this;
    }

    public LazyOffsetPtr<T> $assign(long Offset) {
        this.Ptr = null;
        this.Offset = Offset;
        return this;
    }

    public boolean $bool() {
        return this.Ptr != null || this.Offset != 0L;
    }

    public boolean isValid() {
        return this.Ptr != null || this.Offset != 0L;
    }

    public boolean isOffset() {
        return this.Offset != 0L;
    }

    public T get(ExternalASTSource Source) {
        if (this.isOffset()) {
            assert (Source != null) : "Cannot deserialize a lazy pointer without an AST source";
            return this.get(Source, this.Offset);
        }
        return this.Ptr;
    }

    public String toString() {
        return "Offset=" + this.Offset + " Ptr=" + this.Ptr;
    }
}

