/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadT1Client;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientT1Protocol
extends ClientProtocol {
    protected boolean numSeq = false;
    protected boolean numSeqTx = true;
    protected boolean numSeqRcv = true;
    protected T1Block blockToCard;
    protected T1Block blockFromCard;
    private int sizeIFSC;
    private int sizeIFSD;

    public ClientT1Protocol(CadT1Client cad) {
        this.cad = cad;
        this.sizeIFSC = cad.getMaxIFSSize();
        this.blockToCard = new T1Block();
        this.blockFromCard = new T1Block();
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, T1Exception {
        byte sbType;
        boolean seqBlock;
        byte fromCardBlockType;
        boolean result;
        boolean retransmit;
        CadT1Client cadT1 = (CadT1Client)this.cad;
        boolean success = false;
        boolean abortRecv = false;
        block20: while (!success) {
            Vector<byte[]> inBytes = this.prepareT1IBlocks(apdu, this.sizeIFSC);
            Enumeration<byte[]> eIBlocks = inBytes.elements();
            while (eIBlocks.hasMoreElements() && !abortRecv) {
                byte[] inData = eIBlocks.nextElement();
                boolean lastBlock = !eIBlocks.hasMoreElements();
                this.blockToCard.setIBlock((byte)0, (byte)0, this.numSeq, lastBlock, inData, inData.length);
                retransmit = true;
                while (retransmit) {
                    result = cadT1.exchangeBlock(this.blockToCard, this.blockFromCard);
                    if (!result) {
                        throw new T1Exception(-126);
                    }
                    this.numSeqTx = this.numSeq;
                    this.numSeq = !this.numSeq;
                    fromCardBlockType = this.blockFromCard.getBlockType();
                    block0 : switch (fromCardBlockType) {
                        case 0: {
                            if (!lastBlock) {
                                throw new T1Exception(-126);
                            }
                            seqBlock = this.blockFromCard.getSequence();
                            if (seqBlock == !this.numSeqRcv) {
                                this.numSeqRcv = seqBlock;
                                retransmit = false;
                                break;
                            }
                            this.blockToCard.setIBlock((byte)0, (byte)0, this.numSeq, lastBlock, inData, inData.length);
                            break;
                        }
                        case -128: {
                            seqBlock = this.blockFromCard.getSequence();
                            if (seqBlock == !this.numSeqTx) {
                                retransmit = false;
                                break;
                            }
                            this.blockToCard.setIBlock((byte)0, (byte)0, this.numSeq, lastBlock, inData, inData.length);
                            break;
                        }
                        case -64: {
                            sbType = this.blockFromCard.getSBlockType();
                            switch (sbType) {
                                case -64: 
                                case -63: {
                                    throw new T1Exception(-125);
                                }
                                case -62: {
                                    boolean retransmitAbort = true;
                                    while (retransmitAbort) {
                                        this.blockToCard.setSBlock((byte)0, (byte)0, -30, 0);
                                        result = cadT1.exchangeBlock(this.blockToCard, this.blockFromCard);
                                        if (!result) {
                                            throw new T1Exception(-126);
                                        }
                                        fromCardBlockType = this.blockFromCard.getBlockType();
                                        if (fromCardBlockType != 0) {
                                            throw new T1Exception(-126);
                                        }
                                        seqBlock = this.blockFromCard.getSequence();
                                        if (seqBlock != !this.numSeqRcv) continue;
                                        this.numSeqRcv = seqBlock;
                                        retransmitAbort = false;
                                    }
                                    abortRecv = true;
                                    retransmit = false;
                                    success = true;
                                    break block0;
                                }
                                case -61: {
                                    this.blockToCard.setSBlock((byte)0, (byte)0, -29, this.blockFromCard.getIntINF());
                                    break block0;
                                }
                            }
                            throw new T1Exception(-124);
                        }
                        default: {
                            throw new T1Exception(-124);
                        }
                    }
                }
                if (retransmit) continue block20;
                if (!lastBlock) continue;
                success = true;
            }
        }
        int outLength = 0;
        Vector<byte[]> outBytes = new Vector<byte[]>();
        byte[] outData = this.blockFromCard.getINFBytes();
        byte[] outDataNew = new byte[outLength += this.blockFromCard.getLEN()];
        System.arraycopy(outData, 0, outDataNew, 0, outLength);
        outBytes.add(outDataNew);
        while (!this.blockFromCard.isLastBlock()) {
            retransmit = true;
            this.blockToCard.setRBlock((byte)0, (byte)0, !this.numSeqRcv);
            block25: while (retransmit) {
                result = cadT1.exchangeBlock(this.blockToCard, this.blockFromCard);
                if (!result) {
                    throw new T1Exception(-126);
                }
                fromCardBlockType = this.blockFromCard.getBlockType();
                seqBlock = this.blockFromCard.getSequence();
                switch (fromCardBlockType) {
                    case 0: {
                        if (seqBlock == !this.numSeqRcv) {
                            this.numSeqRcv = seqBlock;
                            retransmit = false;
                            continue block25;
                        }
                        this.blockToCard.setRBlock((byte)0, (byte)0, !this.numSeqRcv);
                        continue block25;
                    }
                    case -128: {
                        if (seqBlock == !this.numSeqTx) {
                            throw new T1Exception(-124);
                        }
                        retransmit = true;
                        continue block25;
                    }
                    case -64: {
                        sbType = this.blockFromCard.getSBlockType();
                        switch (sbType) {
                            case -64: 
                            case -63: {
                                throw new T1Exception(-125);
                            }
                            case -62: {
                                this.blockToCard.setSBlock((byte)0, (byte)0, -30, 0);
                                result = cadT1.exchangeBlock(this.blockToCard, this.blockFromCard);
                                if (!result) {
                                    throw new T1Exception(-126);
                                }
                                fromCardBlockType = this.blockFromCard.getBlockType();
                                if (fromCardBlockType != 0) {
                                    throw new T1Exception(-126);
                                }
                                seqBlock = this.blockFromCard.getSequence();
                                if (seqBlock == !this.numSeqRcv) {
                                    this.numSeqRcv = seqBlock;
                                    retransmit = false;
                                    continue block25;
                                }
                                throw new T1Exception(-126);
                            }
                            case -61: {
                                this.blockToCard.setSBlock((byte)0, (byte)0, -29, this.blockFromCard.getIntINF());
                                continue block25;
                            }
                        }
                        throw new T1Exception(-124);
                    }
                }
                throw new T1Exception(-124);
            }
            outData = this.blockFromCard.getINFBytes();
            outLength += this.blockFromCard.getLEN();
            outDataNew = new byte[this.blockFromCard.getLEN()];
            System.arraycopy(outData, 0, outDataNew, 0, this.blockFromCard.getLEN());
            outBytes.add(outDataNew);
        }
        byte[] dataOut = new byte[outLength - 2];
        int dataCtr = 0;
        Enumeration enumCardBlocks = outBytes.elements();
        while (enumCardBlocks.hasMoreElements()) {
            boolean lastBlock;
            byte[] theData = (byte[])enumCardBlocks.nextElement();
            boolean bl = lastBlock = !enumCardBlocks.hasMoreElements();
            if (lastBlock) {
                if (theData.length > 2) {
                    System.arraycopy(theData, 0, dataOut, dataCtr, theData.length - 2);
                }
                dataCtr += theData.length - 2;
                apdu.sw1sw2[0] = theData[theData.length - 2];
                apdu.sw1sw2[1] = theData[theData.length - 1];
                continue;
            }
            System.arraycopy(theData, 0, dataOut, dataCtr, theData.length);
            dataCtr += theData.length;
        }
        if (dataCtr == 0) {
            dataOut = new byte[]{};
        }
        apdu.setDataOut(dataOut, dataCtr);
    }

    private Vector<byte[]> prepareT1IBlocks(Apdu apdu, int sizeINF) throws T1Exception {
        Vector<byte[]> inBytes = new Vector<byte[]>();
        int dataOffset = 0;
        switch (apdu.getCase()) {
            case 1: {
                byte[] apduData = new byte[4];
                System.arraycopy(apdu.command, 0, apduData, 0, 4);
                inBytes.add(apduData);
                break;
            }
            case 2: {
                byte[] apduData = new byte[5];
                System.arraycopy(apdu.command, 0, apduData, 0, 4);
                apduData[4] = (byte)apdu.Le;
                inBytes.add(apduData);
                break;
            }
            case 3: {
                int dataSize;
                int numBlocks = (apdu.Lc + 5) / this.sizeIFSC;
                if (numBlocks * this.sizeIFSC < apdu.Lc + 5) {
                    ++numBlocks;
                }
                int dataRemaining = dataSize = 5 + apdu.Lc;
                int countBlocks = 0;
                boolean firstBlock = true;
                while (countBlocks < numBlocks) {
                    int blockSize = dataRemaining > this.sizeIFSC ? this.sizeIFSC : dataRemaining;
                    int countData = 0;
                    byte[] apduData = new byte[blockSize];
                    if (firstBlock) {
                        System.arraycopy(apdu.command, 0, apduData, 0, 4);
                        apduData[4] = (byte)apdu.Lc;
                        countData += 5;
                        firstBlock = false;
                    }
                    System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, blockSize - countData);
                    dataOffset += blockSize - countData;
                    countData += blockSize - countData;
                    inBytes.add(apduData);
                    ++countBlocks;
                    dataRemaining -= blockSize;
                }
                break;
            }
            case 4: {
                int dataSize;
                int numBlocks = (apdu.Lc + 6) / this.sizeIFSC;
                if (numBlocks * this.sizeIFSC < apdu.Lc + 6) {
                    ++numBlocks;
                }
                int dataRemaining = dataSize = 6 + apdu.Lc;
                int countBlocks = 0;
                boolean firstBlock = true;
                boolean lastBlock = false;
                while (countBlocks < numBlocks) {
                    int blockSize;
                    if (dataRemaining > this.sizeIFSC) {
                        blockSize = this.sizeIFSC;
                    } else {
                        blockSize = dataRemaining;
                        lastBlock = true;
                    }
                    int countData = 0;
                    byte[] apduData = new byte[blockSize];
                    if (firstBlock) {
                        System.arraycopy(apdu.command, 0, apduData, 0, 4);
                        apduData[4] = (byte)apdu.Lc;
                        countData += 5;
                        firstBlock = false;
                    }
                    if (!lastBlock) {
                        System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, blockSize - countData);
                        dataOffset += blockSize - countData;
                        countData += blockSize - countData;
                    } else {
                        System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, blockSize - countData - 1);
                        apduData[blockSize - 1] = (byte)apdu.Le;
                        dataOffset += blockSize - countData;
                        countData += blockSize - countData;
                    }
                    inBytes.add(apduData);
                    ++countBlocks;
                    dataRemaining -= blockSize;
                }
                break;
            }
            case 5: {
                byte[] apduData = new byte[7];
                System.arraycopy(apdu.command, 0, apduData, 0, 4);
                apduData[4] = 0;
                apduData[5] = (byte)(apdu.Le >> 8);
                apduData[6] = (byte)apdu.Le;
                inBytes.add(apduData);
                break;
            }
            case 6: {
                int dataSize;
                int numBlocks = (apdu.Lc + 7) / this.sizeIFSC;
                if (numBlocks * this.sizeIFSC < apdu.Lc + 7) {
                    ++numBlocks;
                }
                int dataRemaining = dataSize = 7 + apdu.Lc;
                int countBlocks = 0;
                boolean firstBlock = true;
                while (countBlocks < numBlocks) {
                    int blockSize = dataRemaining > this.sizeIFSC ? this.sizeIFSC : dataRemaining;
                    int countData = 0;
                    byte[] apduData = new byte[blockSize];
                    if (firstBlock) {
                        System.arraycopy(apdu.command, 0, apduData, 0, 4);
                        apduData[4] = 0;
                        apduData[5] = (byte)(apdu.Lc >> 8);
                        apduData[6] = (byte)apdu.Lc;
                        countData += 7;
                        firstBlock = false;
                    }
                    System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, blockSize - countData);
                    dataOffset += blockSize - countData;
                    countData += blockSize - countData;
                    inBytes.add(apduData);
                    ++countBlocks;
                    dataRemaining -= blockSize;
                }
                break;
            }
            case 7: {
                int dataSize;
                int numBlocks = (apdu.Lc + 9) / this.sizeIFSC;
                if (numBlocks * this.sizeIFSC < apdu.Lc + 9) {
                    ++numBlocks;
                }
                int dataRemaining = dataSize = 9 + apdu.Lc;
                int countBlocks = 0;
                boolean firstBlock = true;
                boolean lastBlock = false;
                while (countBlocks < numBlocks) {
                    int blockSize;
                    if (dataRemaining > this.sizeIFSC) {
                        blockSize = this.sizeIFSC;
                    } else {
                        blockSize = dataRemaining;
                        lastBlock = true;
                    }
                    int countData = 0;
                    byte[] apduData = new byte[blockSize];
                    if (firstBlock) {
                        System.arraycopy(apdu.command, 0, apduData, 0, 4);
                        apduData[4] = 0;
                        apduData[5] = (byte)(apdu.Lc >> 8);
                        apduData[6] = (byte)apdu.Lc;
                        countData += 7;
                        firstBlock = false;
                    }
                    if (!lastBlock) {
                        if (dataRemaining == blockSize + 1) {
                            System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, --blockSize - countData);
                            dataOffset += blockSize - countData;
                            countData += blockSize - countData;
                        } else {
                            System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, blockSize - countData);
                            dataOffset += blockSize - countData;
                            countData += blockSize - countData;
                        }
                    } else {
                        if (dataRemaining != 2) {
                            System.arraycopy(apdu.dataIn, dataOffset, apduData, countData, blockSize - countData - 2);
                        }
                        apduData[blockSize - 2] = (byte)(apdu.Le >> 8);
                        apduData[blockSize - 1] = (byte)apdu.Le;
                        dataOffset += blockSize - countData;
                        countData += blockSize - countData;
                    }
                    inBytes.add(apduData);
                    ++countBlocks;
                    dataRemaining -= blockSize;
                }
                break;
            }
            default: {
                throw new T1Exception(CadTransportException.STATUS_UNKNOWN);
            }
        }
        return inBytes;
    }
}

