/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.SelectionAwareJavaSourceTaskFactory;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.errors.CreateElementUtilities;
import org.netbeans.modules.java.hints.introduce.IntroduceConstantFix;
import org.netbeans.modules.java.hints.introduce.IntroduceExpressionBasedMethodFix;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldFix;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.introduce.IntroduceMethodFix;
import org.netbeans.modules.java.hints.introduce.IntroduceParameterFix;
import org.netbeans.modules.java.hints.introduce.IntroduceVariableFix;
import org.netbeans.modules.java.hints.introduce.PositionRefresherHelperImpl;
import org.netbeans.modules.java.hints.introduce.ScanStatement;
import org.netbeans.modules.java.hints.introduce.TargetDescription;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

public class IntroduceHint
implements CancellableTask<CompilationInfo> {
    private AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<TypeKind> NOT_ACCEPTED_TYPES = EnumSet.of(TypeKind.ERROR, TypeKind.NONE, TypeKind.OTHER, TypeKind.VOID, TypeKind.EXECUTABLE);
    static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.RESOURCE_VARIABLE);
    static final AttributeSet DUPE = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, Color.GRAY});
    static InsertClassMember INSERT_CLASS_MEMBER = new InsertClassMember();

    static TreePath validateSelection(CompilationInfo ci, int start, int end) {
        return IntroduceHint.validateSelection(ci, start, end, NOT_ACCEPTED_TYPES);
    }

    public static TreePath validateSelection(CompilationInfo ci, int start, int end, Set<TypeKind> ignoredTypes) {
        int[] span = TreeUtils.ignoreWhitespaces(ci, Math.min(start, end), Math.max(start, end));
        start = span[0];
        end = span[1];
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2 + 1); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            if (!ExpressionTree.class.isAssignableFrom(leaf.getKind().asInterface()) && (leaf.getKind() != Tree.Kind.VARIABLE || ((VariableTree)leaf).getInitializer() == null)) continue;
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart != (long)start || treeEnd != (long)end) continue;
            TypeMirror type = ci.getTrees().getTypeMirror(tp);
            if (type != null && type.getKind() == TypeKind.ERROR) {
                type = ci.getTrees().getOriginalType((ErrorType)type);
            }
            if (type == null || ignoredTypes.contains((Object)type.getKind()) || tp.getLeaf().getKind() == Tree.Kind.ASSIGNMENT || tp.getLeaf().getKind() == Tree.Kind.ANNOTATION) continue;
            if (!TreeUtils.isInsideClass(tp)) {
                return null;
            }
            TreePath candidate = tp;
            for (tp = tp.getParentPath(); tp != null; tp = tp.getParentPath()) {
                switch (tp.getLeaf().getKind()) {
                    case VARIABLE: {
                        VariableTree vt = (VariableTree)tp.getLeaf();
                        if (vt.getInitializer() == leaf) {
                            return candidate;
                        }
                        return null;
                    }
                    case NEW_CLASS: {
                        NewClassTree nct = (NewClassTree)tp.getLeaf();
                        if (!nct.getIdentifier().equals(candidate.getLeaf())) break;
                        for (Tree tree : nct.getArguments()) {
                            if (tree != leaf) continue;
                            return candidate;
                        }
                        return null;
                    }
                }
                leaf = tp.getLeaf();
            }
            return candidate;
        }
        return null;
    }

    public void run(CompilationInfo info) {
        this.cancel.set(false);
        FileObject file = info.getFileObject();
        int[] selection = SelectionAwareJavaSourceTaskFactory.getLastSelection((FileObject)file);
        if (selection == null) {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)IntroduceHint.class.getName(), Collections.emptyList());
        } else {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)IntroduceHint.class.getName(), IntroduceHint.computeError(info, selection[0], selection[1], null, new EnumMap<IntroduceKind, String>(IntroduceKind.class), this.cancel));
            Document doc = info.getSnapshot().getSource().getDocument(false);
            if (doc != null) {
                PositionRefresherHelperImpl.setVersion(doc, selection[0], selection[1]);
            }
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    private static void addExpressionFixes(CompilationInfo info, int start, int end, List<Fix> fixes, Map<IntroduceKind, Fix> fixesMap, AtomicBoolean cancel) {
        TreePath resolved = IntroduceHint.validateSelection(info, start, end);
        if (resolved == null) {
            return;
        }
        TypeMirror exprType = info.getTrees().getTypeMirror(resolved);
        if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(exprType)) {
            return;
        }
        TreePathHandle h = TreePathHandle.create((TreePath)resolved, (CompilationInfo)info);
        TreePath method = TreeUtils.findMethod(resolved);
        boolean variableRewrite = resolved.getLeaf().getKind() == Tree.Kind.VARIABLE;
        TreePath value = !variableRewrite ? resolved : new TreePath(resolved, ((VariableTree)resolved.getLeaf()).getInitializer());
        boolean isVariable = TreeUtils.findStatement(resolved) != null && method != null && !variableRewrite;
        Set duplicatesForVariable = isVariable ? SourceUtils.computeDuplicates((CompilationInfo)info, (TreePath)resolved, (TreePath)method, (AtomicBoolean)cancel) : null;
        Set duplicatesForConstant = SourceUtils.computeDuplicates((CompilationInfo)info, (TreePath)resolved, (TreePath)new TreePath(info.getCompilationUnit()), (AtomicBoolean)cancel);
        Scope scope = info.getTrees().getScope(resolved);
        boolean statik = scope != null ? info.getTreeUtilities().isStaticContext(scope) : false;
        String guessedName = Utilities.varNameSuggestion((Tree)resolved.getLeaf());
        if (guessedName == null) {
            guessedName = "name";
        }
        Scope s = info.getTrees().getScope(resolved);
        CodeStyle cs = CodeStyle.getDefault((FileObject)info.getFileObject());
        IntroduceVariableFix variable = isVariable ? new IntroduceVariableFix(h, info.getJavaSource(), variableRewrite ? guessedName : org.netbeans.modules.java.hints.errors.Utilities.makeNameUnique(info, s, guessedName, cs.getLocalVarNamePrefix(), cs.getLocalVarNameSuffix()), duplicatesForVariable.size() + 1, IntroduceKind.CREATE_VARIABLE, TreePathHandle.create((TreePath)method, (CompilationInfo)info), end) : null;
        IntroduceFieldFix constant = IntroduceConstantFix.createConstant(resolved, info, value, guessedName, duplicatesForConstant.size() + 1, end, variableRewrite, cancel);
        IntroduceParameterFix parameter = isVariable ? new IntroduceParameterFix(h) : null;
        IntroduceFieldFix field = null;
        IntroduceExpressionBasedMethodFix methodFix = null;
        TreePath pathToClass = TreeUtils.findClass(resolved);
        if (method != null && !TreeUtils.isInAnnotationType(info, method)) {
            int[] initilizeIn = IntroduceHint.computeInitializeIn(info, resolved, duplicatesForConstant);
            if (statik) {
                initilizeIn[0] = initilizeIn[0] & 0xFFFFFFFB;
                initilizeIn[1] = initilizeIn[1] & 0xFFFFFFFB;
            }
            boolean allowFinalInCurrentMethod = false;
            if (TreeUtils.isConstructor(info, method)) {
                boolean bl = allowFinalInCurrentMethod = TreeUtils.findConstructors(info, method).size() == 1;
            }
            if (resolved.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                guessedName = org.netbeans.modules.java.hints.errors.Utilities.guessName(info, resolved, resolved.getParentPath(), cs.getFieldNamePrefix(), cs.getFieldNameSuffix());
            } else if (!variableRewrite && pathToClass != null) {
                guessedName = org.netbeans.modules.java.hints.errors.Utilities.makeNameUnique(info, info.getTrees().getScope(pathToClass), guessedName, statik ? cs.getStaticFieldNamePrefix() : cs.getFieldNamePrefix(), statik ? cs.getStaticFieldNameSuffix() : cs.getFieldNameSuffix());
            }
            Element el = info.getTrees().getElement(pathToClass);
            if (pathToClass != null && el != null && (el.getKind().isClass() || el.getKind().isInterface())) {
                field = new IntroduceFieldFix(h, info.getJavaSource(), guessedName, duplicatesForConstant.size() + 1, initilizeIn, statik, allowFinalInCurrentMethod, end, !variableRewrite, TreePathHandle.create((TreePath)pathToClass, (CompilationInfo)info));
            }
            if (!variableRewrite) {
                HashMap<TypeMirror, TreePathHandle> typeVar2Def = new HashMap<TypeMirror, TreePathHandle>();
                LinkedList<TreePathHandle> typeVars = new LinkedList<TreePathHandle>();
                IntroduceHint.prepareTypeVars(method, info, typeVar2Def, typeVars);
                ScanStatement scanner = new ScanStatement(info, resolved.getLeaf(), resolved.getLeaf(), typeVar2Def, Collections.emptyMap(), cancel);
                Element methodEl = info.getTrees().getElement(method);
                if (methodEl != null && (methodEl.getKind() == ElementKind.METHOD || methodEl.getKind() == ElementKind.CONSTRUCTOR)) {
                    ExecutableElement ee = (ExecutableElement)methodEl;
                    scanner.localVariables.addAll(ee.getParameters());
                }
                scanner.scan(method, null);
                LinkedList<TreePathHandle> params = new LinkedList<TreePathHandle>();
                boolean error186980 = false;
                for (VariableElement ve : scanner.usedLocalVariables.keySet()) {
                    TreePath path = info.getTrees().getPath(ve);
                    if (path == null) {
                        error186980 = true;
                        Logger.getLogger(IntroduceHint.class.getName()).warning("Cannot get TreePath for local variable " + ve + "\nfile=" + info.getFileObject().getPath());
                        continue;
                    }
                    params.add(TreePathHandle.create((TreePath)path, (CompilationInfo)info));
                }
                if (!error186980) {
                    HashSet exceptions = new HashSet(info.getTreeUtilities().getUncaughtExceptions(resolved));
                    HashSet<TypeMirrorHandle> exceptionHandles = new HashSet<TypeMirrorHandle>();
                    for (TypeMirror tm : exceptions) {
                        exceptionHandles.add(TypeMirrorHandle.create((TypeMirror)tm));
                    }
                    Pattern p = Pattern.createPatternWithRemappableVariables((TreePath)resolved, scanner.usedLocalVariables.keySet(), (boolean)true);
                    Collection duplicates = Matcher.create((CompilationInfo)info).setCancel(cancel).match(p);
                    int duplicatesCount = duplicates.size();
                    typeVars.retainAll(scanner.usedTypeVariables);
                    AtomicBoolean allIfaces = new AtomicBoolean();
                    List<TargetDescription> viableTargets = IntroduceExpressionBasedMethodFix.computeViableTargets(info, resolved.getParentPath(), Collections.singleton(resolved.getLeaf()), duplicates, cancel, allIfaces);
                    if (viableTargets != null && !viableTargets.isEmpty()) {
                        TypeMirror returnType = org.netbeans.modules.java.hints.errors.Utilities.convertIfAnonymous(org.netbeans.modules.java.hints.errors.Utilities.resolveCapturedType(info, IntroduceHint.resolveType(info, resolved)));
                        methodFix = new IntroduceExpressionBasedMethodFix(info.getJavaSource(), h, params, TypeMirrorHandle.create((TypeMirror)returnType), exceptionHandles, duplicatesCount, typeVars, end, viableTargets);
                        methodFix.setTargetIsInterface(allIfaces.get());
                    }
                }
            }
        }
        if (fixesMap != null) {
            fixesMap.put(IntroduceKind.CREATE_VARIABLE, variable);
            fixesMap.put(IntroduceKind.CREATE_CONSTANT, constant);
            fixesMap.put(IntroduceKind.CREATE_FIELD, field);
            fixesMap.put(IntroduceKind.CREATE_METHOD, methodFix);
            fixesMap.put(IntroduceKind.CREATE_PARAMETER, parameter);
        }
        if (variable != null) {
            fixes.add(variable);
        }
        if (constant != null) {
            fixes.add(constant);
        }
        if (field != null) {
            fixes.add(field);
        }
        if (methodFix != null) {
            fixes.add(methodFix);
        }
        if (parameter != null) {
            fixes.add(parameter);
        }
    }

    public static List<ErrorDescription> computeError(CompilationInfo info, int start, int end, Map<IntroduceKind, Fix> fixesMap, Map<IntroduceKind, String> errorMessage, AtomicBoolean cancel) {
        LinkedList<ErrorDescription> hints = new LinkedList<ErrorDescription>();
        LinkedList<Fix> fixes = new LinkedList<Fix>();
        IntroduceHint.addExpressionFixes(info, start, end, fixes, fixesMap, cancel);
        Fix introduceMethod = IntroduceMethodFix.computeIntroduceMethod(info, start, end, errorMessage, cancel);
        if (introduceMethod != null) {
            fixes.add(introduceMethod);
            if (fixesMap != null) {
                fixesMap.put(IntroduceKind.CREATE_METHOD, introduceMethod);
            }
        }
        if (!fixes.isEmpty()) {
            int pos = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
            String displayName = NbBundle.getMessage(IntroduceHint.class, (String)"HINT_Introduce");
            hints.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)displayName, fixes, (FileObject)info.getFileObject(), (int)pos, (int)pos));
        }
        return hints;
    }

    private static int[] computeInitializeIn(CompilationInfo info, TreePath firstOccurrence, Set<TreePath> occurrences) {
        class Result
        extends RuntimeException {
            Result() {
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return null;
            }
        }
        int[] result = new int[]{7, 7};
        boolean inOneMethod = true;
        Tree currentMethod = TreeUtils.findMethod(firstOccurrence).getLeaf();
        for (TreePath occurrence : occurrences) {
            TreePath method = TreeUtils.findMethod(occurrence);
            if (method != null && currentMethod == method.getLeaf()) continue;
            inOneMethod = false;
            break;
        }
        boolean referencesLocalvariables = false;
        try {
            class ReferencesLocalVariable
            extends TreePathScanner<Void, Void> {
                final /* synthetic */ CompilationInfo val$info;

                ReferencesLocalVariable(CompilationInfo compilationInfo) {
                    this.val$info = compilationInfo;
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element e = this.val$info.getTrees().getElement(this.getCurrentPath());
                    if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                        throw new Result();
                    }
                    return null;
                }
            }
            new ReferencesLocalVariable(info).scan(firstOccurrence, null);
        }
        catch (Result r) {
            referencesLocalvariables = true;
        }
        if (!inOneMethod) {
            result[1] = 6;
        }
        if (referencesLocalvariables) {
            result[0] = 1;
            result[1] = 1;
        }
        return result;
    }

    static List<ExpressionTree> realArguments(TreeMaker make, List<VariableElement> parameters) {
        LinkedList<ExpressionTree> realArguments = new LinkedList<ExpressionTree>();
        for (VariableElement p : parameters) {
            realArguments.add(make.Identifier((CharSequence)p.getSimpleName()));
        }
        return realArguments;
    }

    static List<ExpressionTree> realArgumentsForTrees(TreeMaker make, List<Union2<VariableElement, TreePath>> parameters) {
        LinkedList<ExpressionTree> realArguments = new LinkedList<ExpressionTree>();
        for (Union2<VariableElement, TreePath> p : parameters) {
            if (p.hasFirst()) {
                realArguments.add(make.Identifier((CharSequence)((VariableElement)p.first()).getSimpleName()));
                continue;
            }
            realArguments.add((ExpressionTree)((TreePath)p.second()).getLeaf());
        }
        return realArguments;
    }

    static List<VariableTree> createVariables(WorkingCopy copy, List<VariableElement> parameters, TreePath targetParent, List<TreePath> statements) {
        TreeMaker make = copy.getTreeMaker();
        LinkedList<VariableTree> formalArguments = new LinkedList<VariableTree>();
        CodeStyle cs = CodeStyle.getDefault((FileObject)copy.getFileObject());
        String prefix = cs.getParameterNamePrefix();
        String suffix = cs.getParameterNameSuffix();
        HashMap<VariableElement, CharSequence> renamedVariables = new HashMap<VariableElement, CharSequence>();
        HashSet<Name> changedNames = new HashSet<Name>();
        for (VariableElement p : parameters) {
            String strippedName;
            CharSequence codeStyleName;
            TypeMirror tm = p.asType();
            Tree type = make.Type(tm);
            Name formalArgName = p.getSimpleName();
            EnumSet<Modifier> formalArgMods = EnumSet.noneOf(Modifier.class);
            if (p.getModifiers().contains((Object)Modifier.FINAL)) {
                formalArgMods.add(Modifier.FINAL);
            }
            if (!formalArgName.contentEquals(codeStyleName = org.netbeans.modules.java.hints.errors.Utilities.guessName((CompilationInfo)copy, strippedName = org.netbeans.modules.java.hints.errors.Utilities.stripVariableName(cs, p), targetParent, prefix, suffix, p.getKind() == ElementKind.PARAMETER))) {
                renamedVariables.put(p, codeStyleName);
                changedNames.add(formalArgName);
            } else {
                codeStyleName = formalArgName;
            }
            formalArguments.add(make.Variable(make.Modifiers(formalArgMods), codeStyleName, type, null));
        }
        if (!changedNames.isEmpty()) {
            VariableRenamer renamer = new VariableRenamer(copy, renamedVariables, changedNames);
            for (TreePath stPath : statements) {
                renamer.scan(stPath, null);
            }
        }
        return formalArguments;
    }

    static List<ExpressionTree> typeHandleToTree(WorkingCopy copy, Set<TypeMirrorHandle> thrownTypes) {
        TreeMaker make = copy.getTreeMaker();
        LinkedList<ExpressionTree> thrown = new LinkedList<ExpressionTree>();
        for (TypeMirrorHandle h : thrownTypes) {
            TypeMirror t = h.resolve((CompilationInfo)copy);
            if (t == null) {
                return null;
            }
            thrown.add((ExpressionTree)make.Type(t));
        }
        return thrown;
    }

    static final OffsetsBag introduceBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(IntroduceHint.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(IntroduceHint.class, bag);
        }
        return bag;
    }

    static List<VariableElement> resolveVariables(CompilationInfo info, Collection<? extends TreePathHandle> handles) {
        LinkedList<VariableElement> vars = new LinkedList<VariableElement>();
        for (TreePathHandle treePathHandle : handles) {
            vars.add((VariableElement)treePathHandle.resolveElement(info));
        }
        return vars;
    }

    static void prepareTypeVars(TreePath method, CompilationInfo info, Map<TypeMirror, TreePathHandle> typeVar2Def, List<TreePathHandle> typeVars) throws IllegalArgumentException {
        if (method.getLeaf().getKind() == Tree.Kind.METHOD) {
            MethodTree mt = (MethodTree)method.getLeaf();
            for (TypeParameterTree typeParameterTree : mt.getTypeParameters()) {
                TreePath def = new TreePath(method, typeParameterTree);
                TypeMirror type = info.getTrees().getTypeMirror(def);
                if (type == null || type.getKind() != TypeKind.TYPEVAR) continue;
                TreePathHandle tph = TreePathHandle.create((TreePath)def, (CompilationInfo)info);
                typeVar2Def.put(type, tph);
                typeVars.add(tph);
            }
        }
    }

    static boolean needsStaticRelativeTo(CompilationInfo info, TreePath targetClass, TreePath occurrence) {
        while (occurrence != null && targetClass.getLeaf() != occurrence.getLeaf()) {
            switch (occurrence.getLeaf().getKind()) {
                case METHOD: {
                    if (!((MethodTree)occurrence.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) break;
                    return true;
                }
                case BLOCK: {
                    if (!((BlockTree)occurrence.getLeaf()).isStatic()) break;
                    return true;
                }
                case INTERFACE: {
                    return true;
                }
            }
            occurrence = occurrence.getParentPath();
        }
        return false;
    }

    static void removeFromParent(WorkingCopy parameter, TreePath what) throws IllegalAccessException {
        Tree newParent;
        TreeMaker make = parameter.getTreeMaker();
        Tree parentTree = what.getParentPath().getLeaf();
        Tree original = what.getLeaf();
        switch (parentTree.getKind()) {
            case BLOCK: {
                newParent = make.removeBlockStatement((BlockTree)parentTree, (StatementTree)original);
                break;
            }
            case CASE: {
                newParent = make.removeCaseStatement((CaseTree)parentTree, (StatementTree)original);
                break;
            }
            case INTERFACE: 
            case CLASS: 
            case ENUM: {
                newParent = make.removeClassMember((ClassTree)parentTree, original);
                break;
            }
            default: {
                throw new IllegalAccessException(parentTree.getKind().toString());
            }
        }
        parameter.rewrite(parentTree, newParent);
    }

    public static TreePath getStatementOrBlock(TreePath firstLeaf) {
        switch (firstLeaf.getParentPath().getLeaf().getKind()) {
            case BLOCK: 
            case CASE: {
                return firstLeaf.getParentPath();
            }
        }
        return firstLeaf;
    }

    public static List<? extends StatementTree> getStatements(TreePath firstLeaf) {
        switch (firstLeaf.getParentPath().getLeaf().getKind()) {
            case BLOCK: {
                return ((BlockTree)firstLeaf.getParentPath().getLeaf()).getStatements();
            }
            case CASE: {
                return ((CaseTree)firstLeaf.getParentPath().getLeaf()).getStatements();
            }
        }
        return Collections.singletonList((StatementTree)firstLeaf.getLeaf());
    }

    private static Map<Tree, TreePath> createTree2TreePathMap(TreePath pathToClass) {
        IdentityHashMap<Tree, TreePath> classNormalization = new IdentityHashMap<Tree, TreePath>();
        for (TreePath temp = pathToClass; temp != null; temp = temp.getParentPath()) {
            classNormalization.put(temp.getLeaf(), temp);
        }
        return classNormalization;
    }

    static TreePath findTargetClassWithDuplicates(TreePath pathToClass, Collection<TreePath> duplicates) {
        TreePath targetClassWithDuplicates = pathToClass;
        Map<Tree, TreePath> classNormalization = IntroduceHint.createTree2TreePathMap(pathToClass);
        Iterator<TreePath> iterator = duplicates.iterator();
        block0: while (iterator.hasNext()) {
            for (TreePath p = iterator.next(); p != null; p = p.getParentPath()) {
                if (!classNormalization.containsKey(p.getLeaf())) continue;
                targetClassWithDuplicates = p;
                classNormalization = IntroduceHint.createTree2TreePathMap(targetClassWithDuplicates);
                continue block0;
            }
        }
        assert (targetClassWithDuplicates != null);
        while (targetClassWithDuplicates != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)targetClassWithDuplicates.getLeaf().getKind())) {
            targetClassWithDuplicates = targetClassWithDuplicates.getParentPath();
        }
        if (targetClassWithDuplicates == null) {
            targetClassWithDuplicates = pathToClass;
        }
        return targetClassWithDuplicates;
    }

    static ClassTree insertField(final WorkingCopy parameter, ClassTree clazz, VariableTree fieldToAdd, Set<Tree> allNewUses, int offset) {
        Set<Modifier> mod;
        ClassTree nueClass = INSERT_CLASS_MEMBER.insertClassMember(parameter, clazz, fieldToAdd, offset);
        int i = 0;
        int insertLocation = -1;
        boolean newFieldStatic = fieldToAdd.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        for (Tree tree : nueClass.getMembers()) {
            class Contains
            extends TreeScanner<Boolean, Set<Tree>> {
                Contains() {
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                }

                @Override
                public Boolean scan(Tree tree, Set<Tree> searchFor) {
                    if (tree != null && searchFor.contains(tree)) {
                        return true;
                    }
                    return (Boolean)super.scan(tree, searchFor);
                }
            }
            ++i;
            if (tree.getKind() == Tree.Kind.VARIABLE) {
                VariableTree field = (VariableTree)tree;
                if (field.getModifiers().getFlags().contains((Object)Modifier.STATIC) ^ newFieldStatic || new Contains().scan((Tree)field.getInitializer(), allNewUses) != Boolean.TRUE) {
                    continue;
                }
            } else if (tree.getKind() == Tree.Kind.BLOCK) {
                BlockTree block = (BlockTree)tree;
                if (block.isStatic() ^ newFieldStatic || new Contains().scan((Tree)block, allNewUses) != Boolean.TRUE) {
                    continue;
                }
            } else {
                if (tree != fieldToAdd) continue;
                break;
            }
            insertLocation = i - 1;
            break;
        }
        if (clazz.getKind() == Tree.Kind.INTERFACE && !(mod = fieldToAdd.getModifiers().getFlags()).isEmpty()) {
            mod = EnumSet.copyOf(mod);
            EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED);
            if (mod.removeAll(EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED))) {
                mod.add(Modifier.PUBLIC);
                ModifiersTree mtt = parameter.getTreeMaker().Modifiers(mod, fieldToAdd.getModifiers().getAnnotations());
                parameter.rewrite((Tree)fieldToAdd.getModifiers(), (Tree)mtt);
            }
        }
        TreePath clazzPath = TreePath.getPath(parameter.getCompilationUnit(), (Tree)clazz);
        final Set set = Collections.newSetFromMap(new IdentityHashMap());
        final boolean statik = fieldToAdd.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                this.handleCurrentPath();
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void p) {
                this.handleCurrentPath();
                return (Void)super.visitMemberSelect(node, p);
            }

            private void handleCurrentPath() {
                Element el = parameter.getTrees().getElement(this.getCurrentPath());
                if (el != null && el.getKind().isField() && el.getModifiers().contains((Object)Modifier.STATIC) == statik) {
                    set.add(el);
                }
            }
        }.scan(new TreePath(clazzPath, fieldToAdd), (Void)null);
        ArrayList<? extends Tree> nueMembers = new ArrayList<Tree>(nueClass.getMembers());
        Collections.reverse(nueMembers);
        i = nueMembers.size() - 1;
        for (Tree tree : nueMembers) {
            Element el = parameter.getTrees().getElement(new TreePath(clazzPath, tree));
            if (el != null && set.contains(el)) {
                insertLocation = i;
                break;
            }
            if (tree != fieldToAdd && --i >= insertLocation) continue;
            break;
        }
        if (insertLocation != -1) {
            nueClass = parameter.getTreeMaker().insertClassMember(clazz, insertLocation, (Tree)fieldToAdd);
        }
        return nueClass;
    }

    static TypeMirror resolveType(CompilationInfo info, TreePath path) {
        TypeMirror tm = info.getTrees().getTypeMirror(path);
        if (tm != null && tm.getKind() == TypeKind.NULL) {
            TypeElement object;
            List<? extends TypeMirror> targetType = CreateElementUtilities.resolveType(new HashSet<ElementKind>(), info, path.getParentPath(), path.getLeaf(), (int)info.getTrees().getSourcePositions().getStartPosition(path.getCompilationUnit(), path.getLeaf()), new TypeMirror[1], new int[1]);
            tm = targetType != null && !targetType.isEmpty() ? targetType.get(0) : ((object = info.getElements().getTypeElement("java.lang.Object")) != null ? object.asType() : null);
        }
        return tm;
    }

    static boolean shouldReplaceDuplicate(final Document doc, final int startOff, final int endOff) {
        IntroduceHint.introduceBag(doc).clear();
        IntroduceHint.introduceBag(doc).addHighlight(startOff, endOff, DUPE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextComponent c = EditorRegistry.lastFocusedComponent();
                if (c != null && c.getDocument() == doc) {
                    try {
                        Rectangle start = c.modelToView(startOff);
                        Rectangle end = c.modelToView(endOff);
                        int sx = Math.min(start.x, end.x);
                        int dx = Math.max(start.x + start.width, end.x + end.width);
                        int sy = Math.min(start.y, end.y);
                        int dy = Math.max(start.y + start.height, end.y + end.height);
                        c.scrollRectToVisible(new Rectangle(sx, sy, dx - sx, dy - sy));
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
        String title = NbBundle.getMessage(IntroduceHint.class, (String)"TTL_DuplicateMethodPiece");
        String message = NbBundle.getMessage(IntroduceHint.class, (String)"MSG_DuplicateMethodPiece");
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, title, 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION;
    }

    static class InsertClassMember {
        InsertClassMember() {
        }

        public ClassTree insertClassMember(WorkingCopy wc, ClassTree clazz, Tree member, int offset) throws IllegalStateException {
            return GeneratorUtils.insertClassMember((WorkingCopy)wc, (ClassTree)clazz, (Tree)member, (int)offset);
        }
    }

    public static final class HLFImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)IntroduceHint.class.getName(), (ZOrder)ZOrder.TOP_RACK.forPosition(500), (boolean)true, (HighlightsContainer)IntroduceHint.introduceBag(context.getDocument()))};
        }
    }

    static class VariableRenamer
    extends TreePathScanner {
        private final Map<VariableElement, CharSequence> renamedVars;
        private final Set<Name> changedNames;
        private final WorkingCopy info;

        public VariableRenamer(WorkingCopy info, Map<VariableElement, CharSequence> renamedVars, Set<Name> changedNames) {
            this.renamedVars = renamedVars;
            this.changedNames = changedNames;
            this.info = info;
        }

        @Override
        public Object visitIdentifier(IdentifierTree node, Object p) {
            Element e;
            CharSequence nn;
            if (this.changedNames.contains(node.getName()) && (nn = this.renamedVars.get(e = this.info.getTrees().getElement(this.getCurrentPath()))) != null) {
                this.info.rewrite((Tree)node, (Tree)this.info.getTreeMaker().Identifier(nn));
            }
            return super.visitIdentifier(node, p);
        }
    }
}

