/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.ui;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class DirectoryChooser
extends JPanel
implements PropertyChangeListener {
    public static final String VALID_SELECTION = "validSelectionProperty";
    private final JFileChooser chooser;
    private final JButton selectButton;
    private FileObject validatedFileObject = null;
    private Dialog dialog;
    private JPanel chooserPanel;

    public static FileObject chooseDirectory(Frame window, ExecutionEnvironment env, String initPath) {
        DirectoryChooser chooser = new DirectoryChooser(env, initPath);
        boolean cancelled = false;
        DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(DirectoryChooser.class, (String)"DirectoryChooser.title", (Object)env.getDisplayName()), true, new Object[]{chooser.selectButton, DialogDescriptor.CANCEL_OPTION}, (Object)chooser.selectButton, 0, null, null, true);
        chooser.dialog = DialogDisplayer.getDefault().createDialog(dd);
        chooser.dialog.setVisible(true);
        chooser.dialog.dispose();
        chooser.dialog = null;
        if (!cancelled && chooser.selectButton.equals(dd.getValue())) {
            return chooser.validatedFileObject;
        }
        return null;
    }

    private DirectoryChooser(ExecutionEnvironment env, String path) {
        this.initComponents();
        this.selectButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.selectButton, (String)NbBundle.getMessage(DirectoryChooser.class, (String)"DirectoryChooser.ok_button.text"));
        FileChooserBuilder fcBuilder = new FileChooserBuilder(env);
        this.chooser = fcBuilder.createFileChooser();
        this.chooser.setFileSelectionMode(1);
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(DirectoryChooser.class, (String)"DirectoryChooser.fileFilter.description");
            }
        });
        this.chooser.addPropertyChangeListener(this);
        this.chooser.setFocusCycleRoot(false);
        this.chooserPanel.add(this.chooser);
        this.chooser.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "esc_pressed");
        this.chooser.getActionMap().put("esc_pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (DirectoryChooser.this.dialog != null) {
                    DirectoryChooser.this.dialog.setVisible(false);
                }
            }
        });
        if (path != null && !path.isEmpty()) {
            this.chooser.setCurrentDirectory(new File(path));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.chooser.rescanCurrentDirectory();
    }

    private void initComponents() {
        this.chooserPanel = new JPanel();
        this.chooserPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.chooserPanel, -1, 376, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.chooserPanel, -1, 276, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("SelectedFileChangedProperty")) {
            this.checkForm();
        }
    }

    private void checkForm() {
        File selection = this.chooser.getSelectedFile();
        if (selection != null) {
            FileObject fo = FileSystemProvider.fileToFileObject((File)selection);
            if (fo.canRead()) {
                this.validatedFileObject = fo;
                this.firePropertyChange(VALID_SELECTION, null, (Object)true);
                this.selectButton.setEnabled(true);
            } else {
                this.firePropertyChange(VALID_SELECTION, null, (Object)false);
                this.selectButton.setEnabled(false);
            }
        }
    }
}

