/**
 * The Event interface is used to provide contextual information about an event to the handler processing the event. An object which implements the Event interface is generally passed as the first parameter to an event handler. More specific context information is passed to event handlers by deriving additional interfaces from Event which contain information directly relating to the type of event they accompany. These derived interfaces are also implemented by the object passed to the event listener.
 */
var Event = {
}
/**
 * Used to specify the time (in milliseconds relative to the epoch) at which the event was created. Due to the fact that some systems may not provide this information the value of timeStamp may be not available for all events. When not available, a value of 0 will be returned. Examples of epoch time are the time of the system start or 0:0:0 UTC 1st January 1970.
 * @syntax event.timeStamp
 * @returns {DOMTimeStamp} 
 */
Event.prototype.timeStamp = new DOMTimeStamp();

/**
 * The current event phase is the bubbling phase.
 * @syntax Event.BUBBLING_PHASE
 * @returns {Number} 
 * @static
 */
Event.BUBBLING_PHASE = new Number();

/**
 * The stopPropagation method is used prevent further propagation of an event during event flow.
 * @syntax event.stopPropagation()
 * @returns {undefined} 
 */
Event.prototype.stopPropagation = function() {};

/**
 * Used to indicate the EventTarget whose EventListeners are currently being processed. This is particularly useful during capturing and bubbling.
 * @syntax event.currentTarget
 * @returns {EventTarget} 
 */
Event.prototype.currentTarget = new EventTarget();

/**
 * Used to indicate which phase of event flow is currently being evaluated.
 * @syntax event.eventPhase
 * @returns {Number} 
 */
Event.prototype.eventPhase = new Number();

/**
 * Used to indicate whether or not an event is a bubbling event. If the event can bubble the value is true, else the value is false.
 * @syntax event.bubbles
 * @returns {boolean} 
 */
Event.prototype.bubbles = new boolean();

/**
 * The event is currently being evaluated at the target EventTarget.
 * @syntax Event.AT_TARGET
 * @returns {Number} 
 * @static
 */
Event.AT_TARGET = new Number();

/**
 * The name of the event (case-insensitive). The name must be an XML name.
 * @syntax event.type
 * @returns {String} 
 */
Event.prototype.type = new String();

/**
 * The initEvent method is used to initialize the value of an Event created through the DocumentEvent interface. This method may only be called before the Event has been dispatched via the dispatchEvent method, though it may be called multiple times during that phase if necessary. If called multiple times the final invocation takes precedence. If called from a subclass of Event interface only the values specified in the initEvent method are modified, all other attributes are left unchanged.
 * @syntax event.initEvent(eventTypeArg, canBubbleArg, cancelableArg)
 * @param {String} eventTypeArg Specifies the event type. This type may be any event type currently defined in this specification or a new event type.. The string must be an XML name. Any new event type must not begin with any upper, lower, or mixed case version of the string "DOM". This prefix is reserved for future DOM event sets. It is also strongly recommended that third parties adding their own events use their own prefix to avoid confusion and lessen the probability of conflicts with other new events.
 * @param {boolean} canBubbleArg Specifies whether or not the event can bubble.
 * @param {boolean} cancelableArg Specifies whether or not the event's default action can be prevented.
 * @returns {undefined} 
 */
Event.prototype.initEvent = function(eventTypeArg,  canBubbleArg,  cancelableArg) {};

/**
 * The current event phase is the capturing phase.
 * @syntax Event.CAPTURING_PHASE
 * @returns {Number} 
 * @static
 */
Event.CAPTURING_PHASE = new Number();

/**
 * Used to indicate the EventTarget to which the event was originally dispatched.
 * @syntax event.target
 * @returns {EventTarget} 
 */
Event.prototype.target = new EventTarget();

/**
 * Used to indicate whether or not an event can have its default action prevented. If the default action can be prevented the value is true, else the value is false.
 * @syntax event.cancelable
 * @returns {boolean} 
 */
Event.prototype.cancelable = new boolean();

/**
 * If an event is cancelable, the preventDefault method is used to signify that the event is to be canceled, meaning any default action normally taken by the implementation as a result of the event will not occur. If, during any stage of event flow,
 * @syntax event.preventDefault()
 * @returns {undefined} 
 */
Event.prototype.preventDefault = function() {};

/**
 * Represents the Event prototype object.
 * @syntax Event.prototype
 * @static
 */
Event.prototype;

