/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Edge {
    private final String child;
    private final String parent;

    public Edge(@Nonnull String child, @Nullable String parent) {
        this.child = (String)Preconditions.checkNotNull((Object)child);
        this.parent = parent;
    }

    @Deprecated
    @Nonnull
    public String getChild() {
        return this.child;
    }

    @Nonnull
    public String getChildName() {
        return this.child;
    }

    @Deprecated
    @Nullable
    public String getParent() {
        return this.parent;
    }

    public Optional<String> getParentName() {
        return Optional.ofNullable(this.parent);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Edge").add("child", (Object)this.child).add("parent", (Object)this.parent).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.child, this.parent});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equal((Object)this.child, (Object)other.child) && Objects.equal((Object)this.parent, (Object)other.parent);
    }
}

