/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class PropertyAssertionValueShortFormProvider
implements ShortFormProvider {
    @Nonnull
    private final List<OWLPropertyExpression> properties;
    private final Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap;
    private final OWLOntologySetProvider ontologySetProvider;
    private final ShortFormProvider alternateShortFormProvider;

    public PropertyAssertionValueShortFormProvider(@Nonnull List<OWLPropertyExpression> properties, @Nonnull Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap, @Nonnull OWLOntologySetProvider ontologySetProvider) {
        this(properties, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public PropertyAssertionValueShortFormProvider(@Nonnull List<OWLPropertyExpression> properties, @Nonnull Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap, @Nonnull OWLOntologySetProvider ontologySetProvider, @Nonnull ShortFormProvider alternateShortFormProvider) {
        this.properties = OWLAPIPreconditions.checkNotNull(properties, "properties cannot be null");
        this.preferredLanguageMap = OWLAPIPreconditions.checkNotNull(preferredLanguageMap, "preferredLanguageMap cannot be null");
        this.ontologySetProvider = OWLAPIPreconditions.checkNotNull(ontologySetProvider, "ontologySetProvider cannot be null");
        this.alternateShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateShortFormProvider, "alternateShortFormProvider cannot be null");
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        if (!(entity instanceof OWLIndividual)) {
            return this.alternateShortFormProvider.getShortForm(entity);
        }
        OWLIndividual individual = (OWLIndividual)((Object)entity);
        OWLObject candidateValue = null;
        int lastURIMatchIndex = Integer.MAX_VALUE;
        int lastLangMatchIndex = Integer.MAX_VALUE;
        for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
            int index;
            for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : ontology.getObjectPropertyAssertionAxioms(individual)) {
                index = this.properties.indexOf(oWLObjectPropertyAssertionAxiom.getProperty());
                if (index == -1 || index >= lastURIMatchIndex) continue;
                candidateValue = (OWLObject)oWLObjectPropertyAssertionAxiom.getObject();
            }
            for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : ontology.getDataPropertyAssertionAxioms(individual)) {
                index = this.properties.indexOf(oWLDataPropertyAssertionAxiom.getProperty());
                if (index == -1) continue;
                if (index == lastURIMatchIndex) {
                    OWLLiteral lit;
                    int langIndex;
                    List<String> langList;
                    Object obj = oWLDataPropertyAssertionAxiom.getObject();
                    if (!(obj instanceof OWLLiteral) || (langList = this.preferredLanguageMap.get(oWLDataPropertyAssertionAxiom.getProperty())) == null || (langIndex = langList.indexOf((lit = (OWLLiteral)obj).getLang())) == -1 || langIndex >= lastLangMatchIndex) continue;
                    lastLangMatchIndex = langIndex;
                    candidateValue = (OWLObject)oWLDataPropertyAssertionAxiom.getObject();
                    continue;
                }
                if (index >= lastURIMatchIndex) continue;
                lastURIMatchIndex = index;
                candidateValue = (OWLObject)oWLDataPropertyAssertionAxiom.getObject();
            }
        }
        if (candidateValue != null) {
            return this.getRendering(candidateValue);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    @Nonnull
    private String getRendering(@Nonnull OWLObject object) {
        if (object instanceof OWLLiteral) {
            return ((OWLLiteral)object).getLiteral();
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<OWLPropertyExpression> getProperties() {
        return this.properties;
    }

    public Map<OWLDataPropertyExpression, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }
}

