/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.fillParagraph;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParagraphFillHandler {
    protected void performOnElement(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ParagraphFillHandler.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        TextRange textRange = this.getTextRange(element, editor);
        if (textRange.isEmpty()) {
            return;
        }
        String text = textRange.substring(element.getContainingFile().getText());
        List subStrings = StringUtil.split((String)text, (String)"\n", (boolean)true);
        String prefix = this.getPrefix(element);
        String postfix = this.getPostfix(element);
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPrefix(element, text, stringBuilder);
        for (String string : subStrings) {
            String startTrimmed = StringUtil.trimStart((String)string.trim(), (String)prefix.trim());
            String str = StringUtil.trimEnd((String)startTrimmed, (String)postfix.trim());
            String finalString = str.trim();
            if (StringUtil.isEmptyOrSpaces((String)finalString)) continue;
            stringBuilder.append(finalString).append(" ");
        }
        this.appendPostfix(element, text, stringBuilder);
        String replacementText = stringBuilder.toString();
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
            if (element == null) {
                ParagraphFillHandler.$$$reportNull$$$0(20);
            }
            if (editor == null) {
                ParagraphFillHandler.$$$reportNull$$$0(21);
            }
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replacementText);
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleSettingsManager.getSettings((Project)element.getProject()), element.getLanguage());
            PsiFile file2 = element.getContainingFile();
            FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyleSettingsManager.getSettings((Project)file2.getProject()));
            List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), TextRange.create((int)0, (int)document.getTextLength()));
            codeFormatter.doWrapLongLinesIfNecessary(editor, element.getProject(), document, textRange.getStartOffset(), textRange.getStartOffset() + replacementText.length() + 1, enabledRanges);
        }, null, (Object)document);
    }

    protected void appendPostfix(@NotNull PsiElement element, @NotNull String text, @NotNull StringBuilder stringBuilder) {
        String postfix;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            ParagraphFillHandler.$$$reportNull$$$0(3);
        }
        if (stringBuilder == null) {
            ParagraphFillHandler.$$$reportNull$$$0(4);
        }
        if (text.endsWith((postfix = this.getPostfix(element)).trim())) {
            stringBuilder.append(postfix);
        }
    }

    protected void appendPrefix(@NotNull PsiElement element, @NotNull String text, @NotNull StringBuilder stringBuilder) {
        String prefix;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(5);
        }
        if (text == null) {
            ParagraphFillHandler.$$$reportNull$$$0(6);
        }
        if (stringBuilder == null) {
            ParagraphFillHandler.$$$reportNull$$$0(7);
        }
        if (text.startsWith((prefix = this.getPrefix(element)).trim())) {
            stringBuilder.append(prefix);
        }
    }

    private TextRange getTextRange(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ParagraphFillHandler.$$$reportNull$$$0(9);
        }
        int startOffset = this.getStartOffset(element, editor);
        int endOffset = this.getEndOffset(element, editor);
        return new UnfairTextRange(startOffset, endOffset);
    }

    private int getStartOffset(@NotNull PsiElement element, @NotNull Editor editor) {
        int lineNumber;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            ParagraphFillHandler.$$$reportNull$$$0(11);
        }
        if (this.isBunchOfElement(element)) {
            PsiElement firstElement = this.getFirstElement(element);
            return firstElement != null ? firstElement.getTextRange().getStartOffset() : element.getTextRange().getStartOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element.getTextOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); --lineNumber) {
            String text = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text)) continue;
            ++lineNumber;
            break;
        }
        int lineStartOffset = lineNumber == document.getLineNumber(elementTextOffset) ? elementTextOffset : document.getLineStartOffset(lineNumber);
        String lineText = document.getText(TextRange.create((int)lineStartOffset, (int)document.getLineEndOffset(lineNumber)));
        int shift = StringUtil.findFirst((CharSequence)lineText, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        return lineStartOffset + shift;
    }

    protected boolean isBunchOfElement(PsiElement element) {
        return element instanceof PsiComment;
    }

    private int getEndOffset(@NotNull PsiElement element, @NotNull Editor editor) {
        int lineNumber;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            ParagraphFillHandler.$$$reportNull$$$0(13);
        }
        if (this.isBunchOfElement(element)) {
            PsiElement next = this.getLastElement(element);
            return next != null ? next.getTextRange().getEndOffset() : element.getTextRange().getEndOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element.getTextRange().getEndOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); ++lineNumber) {
            String text = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text)) continue;
            --lineNumber;
            break;
        }
        return document.getLineEndOffset(lineNumber);
    }

    @Nullable
    private PsiElement getFirstElement(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(14);
        }
        IElementType elementType = element.getNode().getElementType();
        PsiElement result2 = element;
        for (PsiElement prevSibling = element.getPrevSibling(); prevSibling != null && (prevSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(prevSibling) && StringUtil.countChars((CharSequence)prevSibling.getText(), (char)'\n') <= 1); prevSibling = prevSibling.getPrevSibling()) {
            String text = prevSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text = StringUtil.trimStart((String)text.trim(), (String)prefix.trim());
            text = StringUtil.trimEnd((String)text, (String)postfix);
            if (prevSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text)) break;
            if (!prevSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = prevSibling;
        }
        return result2;
    }

    @Nullable
    private PsiElement getLastElement(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(15);
        }
        IElementType elementType = element.getNode().getElementType();
        PsiElement result2 = element;
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null && (nextSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(nextSibling) && StringUtil.countChars((CharSequence)nextSibling.getText(), (char)'\n') <= 1); nextSibling = nextSibling.getNextSibling()) {
            String text = nextSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text = StringUtil.trimStart((String)text.trim(), (String)prefix.trim());
            text = StringUtil.trimEnd((String)text, (String)postfix);
            if (nextSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text)) break;
            if (!nextSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = nextSibling;
        }
        return result2;
    }

    protected boolean atWhitespaceToken(@Nullable PsiElement element) {
        return element instanceof PsiWhiteSpace;
    }

    protected boolean isAvailableForElement(@Nullable PsiElement element) {
        return element != null;
    }

    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof PsiPlainTextFile;
    }

    @NotNull
    protected String getPrefix(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(16);
        }
        if ("" == null) {
            ParagraphFillHandler.$$$reportNull$$$0(17);
        }
        return "";
    }

    @NotNull
    protected String getPostfix(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(18);
        }
        if ("" == null) {
            ParagraphFillHandler.$$$reportNull$$$0(19);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuilder";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostfix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performOnElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendPostfix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendPrefix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFirstElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLastElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPostfix";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performOnElement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

