/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0014\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u001a\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\b\u001a\u00020\u0003\"4\u0010\u0000\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"CHANGED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/StateStorage;", "kotlin.jvm.PlatformType", "askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "isApp", "reloadAppStore", "changes", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "configuration-store-impl"})
public final class StoreAwareProjectManagerKt {
    private static final Key<MultiMap<ComponentStoreImpl, StateStorage>> CHANGED_FILES_KEY = Key.create((String)"CHANGED_FILES_KEY");

    public static final boolean reloadAppStore(@NotNull Set<? extends StateStorage> changes) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreAwareProjectManagerKt.reloadStore(changes, (ComponentStoreImpl)iComponentStore);
        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.SUCCESS)) || Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_CANCELLED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@NotNull Set<? extends StateStorage> changedStorages, @NotNull ComponentStoreImpl store) {
        Collection<String> notReloadableComponents;
        boolean willBeReloaded;
        block11: {
            Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
            Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
            willBeReloaded = false;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents != null && !notReloadableComponents.isEmpty()) break block11;
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            for (StateStorage stateStorage : changedStorages) {
                if (!(stateStorage instanceof StateStorageBase)) continue;
                ((StateStorageBase)stateStorage).enableSaving();
            }
            return reloadComponentStoreStatus;
        }
        try {
            willBeReloaded = StoreAwareProjectManagerKt.askToRestart(store, notReloadableComponents, changedStorages, store.getProject$configuration_store_impl() == null);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project '" + ((IProjectStore)store).getProjectName() + '\'' : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)("" + storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final /* synthetic */ Key access$getCHANGED_FILES_KEY$p() {
        return CHANGED_FILES_KEY;
    }
}

