/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.windows;

import com.intellij.credentialStore.windows.W32API;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WindowsCryptUtils {
    private static final Map<String, Object> UNICODE_OPTIONS = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"type-mapper", (Object)W32APITypeMapper.UNICODE), (Pair[])new Pair[]{Pair.pair((Object)"function-mapper", (Object)W32APIFunctionMapper.UNICODE)});

    private WindowsCryptUtils() {
    }

    @NotNull
    public static byte[] protect(@NotNull byte[] data) {
        if (data == null) {
            WindowsCryptUtils.$$$reportNull$$$0(0);
        }
        if (data.length == 0) {
            if (data == null) {
                WindowsCryptUtils.$$$reportNull$$$0(1);
            }
            return data;
        }
        Memory input = new Memory((long)data.length);
        input.write(0L, data, 0, data.length);
        Crypt32.DATA_BLOB in = new Crypt32.DATA_BLOB();
        in.cbData = new W32API.DWORD(data.length);
        in.pbData = input;
        Crypt32.DATA_BLOB out = new Crypt32.DATA_BLOB();
        out.pbData = Pointer.NULL;
        Crypt32 crypt = Crypt32.INSTANCE;
        Kernel32 kernel = Kernel32.INSTANCE;
        boolean rc = crypt.CryptProtectData(in, "Master Key", Pointer.NULL, Pointer.NULL, Pointer.NULL, new W32API.DWORD(0L), out);
        byte[] byArray = WindowsCryptUtils.getBytes(out, kernel, rc);
        if (byArray == null) {
            WindowsCryptUtils.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    @NotNull
    public static byte[] unprotect(byte[] data) {
        if (data.length == 0) {
            if (data == null) {
                WindowsCryptUtils.$$$reportNull$$$0(3);
            }
            return data;
        }
        Memory input = new Memory((long)data.length);
        input.write(0L, data, 0, data.length);
        Crypt32.DATA_BLOB in = new Crypt32.DATA_BLOB();
        in.cbData = new W32API.DWORD(data.length);
        in.pbData = input;
        Crypt32.DATA_BLOB out = new Crypt32.DATA_BLOB();
        out.pbData = Pointer.NULL;
        Crypt32 crypt = Crypt32.INSTANCE;
        Kernel32 kernel = Kernel32.INSTANCE;
        boolean rc = crypt.CryptUnprotectData(in, Pointer.NULL, Pointer.NULL, Pointer.NULL, Pointer.NULL, new W32API.DWORD(0L), out);
        byte[] byArray = WindowsCryptUtils.getBytes(out, kernel, rc);
        if (byArray == null) {
            WindowsCryptUtils.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    private static byte[] getBytes(Crypt32.DATA_BLOB out, Kernel32 kernel, boolean rc) {
        if (!rc) {
            W32API.DWORD drc = kernel.GetLastError();
            throw new RuntimeException("CryptProtectData failed: " + drc.intValue());
        }
        byte[] output = new byte[out.cbData.intValue()];
        out.pbData.read(0L, output, 0, output.length);
        kernel.LocalFree(out.pbData);
        return output;
    }

    static /* synthetic */ Map access$000() {
        return UNICODE_OPTIONS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/credentialStore/windows/WindowsCryptUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/credentialStore/windows/WindowsCryptUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "protect";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unprotect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "protect";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class, (Map)WindowsCryptUtils.access$000());

        public Pointer LocalFree(Pointer var1);

        public W32API.DWORD GetLastError();
    }

    public static interface Crypt32
    extends StdCallLibrary {
        public static final Crypt32 INSTANCE = (Crypt32)Native.loadLibrary((String)"Crypt32", Crypt32.class, (Map)WindowsCryptUtils.access$000());

        public boolean CryptProtectData(DATA_BLOB var1, String var2, Pointer var3, Pointer var4, Pointer var5, W32API.DWORD var6, DATA_BLOB var7);

        public boolean CryptUnprotectData(DATA_BLOB var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, W32API.DWORD var6, DATA_BLOB var7);

        public static class DATA_BLOB
        extends Structure
        implements Structure.ByReference {
            private static final List __FIELDS = Arrays.asList("cbData", "pbData");
            public W32API.DWORD cbData;
            public Pointer pbData;

            protected List getFieldOrder() {
                return __FIELDS;
            }
        }
    }
}

