/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class DirectoryIndexImpl
extends DirectoryIndex {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;

    public DirectoryIndexImpl(@NotNull Project project) {
        if (project == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        this.subscribeToFileChanges();
        Disposer.register((Disposable)project, () -> {
            this.myDisposed = true;
            this.myRootIndex = null;
        });
        LowMemoryWatcher.register(() -> {
            RootIndex index = this.myRootIndex;
            if (index != null) {
                index.onLowMemory();
            }
        }, (Disposable)project);
    }

    protected void subscribeToFileChanges() {
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryIndexImpl.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$1", "fileTypesChanged"));
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                RootIndex rootIndex;
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((rootIndex = DirectoryIndexImpl.this.myRootIndex) != null && rootIndex.resetOnEvents(events)) {
                    DirectoryIndexImpl.this.myRootIndex = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$3", "after"));
            }
        });
    }

    protected void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(1);
        }
        Query<VirtualFile> query = this.getRootIndex().getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(2);
        }
        return query;
    }

    @NotNull
    private RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject, this.createRootInfoCache());
        }
        RootIndex rootIndex2 = rootIndex;
        if (rootIndex2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(3);
        }
        return rootIndex2;
    }

    protected RootIndex.InfoCache createRootInfoCache() {
        return new RootIndex.InfoCache(){
            private final ConcurrentIntObjectMap<DirectoryInfo> myInfoCache = ContainerUtil.createConcurrentIntObjectMap();

            @Override
            public void cacheInfo(@NotNull VirtualFile dir, @NotNull DirectoryInfo info) {
                if (dir == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (info == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.myInfoCache.put(((NewVirtualFile)dir).getId(), (Object)info);
            }

            @Override
            public DirectoryInfo getCachedInfo(@NotNull VirtualFile dir) {
                if (dir == null) {
                    4.$$$reportNull$$$0(2);
                }
                return (DirectoryInfo)this.myInfoCache.get(((NewVirtualFile)dir).getId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cacheInfo";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getCachedInfo";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public DirectoryInfo getInfoForDirectory(@NotNull VirtualFile dir) {
        DirectoryInfo info;
        if (dir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(4);
        }
        return (info = this.getInfoForFile(dir)).isInProject(dir) ? info : null;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(5);
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file2 instanceof NewVirtualFile)) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION;
            if (nonProjectDirectoryInfo == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(6);
            }
            return nonProjectDirectoryInfo;
        }
        DirectoryInfo directoryInfo = this.getRootIndex().getInfoForFile(file2);
        if (directoryInfo == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(7);
        }
        return directoryInfo;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(8);
        }
        if (info.isInModuleSource()) {
            return this.getRootIndex().getSourceRootType(info);
        }
        return null;
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(9);
        }
        this.checkAvailability();
        if (!(dir instanceof NewVirtualFile)) {
            return null;
        }
        return this.getRootIndex().getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(10);
        }
        this.checkAvailability();
        List<OrderEntry> list2 = this.getRootIndex().getOrderEntries(info);
        if (list2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module2) {
        if (module2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(12);
        }
        this.checkAvailability();
        Set<String> set2 = this.getRootIndex().getDependentUnloadedModules(module2);
        if (set2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(13);
        }
        return set2;
    }

    public void assertConsistency(DirectoryInfo info) {
        List<OrderEntry> entries = this.getOrderEntries(info);
        for (int i = 1; i < entries.size(); ++i) {
            assert (RootIndex.BY_OWNER_MODULE.compare(entries.get(i - 1), entries.get(i)) <= 0);
        }
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

