/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Function;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalFileSystemRefreshWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker");
    private static final Logger LOG_ATTRIBUTES = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker_Attributes");
    private final boolean myIsRecursive;
    private final Queue<NewVirtualFile> myRefreshQueue;
    private final List<VFileEvent> myFileEventSet;
    private volatile boolean myCancelled;
    private static final AtomicInteger myRequests = new AtomicInteger();
    private static final AtomicLong myTime = new AtomicLong();
    private static Function<VirtualFile, Boolean> ourCancellingCondition;

    LocalFileSystemRefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(0);
        }
        this.myRefreshQueue = new Queue(100);
        this.myFileEventSet = new ArrayList<VFileEvent>();
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)refreshRoot);
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        List<VFileEvent> list2 = this.myFileEventSet;
        if (list2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void cancel() {
        this.myCancelled = true;
    }

    public void scan() {
        NewVirtualFile root = (NewVirtualFile)this.myRefreshQueue.pullFirst();
        boolean rootDirty = root.isDirty();
        if (LOG.isDebugEnabled()) {
            LOG.debug("root=" + root + " dirty=" + rootDirty);
        }
        if (!rootDirty) {
            return;
        }
        NewVirtualFileSystem fs = root.getFileSystem();
        FileAttributes rootAttributes = fs.getAttributes((VirtualFile)root);
        if (rootAttributes == null) {
            LocalFileSystemRefreshWorker.addDeletionEventTo((VirtualFile)root, this.myFileEventSet);
            root.markClean();
            return;
        }
        if (rootAttributes.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        this.myRefreshQueue.addLast((Object)root);
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            LOG.debug("refresh cancelled");
        }
    }

    private void processQueue(NewVirtualFileSystem fs, PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            NewVirtualFile file2 = (NewVirtualFile)this.myRefreshQueue.pullFirst();
            boolean fileDirty = file2.isDirty();
            if (LOG.isTraceEnabled()) {
                LOG.trace("file=" + file2 + " dirty=" + fileDirty);
            }
            if (!fileDirty) continue;
            this.checkCancelled(file2);
            if (file2.isDirectory()) {
                boolean fullSync = ((VirtualDirectoryImpl)file2).allChildrenLoaded();
                if (fullSync) {
                    this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                } else {
                    this.partialDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                }
            } else {
                this.refreshFile(fs, persistence, (TObjectHashingStrategy<String>)strategy, file2);
            }
            if (!this.myIsRecursive && file2.isDirectory()) continue;
            file2.markClean();
        }
    }

    private void refreshFile(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, NewVirtualFile file2) {
        RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)file2, persistence, fs, null, Collections.singletonList(file2), strategy);
        refreshingFileVisitor.visit((VirtualFile)file2);
        this.myFileEventSet.addAll(refreshingFileVisitor.getEventSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullDirRefresh(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            Object[] children2;
            Object[] currentNames;
            Application application = ApplicationManager.getApplication();
            AccessToken token = application.acquireReadActionLock();
            try {
                if (application.isDisposed()) {
                    return;
                }
                currentNames = persistence.list((VirtualFile)dir);
                children2 = dir.getChildren();
            }
            finally {
                token.finish();
            }
            RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)dir, persistence, fs, null, Arrays.asList(children2), strategy);
            refreshingFileVisitor.visit((VirtualFile)dir);
            token = application.acquireReadActionLock();
            try {
                if (application.isDisposed()) {
                    return;
                }
                if (!Arrays.equals(currentNames, persistence.list((VirtualFile)dir)) || !Arrays.equals(children2, dir.getChildren())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("retry: " + (Object)((Object)dir));
                    continue;
                }
                this.myFileEventSet.addAll(refreshingFileVisitor.getEventSet());
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partialDirRefresh(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            List<String> wanted;
            Collection cached;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                cached = dir.getCachedChildren();
                wanted = dir.getSuspiciousNames();
            }
            finally {
                token.finish();
            }
            if (cached.isEmpty() && wanted.isEmpty()) {
                return;
            }
            RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)dir, persistence, fs, wanted, cached, strategy);
            refreshingFileVisitor.visit((VirtualFile)dir);
            token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("retry: " + (Object)((Object)dir));
                    continue;
                }
                this.myFileEventSet.addAll(refreshingFileVisitor.getEventSet());
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (stopAt == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(2);
        }
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            LocalFileSystemRefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)this.myRefreshQueue.pullFirst();
                LocalFileSystemRefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(NewVirtualFile file2) {
        file2.markClean();
        file2.markDirty();
    }

    static void setCancellingCondition(@Nullable Function<VirtualFile, Boolean> condition) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourCancellingCondition = condition;
    }

    private static void addDeletionEventTo(@NotNull VirtualFile file2, @NotNull Collection<VFileEvent> myFileEvents) {
        if (file2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(3);
        }
        if (myFileEvents == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(4);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete file=" + file2);
        }
        myFileEvents.add((VFileEvent)new VFileDeleteEvent(null, file2, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myFileEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkCancelled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDeletionEventTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RefreshingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<VFileEvent> myFileEvents = new ArrayList<VFileEvent>();
        private final Map<String, VirtualFile> myPersistentChildren;
        private final Set<String> myChildrenWeAreInterested;
        private final VirtualFile myFileOrDir;
        private final PersistentFS myPersistence;
        private final NewVirtualFileSystem myFs;

        RefreshingFileVisitor(VirtualFile fileOrDir, PersistentFS persistence, NewVirtualFileSystem fs, Collection<String> persistentChildrenToRefresh, Collection<VirtualFile> existingPersistentChildren, TObjectHashingStrategy<String> strategy) {
            this.myFileOrDir = fileOrDir;
            this.myPersistence = persistence;
            this.myFs = fs;
            this.myPersistentChildren = new THashMap(existingPersistentChildren.size(), strategy);
            this.myChildrenWeAreInterested = persistentChildrenToRefresh != null ? new THashSet(persistentChildrenToRefresh, strategy) : null;
            for (VirtualFile child : existingPersistentChildren) {
                String name = child.getName();
                this.myPersistentChildren.put(name, child);
                if (this.myChildrenWeAreInterested == null) continue;
                this.myChildrenWeAreInterested.add(name);
            }
        }

        private void addAttributeChangeEvent(@NotNull VirtualFile file2, @NotNull @VirtualFile.PropName String property, Object current, Object upToDate) {
            if (file2 == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(0);
            }
            if (property == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(1);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("update '" + property + "' file=" + file2);
            }
            this.myFileEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file2, property, current, upToDate, true));
        }

        private void addUpdateContentEvent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(2);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("update file=" + file2);
            }
            this.myFileEvents.add((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true));
        }

        private void addCreationEvent(@NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory) {
            if (parent == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(3);
            }
            if (childName == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(4);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("create parent=" + parent + " name=" + childName + " dir=" + isDirectory);
            }
            this.myFileEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, isDirectory, true));
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
            String name = file2.getName(file2.getNameCount() - 1).toString();
            if (this.acceptsFileName(name)) {
                boolean upToDateHidden;
                boolean currentHidden;
                boolean isWritable;
                NewVirtualFile child = (NewVirtualFile)this.myPersistentChildren.remove(name);
                if (child == null) {
                    this.addCreationEvent(this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent(), name, attrs.isDirectory());
                    return FileVisitResult.CONTINUE;
                }
                LocalFileSystemRefreshWorker.this.checkCancelled(child);
                boolean currentIsDirectory = child.isDirectory();
                boolean currentIsSymlink = child.is(VFileProperty.SYMLINK);
                boolean currentIsSpecial = child.is(VFileProperty.SPECIAL);
                if (currentIsDirectory != attrs.isDirectory() || currentIsSymlink != attrs.isSymbolicLink() || currentIsSpecial != attrs.isOther()) {
                    LocalFileSystemRefreshWorker.addDeletionEventTo((VirtualFile)child, this.myFileEvents);
                    this.addCreationEvent(this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent(), child.getName(), attrs.isDirectory());
                    child.markClean();
                    return FileVisitResult.CONTINUE;
                }
                String currentName = child.getName();
                if (!currentName.equals(name)) {
                    this.addAttributeChangeEvent((VirtualFile)child, "name", currentName, name);
                }
                if (!attrs.isDirectory()) {
                    if (this.myPersistence.getTimeStamp((VirtualFile)child) != attrs.lastModifiedTime().toMillis() || this.myPersistence.getLastRecordedLength((VirtualFile)child) != attrs.size()) {
                        this.addUpdateContentEvent((VirtualFile)child);
                        child.markClean();
                        return FileVisitResult.CONTINUE;
                    }
                } else if (LocalFileSystemRefreshWorker.this.myIsRecursive) {
                    LocalFileSystemRefreshWorker.this.myRefreshQueue.addLast((Object)child);
                }
                boolean currentWritable = this.myPersistence.isWritable((VirtualFile)child);
                if (attrs instanceof DosFileAttributes) {
                    DosFileAttributes dosFileAttributes = (DosFileAttributes)attrs;
                    isWritable = attrs.isDirectory() || !dosFileAttributes.isReadOnly();
                } else {
                    isWritable = attrs instanceof PosixFileAttributes ? ((PosixFileAttributes)attrs).permissions().contains((Object)PosixFilePermission.OWNER_WRITE) : file2.toFile().canWrite();
                }
                if (LOG_ATTRIBUTES.isDebugEnabled()) {
                    LOG_ATTRIBUTES.debug("file=" + file2 + " writable vfs=" + child.isWritable() + " persistence=" + currentWritable + " real=" + isWritable);
                }
                if (currentWritable != isWritable) {
                    this.addAttributeChangeEvent((VirtualFile)child, "writable", currentWritable, isWritable);
                }
                if (attrs instanceof DosFileAttributes && (currentHidden = child.is(VFileProperty.HIDDEN)) != (upToDateHidden = ((DosFileAttributes)attrs).isHidden())) {
                    this.addAttributeChangeEvent((VirtualFile)child, "HIDDEN", currentHidden, upToDateHidden);
                }
                if (attrs.isSymbolicLink()) {
                    String upToDateVfsTarget;
                    String currentTarget = child.getCanonicalPath();
                    String upToDateTarget = this.myFs.resolveSymLink((VirtualFile)child);
                    String string = upToDateVfsTarget = upToDateTarget != null ? FileUtil.toSystemIndependentName((String)upToDateTarget) : null;
                    if (!Comparing.equal((String)currentTarget, (String)upToDateVfsTarget)) {
                        this.addAttributeChangeEvent((VirtualFile)child, "symlink", currentTarget, upToDateVfsTarget);
                    }
                }
                if (!child.isDirectory()) {
                    child.markClean();
                }
            }
            return FileVisitResult.CONTINUE;
        }

        boolean acceptsFileName(String name) {
            return !VfsUtil.isBadName((String)name) && (this.myChildrenWeAreInterested == null || this.myChildrenWeAreInterested.contains(name));
        }

        public void visit(VirtualFile fileOrDir) {
            long started = System.nanoTime();
            try {
                Path path = Paths.get(fileOrDir.getPath(), new String[0]);
                if (fileOrDir.isDirectory()) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, this);
                } else {
                    this.visitFile(path, Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
                }
            }
            catch (AccessDeniedException path) {
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
            int requests = myRequests.incrementAndGet();
            long l = myTime.addAndGet(System.nanoTime() - started);
            if (requests % 1000 == 0) {
                System.out.println("refresh:" + myRequests + " for " + l / 1000000L + "ms");
            }
        }

        @NotNull
        List<VFileEvent> getEventSet() {
            if (!this.myPersistentChildren.isEmpty()) {
                for (VirtualFile child : this.myPersistentChildren.values()) {
                    LocalFileSystemRefreshWorker.addDeletionEventTo(child, this.myFileEvents);
                }
                this.myPersistentChildren.clear();
            }
            List<VFileEvent> list2 = this.myFileEvents;
            if (list2 == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$RefreshingFileVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$RefreshingFileVisitor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addAttributeChangeEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addUpdateContentEvent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addCreationEvent";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }
}

