/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolSelectDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.tools.ToolsPanel;
import com.intellij.tools.ToolsProjectConfig;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExternalToolsCheckinHandlerFactory
extends CheckinHandlerFactory {
    public static final Object NONE_TOOL = new Object();

    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        if (panel2 == null) {
            ExternalToolsCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            ExternalToolsCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        final ToolsProjectConfig config = ToolsProjectConfig.getInstance(panel2.getProject());
        CheckinHandler checkinHandler = new CheckinHandler(){

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                JLabel label = new JLabel(ToolsBundle.message("tools.after.commit.description", new Object[0]));
                ComboboxWithBrowseButton listComponent = new ComboboxWithBrowseButton();
                final JComboBox comboBox = listComponent.getComboBox();
                comboBox.setModel(new CollectionComboBoxModel(ExternalToolsCheckinHandlerFactory.getComboBoxElements(), null));
                comboBox.setRenderer(new ListCellRendererWrapper<Object>(){

                    public void customize(JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                        if (value instanceof ToolsGroup) {
                            this.setText(StringUtil.notNullize((String)((ToolsGroup)value).getName(), (String)ToolsBundle.message("tools.unnamed.group", new Object[0])));
                        } else if (value instanceof Tool) {
                            this.setText("  " + StringUtil.notNullize((String)((Tool)value).getName()));
                        } else {
                            this.setText(ToolsBundle.message("tools.list.item.none", new Object[0]));
                        }
                    }
                });
                listComponent.getButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ToolSelectDialog dialog2;
                        Object item = comboBox.getSelectedItem();
                        String id = null;
                        if (item instanceof Tool) {
                            id = ((Tool)item).getActionId();
                        }
                        if (!(dialog2 = new ToolSelectDialog(panel2.getProject(), id, new ToolsPanel())).showAndGet()) {
                            return;
                        }
                        comboBox.setModel(new CollectionComboBoxModel(ExternalToolsCheckinHandlerFactory.getComboBoxElements(), (Object)dialog2.getSelectedTool()));
                    }
                });
                BorderLayout layout = new BorderLayout();
                layout.setVgap(3);
                final JPanel panel22 = new JPanel(layout);
                panel22.add((Component)label, "North");
                panel22.add((Component)listComponent, "Center");
                listComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                if (comboBox.getItemCount() == 0 || comboBox.getItemCount() == 1 && comboBox.getItemAt(0) == NONE_TOOL) {
                    return null;
                }
                return new RefreshableOnComponent(){

                    public JComponent getComponent() {
                        return panel22;
                    }

                    public void refresh() {
                        String id = config.getAfterCommitToolsId();
                        if (id == null) {
                            comboBox.setSelectedIndex(-1);
                        } else {
                            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                                Object itemAt = comboBox.getItemAt(i);
                                if (!(itemAt instanceof Tool) || !id.equals(((Tool)itemAt).getActionId())) continue;
                                comboBox.setSelectedIndex(i);
                                return;
                            }
                        }
                    }

                    public void saveState() {
                        Object item = comboBox.getSelectedItem();
                        config.setAfterCommitToolId(item instanceof Tool ? ((Tool)item).getActionId() : null);
                    }

                    public void restoreState() {
                        this.refresh();
                    }
                };
            }

            public void checkinSuccessful() {
                String id = config.getAfterCommitToolsId();
                if (id == null) {
                    return;
                }
                DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> UIUtil.invokeAndWaitIfNeeded(() -> ToolAction.runTool(id, context)));
            }
        };
        if (checkinHandler == null) {
            ExternalToolsCheckinHandlerFactory.$$$reportNull$$$0(2);
        }
        return checkinHandler;
    }

    private static List<Object> getComboBoxElements() {
        SmartList result2 = new SmartList();
        ToolManager manager = ToolManager.getInstance();
        result2.add(NONE_TOOL);
        for (ToolsGroup group : manager.getGroups()) {
            result2.add(group);
            result2.addAll(manager.getTools(group.getName()));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ExternalToolsCheckinHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ExternalToolsCheckinHandlerFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

