/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class ChooseStacktraceDialog
extends DialogWrapper {
    private JList myList;
    private JPanel myPanel;
    private JPanel myEditorPanel;
    private AnalyzeStacktraceUtil.StacktraceEditorPanel myEditor;

    public ChooseStacktraceDialog(Project project, Task issue) {
        super(project, false);
        this.$$$setupUI$$$();
        this.setTitle("Choose Stacktrace to Analyze");
        Object[] comments = issue.getComments();
        ArrayList<Description> list = new ArrayList<Description>(comments.length + 1);
        String description = issue.getDescription();
        if (description != null) {
            list.add(new Description(description));
        }
        ContainerUtil.addAll(list, (Object[])comments);
        this.myList.setModel(new CollectionListModel(list));
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof Description) {
                    this.append("Description");
                } else {
                    this.append("Commented by " + ((Comment)value).getAuthor() + " (" + ((Comment)value).getDate() + ")");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/tasks/actions/ChooseStacktraceDialog$1", "customizeCellRenderer"));
            }
        });
        this.myEditor = AnalyzeStacktraceUtil.createEditorPanel((Project)project, (Disposable)this.myDisposable);
        this.myEditorPanel.add((Component)this.myEditor, "Center");
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object value = ChooseStacktraceDialog.this.myList.getSelectedValue();
                if (value instanceof Comment) {
                    ChooseStacktraceDialog.this.myEditor.setText(((Comment)value).getText());
                } else {
                    ChooseStacktraceDialog.this.myEditor.setText("");
                }
            }
        });
        this.myList.setSelectedValue(list.get(0), false);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public Comment[] getTraces() {
        return (Comment[])ArrayUtil.toObjectArray(Comment.class, (Object[])this.myList.getSelectedValues());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JBList jBList = new JBList();
        this.myList = jBList;
        jBList.setVisibleRowCount(4);
        jBScrollPane.setViewportView((Component)jBList);
        this.myEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class Description
    extends Comment {
        private final String myDescription;

        public Description(String description) {
            this.myDescription = description;
        }

        public String getText() {
            return this.myDescription;
        }

        public String getAuthor() {
            return null;
        }

        public Date getDate() {
            return null;
        }
    }
}

