/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader {
    static final String CLASS_EXTENSION = ".class";
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final WeakStringInterner myClassNameInterner;
    private final boolean myAllowBootstrapResources;

    protected static void markParallelCapable(Class<? extends UrlClassLoader> loaderClass) {
        assert (ourParallelCapableLoaders != null);
        ourParallelCapableLoaders.add(loaderClass);
    }

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath = this.myClassPath;
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        return classPath;
    }

    public List<URL> getBaseUrls() {
        return this.myClassPath.getBaseUrls();
    }

    public static Builder build() {
        return new Builder();
    }

    public UrlClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        this(UrlClassLoader.build().urls(((URLClassLoader)parent).getURLs()).parent(parent.getParent()).allowLock().useCache().usePersistentClasspathIndexForLocalClassDirectories());
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        super(builder.myParent);
        this.myURLs = ContainerUtil.map(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassNameInterner = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new WeakStringInterner() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        ClassPath classPath = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition);
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        return classPath;
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    @Deprecated
    public void addURL(URL url) {
        this.getClassPath().addURL(url);
        this.myURLs.add(url);
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.myURLs);
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass = this.findLoadedClass(name);
        return aClass != null && aClass.getClassLoader() == this;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Resource res = this.getClassPath().getResource(name.replace('.', '/') + CLASS_EXTENSION, false);
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Nullable
    protected Class _findClass(@NotNull String name) {
        Resource res;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        if ((res = this.getClassPath().getResource(name.replace('.', '/') + CLASS_EXTENSION, false)) == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res.getValue(Resource.Attribute.SPEC_TITLE), res.getValue(Resource.Attribute.SPEC_VERSION), res.getValue(Resource.Attribute.SPEC_VENDOR), res.getValue(Resource.Attribute.IMPL_TITLE), res.getValue(Resource.Attribute.IMPL_VERSION), res.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    public URL findResource(String name) {
        Resource res = this.findResourceImpl(name);
        return res != null ? res.getURL() : null;
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtil.toCanonicalUriPath(name);
        Resource resource = this.getClassPath().getResource(n, true);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1), true);
        }
        return resource;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            return super.getResourceAsStream(name);
        }
        try {
            Resource res = this.findResourceImpl(name);
            return res != null ? res.getInputStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name, true);
    }

    public static void loadPlatformLibrary(@NotNull String libName) {
        String libPath;
        String libFileName;
        File libFile;
        if (libName == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        if ((libFile = PathManager.findBinFile(libFileName = UrlClassLoader.mapLibraryName(libName))) != null) {
            libPath = libFile.getAbsolutePath();
        } else {
            libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName;
            if (!new File(libPath).exists()) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    private static String mapLibraryName(String libName) {
        String baseName = libName;
        if (SystemInfo.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        return this.myClassNameInterner != null ? this.myClassNameInterner.intern(new String(className)) : this;
    }

    @NotNull
    public static CachePool createCachePool() {
        CachePoolImpl cachePoolImpl = new CachePoolImpl();
        if (cachePoolImpl == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        return cachePoolImpl;
    }

    static {
        boolean capable;
        boolean bl = capable = SystemInfo.isJavaVersionAtLeast("1.7") && !SystemInfo.isIbmJvm && SystemProperties.getBooleanProperty("use.parallel.class.loading", true);
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachePool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClassPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "_findClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadPlatformLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static interface CachePool {
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtil.emptyList();
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex;
        private boolean myAcceptUnescaped;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources;
        @Nullable
        private CachePoolImpl myCachePool;
        @Nullable
        private CachingCondition myCachingCondition;

        private Builder() {
        }

        public Builder urls(List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        public Builder urls(URL ... urls) {
            this.myURLs = Arrays.asList(urls);
            return this;
        }

        public Builder parent(ClassLoader parent) {
            this.myParent = parent;
            return this;
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder allowLock(boolean lockJars) {
            this.myLockJars = lockJars;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }

        public Builder useCache(boolean useCache) {
            this.myUseCache = useCache;
            return this;
        }

        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.myUsePersistentClasspathIndex = ourClassPathIndexEnabled;
            return this;
        }

        public Builder useCache(@NotNull CachePool pool, @NotNull CachingCondition condition) {
            if (pool == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myUseCache = true;
            this.myCachePool = (CachePoolImpl)pool;
            this.myCachingCondition = condition;
            return this;
        }

        public Builder allowUnescaped() {
            this.myAcceptUnescaped = true;
            return this;
        }

        public Builder noPreload() {
            this.myPreload = false;
            return this;
        }

        public Builder allowBootstrapResources() {
            this.myAllowBootstrapResources = true;
            return this;
        }

        public Builder allowUnescaped(boolean acceptUnescaped) {
            this.myAcceptUnescaped = acceptUnescaped;
            return this;
        }

        public Builder preload(boolean preload) {
            this.myPreload = preload;
            return this;
        }

        public UrlClassLoader get() {
            return new UrlClassLoader(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/UrlClassLoader$Builder";
            objectArray[2] = "useCache";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

