/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitPropertyClient
extends BaseSvnClient
implements PropertyClient {
    public static final ISVNOptions LF_SEPARATOR_OPTIONS = new DefaultSVNOptions(){

        public byte[] getNativeEOL() {
            return CharsetToolkit.getUtf8Bytes((String)LineSeparator.LF.getSeparatorString());
        }
    };

    @Override
    @Nullable
    public PropertyValue getProperty(@NotNull SvnTarget target, @NotNull String property, boolean revisionProperty, @Nullable SVNRevision revision) throws SvnBindException {
        PropertyData resultData;
        if (target == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(0);
        }
        if (property == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(1);
        }
        try {
            resultData = !revisionProperty ? (target.isFile() ? PropertyData.create(this.createClient().doGetProperty(target.getFile(), property, target.getPegRevision(), revision)) : PropertyData.create(this.createClient().doGetProperty(target.getURL(), property, target.getPegRevision(), revision))) : this.getRevisionProperty(target, property, revision);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        return resultData != null ? resultData.getValue() : null;
    }

    @NotNull
    private SVNWCClient createClient() {
        SVNWCClient client = this.myVcs.getSvnKitManager().createWCClient();
        client.setOptions(LF_SEPARATOR_OPTIONS);
        SVNWCClient sVNWCClient = client;
        if (sVNWCClient == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(2);
        }
        return sVNWCClient;
    }

    @Override
    public void getProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (target == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(3);
        }
        if (property == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(4);
        }
        this.runGetProperty(target, property, revision, depth, handler);
    }

    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (target == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(5);
        }
        this.runGetProperty(target, null, revision, depth, handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable PropertyValue value, @Nullable Depth depth, boolean force) throws SvnBindException {
        if (file == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(6);
        }
        if (property == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(7);
        }
        try {
            this.createClient().doSetProperty(file, property, SvnKitPropertyClient.toPropertyValue(value), force, SvnKitPropertyClient.toDepth(depth), null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull PropertiesMap properties) throws SvnBindException {
        if (file == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(9);
        }
        SVNProperties propertiesToSet = SvnKitPropertyClient.toSvnProperties(properties);
        try {
            this.createClient().doSetProperty(file, (path, properties1) -> propertiesToSet, true, SVNDepth.EMPTY, null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setRevisionProperty(@NotNull SvnTarget target, @NotNull String property, @NotNull SVNRevision revision, @Nullable PropertyValue value, boolean force) throws SvnBindException {
        if (target == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(10);
        }
        if (property == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(11);
        }
        if (revision == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(12);
        }
        try {
            if (target.isFile()) {
                this.createClient().doSetRevisionProperty(target.getFile(), revision, property, SvnKitPropertyClient.toPropertyValue(value), force, null);
            } else {
                this.createClient().doSetRevisionProperty(target.getURL(), revision, property, SvnKitPropertyClient.toPropertyValue(value), force, null);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private static SVNProperties toSvnProperties(@NotNull PropertiesMap properties) {
        if (properties == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(13);
        }
        SVNProperties result = new SVNProperties();
        for (Map.Entry entry : properties.entrySet()) {
            result.put((String)entry.getKey(), SvnKitPropertyClient.toPropertyValue((PropertyValue)entry.getValue()));
        }
        SVNProperties sVNProperties = result;
        if (sVNProperties == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(14);
        }
        return sVNProperties;
    }

    private void runGetProperty(@NotNull SvnTarget target, @Nullable String property, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (target == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(15);
        }
        SVNWCClient client = this.createClient();
        try {
            if (target.isURL()) {
                client.doGetProperty(target.getURL(), property, target.getPegRevision(), revision, SvnKitPropertyClient.toDepth(depth), SvnKitPropertyClient.toHandler(handler));
            } else {
                client.doGetProperty(target.getFile(), property, target.getPegRevision(), revision, SvnKitPropertyClient.toDepth(depth), SvnKitPropertyClient.toHandler(handler), null);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private PropertyData getRevisionProperty(@NotNull SvnTarget target, final @NotNull String property, @Nullable SVNRevision revision) throws SVNException {
        if (target == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(16);
        }
        if (property == null) {
            SvnKitPropertyClient.$$$reportNull$$$0(17);
        }
        SVNWCClient client = this.createClient();
        final PropertyData[] result = new PropertyData[1];
        ISVNPropertyHandler handler = new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property2) {
                this.handle(property2);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property2) {
                this.handle(property2);
            }

            public void handleProperty(long revision, SVNPropertyData property2) {
                this.handle(property2);
            }

            private void handle(@NotNull SVNPropertyData data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (property.equals(data.getName())) {
                    result[0] = PropertyData.create(data);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient$2", "handle"));
            }
        };
        if (target.isFile()) {
            client.doGetRevisionProperty(target.getFile(), null, revision, handler);
        } else {
            client.doGetRevisionProperty(target.getURL(), null, revision, handler);
        }
        return result[0];
    }

    @Nullable
    private static ISVNPropertyHandler toHandler(final @Nullable PropertyConsumer consumer) {
        ISVNPropertyHandler result = null;
        if (consumer != null) {
            result = new ISVNPropertyHandler(){

                public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(path, PropertyData.create(property));
                }

                public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(url, PropertyData.create(property));
                }

                public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(revision, PropertyData.create(property));
                }
            };
        }
        return result;
    }

    @Nullable
    private static SVNPropertyValue toPropertyValue(@Nullable PropertyValue value) {
        SVNPropertyValue result = null;
        if (value != null) {
            result = SVNPropertyValue.create((String)value.toString());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/properties/SvnKitPropertyClient";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/properties/SvnKitPropertyClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClient";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toSvnProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 2: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRevisionProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toSvnProperties";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runGetProperty";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

