/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.SpacingFactory;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Spacing {
    private static SpacingFactory myFactory;

    static void setFactory(SpacingFactory factory) {
        myFactory = factory;
    }

    public static Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createSpacing(minSpaces, maxSpaces, minLineFeeds, keepLineBreaks, keepBlankLines);
    }

    public static Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        return myFactory.createSpacing(minSpaces, maxSpaces, minLineFeeds, keepLineBreaks, keepBlankLines, prefLineFeeds);
    }

    public static Spacing getReadOnlySpacing() {
        return myFactory.getReadOnlySpacing();
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependency, boolean keepLineBreaks, int keepBlankLines) {
        if (dependency == null) {
            Spacing.$$$reportNull$$$0(0);
        }
        return Spacing.createDependentLFSpacing(minSpaces, maxSpaces, dependency, keepLineBreaks, keepBlankLines, DependentSpacingRule.DEFAULT);
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependency, boolean keepLineBreaks, int keepBlankLines) {
        if (dependency == null) {
            Spacing.$$$reportNull$$$0(1);
        }
        return myFactory.createDependentLFSpacing(minSpaces, maxSpaces, dependency, keepLineBreaks, keepBlankLines, DependentSpacingRule.DEFAULT);
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependencyRange, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependencyRange == null) {
            Spacing.$$$reportNull$$$0(2);
        }
        if (rule == null) {
            Spacing.$$$reportNull$$$0(3);
        }
        return myFactory.createDependentLFSpacing(minSpaces, maxSpaces, dependencyRange, keepLineBreaks, keepBlankLines, rule);
    }

    public static Spacing createSafeSpacing(boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createSafeSpacing(keepLineBreaks, keepBlankLines);
    }

    public static Spacing createKeepingFirstColumnSpacing(int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createKeepingFirstColumnSpacing(minSpaces, maxSpaces, keepLineBreaks, keepBlankLines);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dependency";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dependencyRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "rule";
                break;
            }
        }
        objectArray[1] = "com/intellij/formatting/Spacing";
        objectArray[2] = "createDependentLFSpacing";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

