/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.TypeMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBeanNode {
    private final String parentPropertyName;
    private final Class<?> beanClass;

    public AbstractBeanNode(@Nullable String parentPropertyName, Class<?> beanClass) {
        this.parentPropertyName = parentPropertyName;
        this.beanClass = beanClass;
    }

    public String getQualifiedPropertyName(String propertyName) {
        return this.parentPropertyName == null ? propertyName : this.parentPropertyName + "." + propertyName;
    }

    public boolean isRoot() {
        return this.parentPropertyName == null;
    }

    public boolean isIterable(TypeMetadata metadata) {
        return !this.isRoot() && Iterable.class.isAssignableFrom(this.beanClass) && !metadata.isAnnotated();
    }

    @Nullable
    public String getParentPropertyName() {
        return this.parentPropertyName;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }
}

