/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartCodegen;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.ScriptCodegen;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.org.objectweb.asm.Type;

public class PackageCodegenImpl
implements PackageCodegen {
    private final GenerationState state;
    private final Collection<KtFile> files;
    private final PackageFragmentDescriptor packageFragment;
    private final PackagePartRegistry packagePartRegistry;

    public PackageCodegenImpl(@NotNull GenerationState state2, @NotNull Collection<KtFile> files2, @NotNull FqName packageFqName, @NotNull PackagePartRegistry registry) {
        this.state = state2;
        this.files = files2;
        this.packageFragment = this.getOnlyPackageFragment(packageFqName);
        this.packagePartRegistry = registry;
    }

    @Override
    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        for (KtFile file : this.files) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            try {
                this.generateFile(file);
                this.state.afterIndependentPart();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
    }

    private void generateClassesAndObjectsInFile(@NotNull List<KtClassOrObject> classOrObjects, @NotNull PackageContext packagePartContext) {
        for (KtClassOrObject classOrObject : CodegenUtilKt.sortTopLevelClassesAndPrepareContextForSealedClasses(classOrObjects, packagePartContext, this.state)) {
            this.generateClassOrObject(classOrObject, packagePartContext);
        }
    }

    private void generateFile(@NotNull KtFile file) {
        JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(file);
        if (fileClassInfo.getWithJvmMultifileClass()) {
            return;
        }
        Type fileClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        PackageContext packagePartContext = this.state.getRootContext().intoPackagePart(this.packageFragment, fileClassType, file);
        boolean generatePackagePart = false;
        ArrayList<KtClassOrObject> classOrObjects = new ArrayList<KtClassOrObject>();
        for (KtDeclaration declaration : CodegenUtil.getActualDeclarations(file)) {
            if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction || declaration instanceof KtTypeAlias) {
                generatePackagePart = true;
                continue;
            }
            if (declaration instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)declaration;
                if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateClass(classOrObject)) continue;
                classOrObjects.add(classOrObject);
                continue;
            }
            if (!(declaration instanceof KtScript)) continue;
            KtScript script = (KtScript)declaration;
            if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateScript(script)) continue;
            ScriptCodegen.createScriptCodegen(script, this.state, packagePartContext).generate();
        }
        this.generateClassesAndObjectsInFile(classOrObjects, packagePartContext);
        if (!generatePackagePart || !this.state.getGenerateDeclaredClassFilter().shouldGeneratePackagePart(file)) {
            return;
        }
        this.packagePartRegistry.addPart(fileClassType.getInternalName(), null);
        ClassBuilder builder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.PackagePart(file, this.packageFragment), fileClassType, file);
        new PackagePartCodegen(builder, file, fileClassType, packagePartContext, this.state).generate();
    }

    @Nullable
    private PackageFragmentDescriptor getOnlyPackageFragment(@NotNull FqName expectedPackageFqName) {
        SmartList<PackageFragmentDescriptor> fragments2 = new SmartList<PackageFragmentDescriptor>();
        for (KtFile file : this.files) {
            PackageFragmentDescriptor fragment = this.state.getBindingContext().get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file);
            assert (fragment != null) : "package fragment is null for " + file + "\n" + file.getText();
            assert (expectedPackageFqName.equals(fragment.getFqName())) : "expected package fq name: " + expectedPackageFqName + ", actual: " + fragment.getFqName();
            if (fragments2.contains(fragment)) continue;
            fragments2.add(fragment);
        }
        if (fragments2.size() > 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments2);
        }
        if (fragments2.isEmpty()) {
            return null;
        }
        return (PackageFragmentDescriptor)fragments2.get(0);
    }

    @Override
    public void generateClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull PackageContext packagePartContext) {
        MemberCodegen.genClassOrObject(packagePartContext, classOrObject, this.state, null);
    }

    @Override
    public PackageFragmentDescriptor getPackageFragment() {
        return this.packageFragment;
    }
}

