/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;

public class VersionSelectionReasons {
    public static final ComponentSelectionReasonInternal REQUESTED = new DefaultComponentSelectionReason(false, false, false, true, false, "requested");
    public static final ComponentSelectionReasonInternal ROOT = new DefaultComponentSelectionReason(false, false, false, true, false, "root");
    public static final ComponentSelectionReasonInternal FORCED = new DefaultComponentSelectionReason(true, false, false, false, false, "forced");
    public static final ComponentSelectionReasonInternal CONFLICT_RESOLUTION = new DefaultComponentSelectionReason(false, true, false, false, false, "conflict resolution");
    public static final ComponentSelectionReasonInternal SELECTED_BY_RULE = new DefaultComponentSelectionReason(false, false, true, false, false, "selected by rule");
    public static final ComponentSelectionReasonInternal CONFLICT_RESOLUTION_BY_RULE = new DefaultComponentSelectionReason(false, true, true, false, false, "selected by rule and conflict resolution");
    public static final ComponentSelectionReasonInternal COMPOSITE_BUILD = new DefaultComponentSelectionReason(false, false, false, false, true, "composite build substitution");

    public static ComponentSelectionReason withConflictResolution(ComponentSelectionReason reason) {
        if (reason.isConflictResolution()) {
            return reason;
        }
        if (reason == SELECTED_BY_RULE) {
            return CONFLICT_RESOLUTION_BY_RULE;
        }
        if (reason == REQUESTED) {
            return CONFLICT_RESOLUTION;
        }
        if (reason == FORCED) {
            return CONFLICT_RESOLUTION;
        }
        if (reason == ROOT) {
            return reason;
        }
        throw new IllegalArgumentException("Cannot create conflict resolution selection reason for input: " + reason);
    }

    private static class DefaultComponentSelectionReason
    implements ComponentSelectionReasonInternal {
        private final boolean forced;
        private final boolean conflictResolution;
        private final boolean selectedByRule;
        private final boolean expected;
        private final boolean compositeParticipant;
        private final String description;

        private DefaultComponentSelectionReason(boolean forced, boolean conflictResolution, boolean selectedByRule, boolean expected, boolean compositeBuild, String description) {
            this.forced = forced;
            this.conflictResolution = conflictResolution;
            this.selectedByRule = selectedByRule;
            this.expected = expected;
            this.compositeParticipant = compositeBuild;
            assert (description != null);
            this.description = description;
        }

        public boolean isForced() {
            return this.forced;
        }

        public boolean isConflictResolution() {
            return this.conflictResolution;
        }

        public boolean isSelectedByRule() {
            return this.selectedByRule;
        }

        public boolean isExpected() {
            return this.expected;
        }

        public boolean isCompositeSubstitution() {
            return this.compositeParticipant;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }

        @Override
        public ComponentSelectionReasonInternal withReason(String description) {
            return new DefaultComponentSelectionReason(this.forced, this.conflictResolution, this.selectedByRule, this.expected, this.compositeParticipant, description);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultComponentSelectionReason that = (DefaultComponentSelectionReason)o;
            return this.forced == that.forced && this.conflictResolution == that.conflictResolution && this.selectedByRule == that.selectedByRule && this.expected == that.expected && this.compositeParticipant == that.compositeParticipant && Objects.equal((Object)this.description, (Object)that.description);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.forced, this.conflictResolution, this.selectedByRule, this.expected, this.compositeParticipant, this.description});
        }
    }
}

