#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cryptonite
version: 0.24
id: cryptonite-0.24-CQS9SB3Hce73SrYZ7gsC5w
key: cryptonite-0.24-CQS9SB3Hce73SrYZ7gsC5w
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: vincent@snarc.org
stability: experimental
homepage: https://github.com/haskell-crypto/cryptonite
synopsis: Cryptography Primitives sink
description:
    A repository of cryptographic primitives.
    .
    * Symmetric ciphers: AES, DES, 3DES, Blowfish, Camellia, RC4, Salsa, XSalsa, ChaCha.
    .
    * Hash: SHA1, SHA2, SHA3, SHAKE, MD2, MD4, MD5, Keccak, Skein, Ripemd, Tiger, Whirlpool, Blake2
    .
    * MAC: HMAC, Poly1305
    .
    * Asymmetric crypto: DSA, RSA, DH, ECDH, ECDSA, ECC, Curve25519, Curve448, Ed25519, Ed448
    .
    * Key Derivation Function: PBKDF2, Scrypt, HKDF, Argon2
    .
    * Cryptographic Random generation: System Entropy, Deterministic Random Generator
    .
    * Data related: Anti-Forensic Information Splitter (AFIS)
    .
    If anything cryptographic related is missing from here, submit
    a pull request to have it added. This package strive to be a
    cryptographic kitchen sink that provides cryptography for everyone.
    .
    Evaluate the security related to your requirements before using.
    .
    Read "Crypto.Tutorial" for a quick start guide.
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Cipher.AES Crypto.Cipher.Blowfish Crypto.Cipher.Camellia
    Crypto.Cipher.ChaCha Crypto.Cipher.ChaChaPoly1305 Crypto.Cipher.DES
    Crypto.Cipher.RC4 Crypto.Cipher.Salsa Crypto.Cipher.TripleDES
    Crypto.Cipher.Twofish Crypto.Cipher.Types Crypto.Cipher.Utils
    Crypto.Cipher.XSalsa Crypto.ConstructHash.MiyaguchiPreneel
    Crypto.Data.AFIS Crypto.Data.Padding Crypto.ECC Crypto.Error
    Crypto.Hash Crypto.Hash.Algorithms Crypto.Hash.IO Crypto.KDF.Argon2
    Crypto.KDF.BCrypt Crypto.KDF.HKDF Crypto.KDF.PBKDF2
    Crypto.KDF.Scrypt Crypto.MAC.CMAC Crypto.MAC.HMAC
    Crypto.MAC.Poly1305 Crypto.Number.Basic Crypto.Number.F2m
    Crypto.Number.Generate Crypto.Number.ModArithmetic
    Crypto.Number.Prime Crypto.Number.Serialize
    Crypto.Number.Serialize.Internal Crypto.OTP
    Crypto.PubKey.Curve25519 Crypto.PubKey.Curve448 Crypto.PubKey.DH
    Crypto.PubKey.DSA Crypto.PubKey.ECC.DH Crypto.PubKey.ECC.ECDSA
    Crypto.PubKey.ECC.Generate Crypto.PubKey.ECC.P256
    Crypto.PubKey.ECC.Prim Crypto.PubKey.ECC.Types Crypto.PubKey.ECIES
    Crypto.PubKey.Ed25519 Crypto.PubKey.Ed448
    Crypto.PubKey.MaskGenFunction Crypto.PubKey.RSA
    Crypto.PubKey.RSA.OAEP Crypto.PubKey.RSA.PKCS15
    Crypto.PubKey.RSA.PSS Crypto.PubKey.RSA.Prim
    Crypto.PubKey.RSA.Types Crypto.Random Crypto.Random.Entropy
    Crypto.Random.Entropy.Unsafe Crypto.Random.EntropyPool
    Crypto.Random.Types Crypto.Tutorial
hidden-modules: Crypto.Cipher.AES.Primitive
                Crypto.Cipher.Blowfish.Box Crypto.Cipher.Blowfish.Primitive
                Crypto.Cipher.Camellia.Primitive Crypto.Cipher.DES.Primitive
                Crypto.Cipher.Twofish.Primitive Crypto.Cipher.Types.AEAD
                Crypto.Cipher.Types.Base Crypto.Cipher.Types.Block
                Crypto.Cipher.Types.GF Crypto.Cipher.Types.Stream
                Crypto.Cipher.Types.Utils Crypto.Error.Types Crypto.Number.Compat
                Crypto.Hash.Types Crypto.Hash.Blake2s Crypto.Hash.Blake2sp
                Crypto.Hash.Blake2b Crypto.Hash.Blake2bp Crypto.Hash.SHA1
                Crypto.Hash.SHA224 Crypto.Hash.SHA256 Crypto.Hash.SHA384
                Crypto.Hash.SHA512 Crypto.Hash.SHA512t Crypto.Hash.SHA3
                Crypto.Hash.Keccak Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                Crypto.Hash.Tiger Crypto.Hash.Whirlpool
                Crypto.Random.Entropy.Source Crypto.Random.Entropy.Backend
                Crypto.Random.ChaChaDRG Crypto.Random.SystemDRG
                Crypto.Random.Probabilistic Crypto.PubKey.Internal
                Crypto.PubKey.ElGamal Crypto.ECC.Simple.Types
                Crypto.ECC.Simple.Prim Crypto.Internal.Proxy
                Crypto.Internal.ByteArray Crypto.Internal.Compat
                Crypto.Internal.CompatPrim Crypto.Internal.DeepSeq
                Crypto.Internal.Imports Crypto.Internal.Words
                Crypto.Internal.WordArray Crypto.Hash.SHAKE Crypto.Hash.Blake2
                Crypto.Internal.Nat Crypto.Random.Entropy.Unix
abi: bc3f27819a05db49c9ea25f433ac8587
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/cryptonite-0.24
library-dirs: /usr/lib/ghc-8.2.2/site-local/cryptonite-0.24
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/cryptonite-0.24
hs-libraries: HScryptonite-0.24-CQS9SB3Hce73SrYZ7gsC5w
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    memory-0.14.14-4o8zyRHIoSnHzCBHYQGHAV
    foundation-0.0.19-EXUSPr5e6atLdkxlJlFQt9 ghc-prim-0.5.1.1
    integer-gmp-1.0.1.0 deepseq-1.4.3.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             memory-0.14.14-4o8zyRHIoSnHzCBHYQGHAV=cd1266467377c3b0ef3fabb0cb06b2c3
             foundation-0.0.19-EXUSPr5e6atLdkxlJlFQt9=a77fb133640a5df8f66bde3ad4bda172
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             integer-gmp-1.0.1.0=7d948c9c98bb9ecc021f32964406f9ad
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
haddock-interfaces: /usr/share/doc/haskell-cryptonite/html/cryptonite.haddock
haddock-html: /usr/share/doc/haskell-cryptonite/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

