#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.2.2
id: semigroupoids-5.2.2-H3PzwRIhGuF7pmQc9pykYR
key: semigroupoids-5.2.2-H3PzwRIhGuF7pmQc9pykYR
license: BSD3
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
exposed: True
indefinite: False
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
abi: 08dfd1056229bca771938046c8a0dab3
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/semigroupoids-5.2.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/semigroupoids-5.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/semigroupoids-5.2.2
hs-libraries: HSsemigroupoids-5.2.2-H3PzwRIhGuF7pmQc9pykYR
depends:
    base-4.10.1.0 base-orphans-0.6-KoJqNefbvUAEuaR7CDOiu4
    bifunctors-5.5.2-4k1nzeqh8QZIMgnDQD951Z
    semigroups-0.18.4-mxkGq2xNPcBC0dj8uuk3q template-haskell-2.12.0.0
    transformers-0.5.2.0
    transformers-compat-0.5.1.4-EAh8Ccrgitz4vTZtbTPyCM
    containers-0.5.10.2 contravariant-1.4.1-7cEYjzgkYgPFdXWpdMNGgr
    distributive-0.5.3-3QQWO3yfOScASLf5zUz2JE
    comonad-5.0.3-1wQLfIXhDc15HcgpkWgfSP
    tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2
    hashable-1.2.6.1-6LeHpYZ4iRgEy9P36eCQfR
    unordered-containers-0.2.9.0-14GJxyni7Ou4ztgK034uJm
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             base-orphans-0.6-KoJqNefbvUAEuaR7CDOiu4=fb09ffe63c021a5df200f5dd3f288699
             bifunctors-5.5.2-4k1nzeqh8QZIMgnDQD951Z=1c778d56208bb8cb72a417af807a024a
             semigroups-0.18.4-mxkGq2xNPcBC0dj8uuk3q=0f8a4b2bc8ee8ce3a5dab66f0eb14e7c
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             transformers-compat-0.5.1.4-EAh8Ccrgitz4vTZtbTPyCM=506de314acc216de1ce76634db1785eb
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             contravariant-1.4.1-7cEYjzgkYgPFdXWpdMNGgr=5e2c57f6d5adae18dd0e94f3a1c17f3b
             distributive-0.5.3-3QQWO3yfOScASLf5zUz2JE=4194008627baa63a29bcee90329e8d22
             comonad-5.0.3-1wQLfIXhDc15HcgpkWgfSP=0772d58444b5fab8850dd1c606485ec5
             tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2=b5d07becd47ba21e20b584b61ad0f06d
             hashable-1.2.6.1-6LeHpYZ4iRgEy9P36eCQfR=e2c3f4e35e60b5547d3e7a8c501ca6de
             unordered-containers-0.2.9.0-14GJxyni7Ou4ztgK034uJm=a19fc431946ec4b21dbc4dc9d0f6448c
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

