/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.readline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.readline.jline.console.ConsoleReader;
import org.jruby.readline.jline.console.CursorBuffer;
import org.jruby.readline.jline.console.completer.Completer;
import org.jruby.readline.jline.console.completer.FileNameCompleter;
import org.jruby.readline.jline.console.history.History;
import org.jruby.readline.jline.console.history.MemoryHistory;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Readline"})
public class Readline {
    public static final char ESC_KEY_CODE = '\u001b';
    private static final boolean DEBUG = false;
    private static IRubyObject COMPLETION_CASE_FOLD = null;

    public static void createReadline(Ruby runtime) throws IOException {
        ConsoleHolder holder = new ConsoleHolder();
        holder.history = new MemoryHistory();
        holder.currentCompletor = null;
        COMPLETION_CASE_FOLD = runtime.getNil();
        RubyModule mReadline = runtime.defineModule("Readline");
        mReadline.dataWrapStruct((Object)holder);
        mReadline.defineAnnotatedMethods(Readline.class);
        IRubyObject hist = runtime.getObject().callMethod(runtime.getCurrentContext(), "new");
        mReadline.setConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule((IRubyObject)runtime.getEnumerable());
        hist.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        mReadline.setConstant("VERSION", (IRubyObject)runtime.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby runtime, final ConsoleHolder holder) {
        try {
            holder.readline = new ConsoleReader(runtime.getInputStream(), runtime.getOutputStream());
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        holder.readline.setHistoryEnabled(false);
        holder.readline.setPaginationEnabled(true);
        holder.readline.setBellEnabled(true);
        if (holder.currentCompletor == null) {
            holder.currentCompletor = new RubyFileNameCompletor();
        }
        holder.readline.addCompleter(holder.currentCompletor);
        holder.readline.setHistory(holder.history);
        holder.readline.addTriggeredAction('\u001b', new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    holder.readline.beep();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static History getHistory(ConsoleHolder holder) {
        return holder.history;
    }

    public static ConsoleHolder getHolder(Ruby runtime) {
        return (ConsoleHolder)runtime.getModule("Readline").dataGetStruct();
    }

    public static ConsoleHolder getHolderWithReadline(Ruby runtime) {
        ConsoleHolder holder = Readline.getHolder(runtime);
        if (holder.readline == null) {
            Readline.initReadline(runtime, holder);
        }
        return holder;
    }

    public static void setCompletor(ConsoleHolder holder, Completer completor) {
        if (holder.readline != null) {
            holder.readline.removeCompleter(holder.currentCompletor);
        }
        holder.currentCompletor = completor;
        if (holder.readline != null) {
            holder.readline.addCompleter(holder.currentCompletor);
        }
    }

    public static Completer getCompletor(ConsoleHolder holder) {
        return holder.currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject recv, IRubyObject prompt, IRubyObject add_to_hist) {
        return Readline.s_readline(recv.getRuntime().getCurrentContext(), recv, prompt, add_to_hist);
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(ThreadContext context, IRubyObject recv, IRubyObject prompt, IRubyObject add_to_hist) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        holder.readline.setExpandEvents(false);
        IRubyObject line = runtime.getNil();
        String v = null;
        try {
            holder.readline.getTerminal().setEchoEnabled(false);
            v = holder.readline.readLine(prompt.toString());
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        finally {
            holder.readline.getTerminal().setEchoEnabled(true);
        }
        if (null != v) {
            if (add_to_hist.isTrue()) {
                holder.readline.getHistory().add(v);
            }
            ByteList list = new ByteList(v.getBytes(), runtime.getDefaultExternalEncoding());
            line = RubyString.newString((Ruby)runtime, (ByteList)list);
        }
        return line;
    }

    @JRubyMethod(name={"input="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setInput(ThreadContext context, IRubyObject recv, IRubyObject input) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"output="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setOutput(ThreadContext context, IRubyObject recv, IRubyObject output) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv, IRubyObject prompt) {
        return Readline.s_readline(recv, prompt, (IRubyObject)recv.getRuntime().getFalse());
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv) {
        return Readline.s_readline(recv, (IRubyObject)RubyString.newEmptyString((Ruby)recv.getRuntime()), (IRubyObject)recv.getRuntime().getFalse());
    }

    @JRubyMethod(name={"basic_word_break_characters="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_basic_word_break_character(IRubyObject recv, IRubyObject achar) {
        Ruby runtime = recv.getRuntime();
        if (!achar.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + achar.getMetaClass() + " into String");
        }
        ProcCompleter.setDelimiter(achar.convertToString().toString());
        return achar;
    }

    @JRubyMethod(name={"basic_word_break_characters"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_basic_word_break_character(IRubyObject recv) {
        return recv.getRuntime().newString(ProcCompleter.getDelimiter());
    }

    @JRubyMethod(name={"completion_append_character="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_append_character(IRubyObject recv, IRubyObject achar) {
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject recv, IRubyObject proc) {
        if (!proc.respondsTo("call")) {
            throw recv.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(recv.getRuntime()), new ProcCompleter(proc));
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"basic_quote_characters", "basic_quote_characters=", "completer_quote_characters", "completer_quote_characters=", "completer_word_break_characters", "completer_word_break_characters=", "completion_append_character", "completion_proc", "emacs_editing_mode", "emacs_editing_mode?", "filename_quote_characters", "filename_quote_characters=", "vi_editing_mode", "vi_editing_mode?", "set_screen_size"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject unimplemented(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        String err = context.getFrameName() + "() function is unimplemented on this machine";
        throw runtime.newNotImplementedError(err);
    }

    @JRubyMethod(name={"completion_case_fold"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_completion_case_fold(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        return COMPLETION_CASE_FOLD;
    }

    @JRubyMethod(name={"completion_case_fold="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_case_fold(ThreadContext context, IRubyObject recv, IRubyObject other) {
        Ruby runtime = context.runtime;
        COMPLETION_CASE_FOLD = other;
        return COMPLETION_CASE_FOLD;
    }

    @JRubyMethod(name={"get_screen_size"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_screen_size(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        IRubyObject[] ary = new IRubyObject[]{runtime.newFixnum(holder.readline.getTerminal().getHeight()), runtime.newFixnum(holder.readline.getTerminal().getWidth())};
        return RubyArray.newArray((Ruby)runtime, (IRubyObject[])ary);
    }

    @JRubyMethod(name={"line_buffer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_line_buffer(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime.newString(cb.toString()).taint(context);
    }

    @JRubyMethod(name={"point"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_point(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime.newFixnum(cb.cursor);
    }

    @JRubyMethod(name={"refresh_line"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_refresh_line(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        try {
            holder.readline.redrawLine();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return runtime.getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompleter {
        public int complete(String buffer, int cursor, List candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            return index + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompleter
    implements Completer {
        IRubyObject procCompleter;
        private static String[] delimiters = new String[]{" ", "\t", "\n", "\"", "\\", "'", "`", "@", "$", ">", "<", "=", ";", "|", "&", "{", "("};

        public ProcCompleter(IRubyObject procCompleter) {
            this.procCompleter = procCompleter;
        }

        public static String getDelimiter() {
            StringBuilder result = new StringBuilder(delimiters.length);
            for (String delimiter : delimiters) {
                result.append(delimiter);
            }
            return result.toString();
        }

        public static void setDelimiter(String delimiter) {
            ArrayList<String> l = new ArrayList<String>();
            CharBuffer buf = CharBuffer.wrap(delimiter);
            while (buf.hasRemaining()) {
                l.add(String.valueOf(buf.get()));
            }
            delimiters = l.toArray(new String[l.size()]);
        }

        private int wordIndexOf(String buffer) {
            int index = 0;
            for (String c : delimiters) {
                index = buffer.lastIndexOf(c);
                if (index == -1) continue;
                return index;
            }
            return index;
        }

        public int complete(String buffer, int cursor, List candidates) {
            Ruby runtime;
            ThreadContext context;
            IRubyObject result;
            IRubyObject comps;
            int index = this.wordIndexOf(buffer = buffer.substring(0, cursor));
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            if ((comps = (result = this.procCompleter.callMethod(context = (runtime = this.procCompleter.getRuntime()).getCurrentContext(), "call", (IRubyObject)runtime.newString(buffer))).callMethod(context, "to_a")) instanceof List) {
                for (Object obj : (List)comps) {
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject recv, IRubyObject[] lines) {
            ConsoleHolder holder = Readline.getHolder(recv.getRuntime());
            for (int i = 0; i < lines.length; ++i) {
                RubyString line = lines[i].convertToString();
                holder.history.add(line.getUnicodeValue());
            }
            return recv;
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            if (holder.history.isEmpty()) {
                return runtime.getNil();
            }
            return runtime.newString(holder.history.removeLast().toString()).taint(runtime.getCurrentContext());
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            RubyArray histList = runtime.newArray();
            ListIterator<History.Entry> historyIterator = holder.history.entries();
            while (historyIterator.hasNext()) {
                History.Entry nextEntry = historyIterator.next();
                histList.append((IRubyObject)runtime.newString(nextEntry.value().toString()));
            }
            return histList;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject recv) {
            return recv.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject recv, IRubyObject index) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i = (int)index.convertToInteger().getLongValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                ThreadContext context = runtime.getCurrentContext();
                return runtime.newString((String)holder.history.get(i)).taint(context);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject recv, IRubyObject index, IRubyObject val) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i = (int)index.convertToInteger().getLongValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                holder.history.set(i, val.asJavaString());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i);
            }
            return runtime.getNil();
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            if (holder.history.isEmpty()) {
                return runtime.getNil();
            }
            try {
                return runtime.newString(holder.history.removeFirst().toString()).taint(runtime.getCurrentContext());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("history shift error");
            }
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject recv) {
            ConsoleHolder holder = Readline.getHolder(recv.getRuntime());
            return recv.getRuntime().newFixnum(holder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject recv) {
            ConsoleHolder holder = Readline.getHolder(recv.getRuntime());
            return recv.getRuntime().newBoolean(holder.history.isEmpty());
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject recv, IRubyObject index) {
            Ruby runtime = recv.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i = RubyNumeric.num2int((IRubyObject)index);
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                return runtime.newString(holder.history.remove(i).toString()).taint(context);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject s_hist_each(IRubyObject recv, Block block) {
            Ruby runtime = recv.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            ConsoleHolder holder = Readline.getHolder(runtime);
            Iterator<History.Entry> i = holder.history.iterator();
            while (i.hasNext()) {
                block.yield(context, runtime.newString(i.next().value().toString()).taint(context));
            }
            return recv;
        }

        @JRubyMethod(name={"clear"})
        public static IRubyObject clear(ThreadContext context, IRubyObject recv, Block block) {
            ConsoleHolder holder = Readline.getHolder(context.runtime);
            holder.history.clear();
            return context.nil;
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completer currentCompletor;
        public History history;
    }
}

