/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NotNullBasicValue;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullBasicValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0002J \u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0016J\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/NullabilityInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "()V", "merge", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "v", "w", "mergeNotNullValuesOfSameKind", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "naryOperation", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "values", "", "newOperation", "unaryOperation", "value", "isReferenceType", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "backend"})
public final class NullabilityInterpreter
extends OptimizationBasicInterpreter {
    @Override
    @Nullable
    public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
        Type resultType;
        BasicValue defaultResult;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        BasicValue basicValue = defaultResult = super.newOperation(insn);
        Type type2 = resultType = basicValue != null ? basicValue.getType() : null;
        return insn.getOpcode() == 1 ? (BasicValue)NullBasicValue.INSTANCE : (insn.getOpcode() == 187 ? (BasicValue)new NotNullBasicValue(resultType) : (insn.getOpcode() == 18 && this.isReferenceType(resultType) ? (BasicValue)new NotNullBasicValue(resultType) : (PopBackwardPropagationTransformerKt.isUnitInstance(insn) ? (BasicValue)new NotNullBasicValue(resultType) : defaultResult)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReferenceType(@Nullable Type $receiver) {
        Integer n;
        Integer it;
        Type type2 = $receiver;
        if (type2 == null) return false;
        Integer n2 = type2.getSort();
        Integer n3 = it = (n = n2);
        int n4 = 10;
        if (n3 != null) {
            if (n3 == n4) return true;
        }
        Integer n5 = it;
        n4 = 9;
        if (n5 == null) return false;
        if (n5 != n4) return false;
        return true;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @Nullable BasicValue value) {
        Type resultType;
        BasicValue defaultResult;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        BasicValue basicValue = defaultResult = super.unaryOperation(insn, value);
        Type type2 = resultType = basicValue != null ? basicValue.getType() : null;
        return insn.getOpcode() == 192 ? value : (insn.getOpcode() == 188 || insn.getOpcode() == 189 ? (BasicValue)new NotNullBasicValue(resultType) : defaultResult);
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        Type resultType;
        Value defaultResult;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(values, "values");
        Value value = defaultResult = super.naryOperation(insn, (List)values);
        Type type2 = resultType = value != null ? ((BasicValue)value).getType() : null;
        return BoxingInterpreterKt.isBoxing(insn) ? (BasicValue)new NotNullBasicValue(resultType) : (BoxingInterpreterKt.isIteratorMethodCallOfProgression(insn, values) ? (BasicValue)ProgressionIteratorBasicValue.byProgressionClassType(values.get(0).getType()) : (BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values) ? (BasicValue)new NotNullBasicValue(resultType) : (PseudoInsnsKt.isPseudo(insn, PseudoInsn.AS_NOT_NULL) ? (BasicValue)new NotNullBasicValue(values.get(0).getType()) : defaultResult)));
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
        if (v instanceof NullBasicValue && w instanceof NullBasicValue) {
            basicValue = NullBasicValue.INSTANCE;
        } else if (v instanceof NullBasicValue || w instanceof NullBasicValue) {
            basicValue = StrictBasicValue.REFERENCE_VALUE;
        } else if (v instanceof ProgressionIteratorBasicValue && w instanceof ProgressionIteratorBasicValue) {
            basicValue = this.mergeNotNullValuesOfSameKind((StrictBasicValue)v, (StrictBasicValue)w);
        } else if (v instanceof ProgressionIteratorBasicValue && w instanceof NotNullBasicValue) {
            basicValue = NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
        } else if (w instanceof ProgressionIteratorBasicValue && v instanceof NotNullBasicValue) {
            basicValue = NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
        } else if (v instanceof NotNullBasicValue && w instanceof NotNullBasicValue) {
            basicValue = this.mergeNotNullValuesOfSameKind((StrictBasicValue)v, (StrictBasicValue)w);
        } else {
            BasicValue basicValue2 = super.merge(v, w);
            basicValue = basicValue2;
            Intrinsics.checkExpressionValueIsNotNull(basicValue2, "super.merge(v, w)");
        }
        return basicValue;
    }

    private final StrictBasicValue mergeNotNullValuesOfSameKind(StrictBasicValue v, StrictBasicValue w) {
        return Intrinsics.areEqual(v.getType(), w.getType()) ? v : (StrictBasicValue)NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
    }
}

