/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "frontend"})
public final class InlineParameterChecker
implements SimpleDeclarationChecker {
    public static final InlineParameterChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        block3: {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            if (!(declaration instanceof KtFunction)) break block3;
            boolean inline = declaration.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                block5: {
                    block4: {
                        parameterDescriptor = (VariableDescriptor)bindingContext.get(BindingContext.VALUE_PARAMETER, parameter);
                        if (!inline) break block4;
                        if (parameterDescriptor == null) break block5;
                        KotlinType kotlinType = parameterDescriptor.getType();
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
                        if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) break block5;
                    }
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkExpressionValueIsNotNull(ktParameter, "parameter");
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.NOINLINE_KEYWORD");
                    this.reportIncorrectInline(ktParameter, ktModifierKeywordToken, diagnosticHolder);
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken2, "KtTokens.CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken2, diagnosticHolder);
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD)) continue;
                Annotated annotated = parameterDescriptor;
                if (annotated == null || (annotated = annotated.getType()) == null) continue;
                if (!FunctionTypesKt.isSuspendFunctionType((KotlinType)annotated)) continue;
                diagnosticHolder.report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(@NotNull KtParameter $receiver, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        block0: {
            PsiElement psiElement;
            PsiElement modifier;
            KtModifierList ktModifierList = $receiver.getModifierList();
            PsiElement psiElement2 = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
            if (psiElement2 == null) break block0;
            PsiElement it = psiElement = psiElement2;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }

    private InlineParameterChecker() {
    }

    static {
        InlineParameterChecker inlineParameterChecker;
        INSTANCE = inlineParameterChecker = new InlineParameterChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(expectActualTracker, "expectActualTracker");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings, expectActualTracker);
    }
}

