#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.0.6
id: pandoc-2.0.6-LtoPH5EOQmkCRgmsIhhnRZ
key: pandoc-2.0.6-LtoPH5EOQmkCRgmsIhhnRZ
license: GPL
copyright: (c) 2006-2017 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, and Textile, and it can write
    Markdown, reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt,
    DocBook, JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    RTF, MediaWiki, DokuWiki, ZimWiki, Textile, groff man,
    groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
indefinite: False
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Shared Text.Pandoc.Templates Text.Pandoc.UTF8
    Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Util Text.Pandoc.Readers.Docx.StyleMap
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Text.Pandoc.Compat.Time Paths_pandoc
abi: 58ed62e74b69e2d4b42df5d1ee4756a1
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.0.6
library-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.0.6
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.0.6-LtoPH5EOQmkCRgmsIhhnRZ
depends:
    base-4.10.1.0 syb-0.7-3Lq8MQxmYP07qktjI1jxu0 containers-0.5.10.2
    unordered-containers-0.2.9.0-14GJxyni7Ou4ztgK034uJm
    parsec-3.1.13.0-E3xu0p0JtSPICcgXxkVqap
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH filepath-1.4.1.2 process-1.6.1.0
    directory-1.3.0.2 bytestring-0.10.8.2
    text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    zip-archive-0.3.2.3-LgUrGVKZgpI9ReZJW8j79i
    HTTP-4000.3.9-3xcNNC0DKEzJdVZPECdmFb
    texmath-0.10.1.1-5tHDj20AWYh6B2PpRjt2ye
    xml-1.3.14-gmCpsUXEJ0Cd36ZPTskAU
    split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    pandoc-types-1.17.3.1-1M7FPLUb3W2Ipz5WQuexGO
    aeson-1.2.4.0-LfzbQdLtEh8Dr9TGmQripa
    aeson-pretty-0.8.5-9mezPRONyA4AILQoCIf0oN
    tagsoup-0.14.3-19uVu5Flcy8Esb4Yvzzgji
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM
    skylighting-0.5.0.1-3Y58YKszwd81snC6b6iY44
    data-default-0.7.1.1-AA4CT1Ft3yBIiqFbrFdPSr
    temporary-1.2.1.1-2QgeQJQfCPf69oxJVZZ5cG
    blaze-html-0.9.0.1-2Wxj0X1c4OOA0Fs6NGHGGN
    blaze-markup-0.8.2.0-JO1Oy9jYgbGFSxqAItqjWc
    yaml-0.8.28-Ieakn9anBtq6yQ3JvkiNrC
    scientific-0.3.5.2-IWSZVQGiPwx2zNrAPvmBEO
    vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    hslua-0.9.5-IJAQqniRINuOSwPQgypdD
    hslua-module-text-0.1.2.1-DPtIMyaWHeQB3VMlF03F8g binary-0.8.5.1
    SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI
    haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n deepseq-1.4.3.0
    JuicyPixels-3.2.9.4-42pzrRTSPFC5lhvZoCz3yy
    Glob-0.9.1-6YcAbT5wqosERCyEFB7odX
    cmark-gfm-0.1.3-D4NajCuHPT6J2ZXIfca2cg
    doctemplates-0.2.1-EitFR3rRDRaEPF8fiDt2QY
    http-client-0.5.10-AxYlTlvJIlk6516tCYnLpx
    http-client-tls-0.3.5.3-fB2E7FZpOW47xcf7UMVyg
    http-types-0.9.1-4ZIPDJugy3GJAtyWZ0RpKv
    case-insensitive-1.2.0.10-AWseT79MXu13ZYpcQBCANd unix-2.7.2.2
    time-1.8.0.2 network-uri-2.6.1.0-18L86fks2XD2OSuhve27bS
    network-2.6.3.3-BLvpugKNYUSFzAKouqFcFM
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             syb-0.7-3Lq8MQxmYP07qktjI1jxu0=f985ea42a9fa578e0f67572a93e19b5d
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             unordered-containers-0.2.9.0-14GJxyni7Ou4ztgK034uJm=a19fc431946ec4b21dbc4dc9d0f6448c
             parsec-3.1.13.0-E3xu0p0JtSPICcgXxkVqap=e5bced146b6517b43ed5d06001479bde
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj=b7726d921cac66adc5c8f9f66f5b25f0
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             zip-archive-0.3.2.3-LgUrGVKZgpI9ReZJW8j79i=3c2883150dd2bfc596abfdac7e714230
             HTTP-4000.3.9-3xcNNC0DKEzJdVZPECdmFb=555b2712d11be1cf5b97faf0b067fe1c
             texmath-0.10.1.1-5tHDj20AWYh6B2PpRjt2ye=e7b36b032d1c8abeab439b6f226b0fae
             xml-1.3.14-gmCpsUXEJ0Cd36ZPTskAU=d10a974e22e128d84bfcf55c875efa2c
             split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7=b6b8499789ca23888d2f286cbdde6707
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             pandoc-types-1.17.3.1-1M7FPLUb3W2Ipz5WQuexGO=46d558e2865c752f2381d3e3a7da71a5
             aeson-1.2.4.0-LfzbQdLtEh8Dr9TGmQripa=4a8adb8dc6357086bd8deb5249fe98d7
             aeson-pretty-0.8.5-9mezPRONyA4AILQoCIf0oN=10e28b8794cb73de387f4c7517158d8c
             tagsoup-0.14.3-19uVu5Flcy8Esb4Yvzzgji=99ff776242c2d3f3e899e6183c10d332
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM=fc994ec0331fc01f98e1d968398a1aa2
             skylighting-0.5.0.1-3Y58YKszwd81snC6b6iY44=f4a983b03b9cb071913201dcd182184e
             data-default-0.7.1.1-AA4CT1Ft3yBIiqFbrFdPSr=0186e0f4b96bc201d2baef8ade597d90
             temporary-1.2.1.1-2QgeQJQfCPf69oxJVZZ5cG=ab0f4b4f4a78e7c697cf1bced8c58e9c
             blaze-html-0.9.0.1-2Wxj0X1c4OOA0Fs6NGHGGN=d4749ddd32d1bff43101b58ffdfa6b64
             blaze-markup-0.8.2.0-JO1Oy9jYgbGFSxqAItqjWc=8e9b9ff2cdf9e89a23593b7f85e59200
             yaml-0.8.28-Ieakn9anBtq6yQ3JvkiNrC=50edc76082879a23308d85953e87e16a
             scientific-0.3.5.2-IWSZVQGiPwx2zNrAPvmBEO=6e538d6297179a35ae8f400426125b37
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             hslua-0.9.5-IJAQqniRINuOSwPQgypdD=f25fdd32ba798fa8a110b57ab12979e1
             hslua-module-text-0.1.2.1-DPtIMyaWHeQB3VMlF03F8g=e3885adf9dcfd5d6045f8d595a8d94ca
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI=a1e214e4043a6e8594f125021a39000f
             haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n=6190889e581e299524df9ddefc6f117b
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             JuicyPixels-3.2.9.4-42pzrRTSPFC5lhvZoCz3yy=30b3cdc5ec3c527cc168a960f9c146b5
             Glob-0.9.1-6YcAbT5wqosERCyEFB7odX=fad7e7d277a16cb728c3296aa8a39443
             cmark-gfm-0.1.3-D4NajCuHPT6J2ZXIfca2cg=b35e0b5136d6bc980ac8f1f62d09bf59
             doctemplates-0.2.1-EitFR3rRDRaEPF8fiDt2QY=12810d5cb26b4429269f90b16e44c552
             http-client-0.5.10-AxYlTlvJIlk6516tCYnLpx=5e8bbaaf8e0a61f5d08fe65fdcd32f7f
             http-client-tls-0.3.5.3-fB2E7FZpOW47xcf7UMVyg=5a98de4d6a63c7f3c079c224fe0a2745
             http-types-0.9.1-4ZIPDJugy3GJAtyWZ0RpKv=b80836ab18bdd54a07dfb2450d10ef5b
             case-insensitive-1.2.0.10-AWseT79MXu13ZYpcQBCANd=d2a631059bf8ed4631eaacfed742cab7
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             network-uri-2.6.1.0-18L86fks2XD2OSuhve27bS=2690938855a63b0d59221887564a11f0
             network-2.6.3.3-BLvpugKNYUSFzAKouqFcFM=58be2fae16c0eb05685e5ecea6703cff
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

