/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.NodeComponent;

public class LineAttributes
extends NodeComponent {
    public static final int ALLOW_WIDTH_READ = 0;
    public static final int ALLOW_WIDTH_WRITE = 1;
    public static final int ALLOW_PATTERN_READ = 2;
    public static final int ALLOW_PATTERN_WRITE = 3;
    public static final int ALLOW_ANTIALIASING_READ = 4;
    public static final int ALLOW_ANTIALIASING_WRITE = 5;
    public static final int PATTERN_SOLID = 0;
    public static final int PATTERN_DASH = 1;
    public static final int PATTERN_DOT = 2;
    public static final int PATTERN_DASH_DOT = 3;
    public static final int PATTERN_USER_DEFINED = 4;
    private static final int[] readCapabilities = new int[]{4, 2, 0};

    public LineAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LineAttributes(float f, int n, boolean bl) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("LineAttributes0"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((LineAttributesRetained)this.retained).initLineWidth(f);
        ((LineAttributesRetained)this.retained).initLinePattern(n);
        ((LineAttributesRetained)this.retained).initLineAntialiasingEnable(bl);
    }

    public void setLineWidth(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes1"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setLineWidth(f);
        } else {
            ((LineAttributesRetained)this.retained).initLineWidth(f);
        }
    }

    public float getLineWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes2"));
        }
        return ((LineAttributesRetained)this.retained).getLineWidth();
    }

    public void setLinePattern(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes3"));
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("LineAttributes4"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setLinePattern(n);
        } else {
            ((LineAttributesRetained)this.retained).initLinePattern(n);
        }
    }

    public int getLinePattern() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes5"));
        }
        return ((LineAttributesRetained)this.retained).getLinePattern();
    }

    public void setPatternMask(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes8"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setPatternMask(n);
        } else {
            ((LineAttributesRetained)this.retained).initPatternMask(n);
        }
    }

    public int getPatternMask() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes9"));
        }
        return ((LineAttributesRetained)this.retained).getPatternMask();
    }

    public void setPatternScaleFactor(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes10"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setPatternScaleFactor(n);
        } else {
            ((LineAttributesRetained)this.retained).initPatternScaleFactor(n);
        }
    }

    public int getPatternScaleFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes11"));
        }
        return ((LineAttributesRetained)this.retained).getPatternScaleFactor();
    }

    public void setLineAntialiasingEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes6"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setLineAntialiasingEnable(bl);
        } else {
            ((LineAttributesRetained)this.retained).initLineAntialiasingEnable(bl);
        }
    }

    public boolean getLineAntialiasingEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes7"));
        }
        return ((LineAttributesRetained)this.retained).getLineAntialiasingEnable();
    }

    void createRetained() {
        this.retained = new LineAttributesRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.duplicateNodeComponent(this);
        return lineAttributes;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        LineAttributesRetained lineAttributesRetained = (LineAttributesRetained)nodeComponent.retained;
        LineAttributesRetained lineAttributesRetained2 = (LineAttributesRetained)this.retained;
        lineAttributesRetained2.initLineWidth(lineAttributesRetained.getLineWidth());
        lineAttributesRetained2.initLinePattern(lineAttributesRetained.getLinePattern());
        lineAttributesRetained2.initLineAntialiasingEnable(lineAttributesRetained.getLineAntialiasingEnable());
        lineAttributesRetained2.initPatternMask(lineAttributesRetained.getPatternMask());
        lineAttributesRetained2.initPatternScaleFactor(lineAttributesRetained.getPatternScaleFactor());
    }
}

