/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabisch";
        final String metaValue_bn = "Bengaals";
        final String metaValue_bo = "Tibetaans";
        final String metaValue_el = "Grieks";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebreeuws";
        final String metaValue_hy = "Armeens";
        final String metaValue_ii = "Yi";
        final String metaValue_ja = "Japans";
        final String metaValue_jv = "Javaans";
        final String metaValue_ka = "Georgisch";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaans";
        final String metaValue_lo = "Laotiaans";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongools";
        final String metaValue_my = "Birmaans";
        final String metaValue_or = "Odia";
        final String metaValue_sd = "Sindhi";
        final String metaValue_si = "Singalees";
        final String metaValue_su = "Soendanees";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_tl = "Tagalog";
        final String metaValue_ban = "Balinees";
        final String metaValue_bax = "Bamoun";
        final String metaValue_bug = "Buginees";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_got = "Gothisch";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_mni = "Meitei";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_peo = "Oudperzisch";
        final String metaValue_phn = "Foenicisch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blissymbolen";
        final Object[][] data = new Object[][] {
            { "ksh", "K\u00f6lsch" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandees" },
            { "Zsym", "Symbolen" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "egl", "Emiliano" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "%%NJIVA", "Gniva/Njiva-dialect" },
            { "xmf", "Mingreels" },
            { "egy", "Oudegyptisch" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension" },
            { "rar", "Rarotongan" },
            { "tet", "Tetun" },
            { "%%BARLA", "Barlavento-dialectgroep van Kabuverdianu" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabische Emiraten" },
            { "nl_BE", "Vlaams" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua en Barbuda" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentini\u00eb" },
            { "Prti", "Inscriptioneel Parthisch" },
            { "AS", "Amerikaans-Samoa" },
            { "AT", "Oostenrijk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "en_US", "Amerikaans Engels" },
            { "AX", "\u00c5land" },
            { "mye", "Myene" },
            { "AZ", "Azerbeidzjan" },
            { "%%AREVELA", "Oost-Armeens" },
            { "BA", "Bosni\u00eb en Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Koemuks" },
            { "BE", "Belgi\u00eb" },
            { "gmh", "Middelhoogduits" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarije" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzja" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribisch Nederland" },
            { "BR", "Brazili\u00eb" },
            { "BS", "Bahama\u2019s" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouveteiland" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "Visp", "Zichtbare spraak" },
            { "CA", "Canada" },
            { "CC", "Cocoseilanden" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Centraal-Afrikaanse Republiek" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Zwitserland" },
            { "CI", "Ivoorkust" },
            { "CK", "Cookeilanden" },
            { "CL", "Chili" },
            { "Kthi", "Kaithi" },
            { "CM", "Kameroen" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kaapverdi\u00eb" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmaseiland" },
            { "CY", "Cyprus" },
            { "CZ", "Tsjechi\u00eb" },
            { "eka", "Ekajuk" },
            { "Ahom", "Ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "West-Vlaams" },
            { "%%RIGIK", "Klassiek Volap\u00fck" },
            { "DE", "Duitsland" },
            { "goh", "Oudhoogduits" },
            { "ace", "Atjehs" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goa Konkani" },
            { "DJ", "Djibouti" },
            { "DK", "Denemarken" },
            { "ach", "Akoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "DO", "Dominicaanse Republiek" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Opperfrankisch" },
            { "Mtei", metaValue_mni },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algerije" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta en Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiaments" },
            { "ada", "Adangme" },
            { "EE", "Estland" },
            { "tiv", "Tiv" },
            { "EG", "Egypte" },
            { "EH", "Westelijke Sahara" },
            { "chg", "Chagatai" },
            { "pau", "Palaus" },
            { "chk", "Chuukees" },
            { "chn", "Chinook Jargon" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopi\u00eb" },
            { "EU", "Europese Unie" },
            { "elx", "Elamitisch" },
            { "chy", "Cheyenne" },
            { "Inds", "Indus" },
            { "ady", "Adygees" },
            { "aeb", "Tunesisch Arabisch" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandeilanden" },
            { "FM", "Micronesia" },
            { "FO", "Faer\u00f6er" },
            { "Taml", metaValue_ta },
            { "FR", "Frankrijk" },
            { "Kpel", metaValue_kpe },
            { "pcd", "Picardisch" },
            { "tkl", "Tokelaus" },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "rgn", "Romagnol" },
            { "grc", "Oudgrieks" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhur" },
            { "vot", "Votisch" },
            { "GB", "Verenigd Koninkrijk" },
            { "GD", "Grenada" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Groenland" },
            { "enm", "Middelengels" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatoriaal-Guinea" },
            { "GR", "Griekenland" },
            { "GS", "Zuid-Georgia en Zuidelijke Sandwicheilanden" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvania-Duits" },
            { "GW", "Guinee-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "Nieuw Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Soran\u00ee" },
            { "zxx", "geen lingu\u00efstische inhoud" },
            { "Jurc", "Jurchen" },
            { "tly", "Talysh" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "Oostenrijks Duits" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong SAR van China" },
            { "HM", "Heard en McDonaldeilanden" },
            { "HN", "Honduras" },
            { "HR", "Kroati\u00eb" },
            { "agq", "Aghem" },
            { "gsw", "Zwitserduits" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongarije" },
            { "rif", "Riffijns" },
            { "tmh", "Tamashek" },
            { "IC", "Canarische Eilanden" },
            { "nan", "Minnanyu" },
            { "peo", metaValue_peo },
            { "ID", "Indonesi\u00eb" },
            { "IE", "Ierland" },
            { "nap", "Napolitaans" },
            { "%%NDYUKA", "Ndyuka-dialect" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Isra\u00ebl" },
            { "Nbat", "Nabateaans" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Britse Gebieden in de Indische Oceaan" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "IJsland" },
            { "IT", "Itali\u00eb" },
            { "Zmth", "Wiskundige notatie" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Computer" },
            { "pfl", "Paltsisch" },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "%%EKAVSK", "Servisch met Ekaviaanse uitspraak" },
            { "JO", "Jordani\u00eb" },
            { "gur", "Gurune" },
            { "JP", "Japan" },
            { "%%1606NICT", "Laat Middelfrans tot 1606" },
            { "ain", "Ainu" },
            { "%%KOCIEWIE", "Kociewie" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "Zwitsers Hoogduits" },
            { "izh", "Ingrisch" },
            { "KE", "Kenia" },
            { "419", "Latijns-Amerika" },
            { "KG", "Kirgizi\u00eb" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoren" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts en Nevis" },
            { "Zinh", "Overge\u00ebrfd" },
            { "fr_CA", "Canadees Frans" },
            { "KP", "Noord-Korea" },
            { "KR", "Zuid-Korea" },
            { "Plrd", "Pollard-fonetisch" },
            { "fr_CH", "Zwitsers Frans" },
            { "KW", "Koeweit" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kaaimaneilanden" },
            { "KZ", "Kazachstan" },
            { "Cyrl", "Cyrillisch" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "Oudkerkslavisch Cyrillisch" },
            { "gwi", "Gwich\u02bcin" },
            { "%%LUNA1918", "Russische spelling van 1917" },
            { "nds", "Nedersaksisch" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadisch" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "Yupik" },
            { "LS", "Lesotho" },
            { "Phlv", "Boek Pahlavi" },
            { "LT", "Litouwen" },
            { "LU", "Luxemburg" },
            { "LV", "Letland" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libi\u00eb" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "%%LAUKIKA", "Laukika" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldavi\u00eb" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshalleilanden" },
            { "ale", "Aleoetisch" },
            { "MK", "Macedoni\u00eb" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongoli\u00eb" },
            { "new", "Newari" },
            { "MO", "Macau SAR van China" },
            { "aln", "Gegisch" },
            { "MP", "Noordelijke Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "MU", "Mauritius" },
            { "alt", "Zuid-Alta\u00efsch" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Maleisi\u00eb" },
            { "MZ", "Mozambique" },
            { "Phli", "Inscriptioneel Pahlavi" },
            { "NA", "Namibi\u00eb" },
            { "NC", "Nieuw-Caledoni\u00eb" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Eenvormig herziene spelling" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Psalmen Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Nederland" },
            { "NO", "Noorwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsakonisch" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Nieuw-Zeeland" },
            { "Merc", "Meroitisch cursief" },
            { "rom", "Romani" },
            { "Mero", "Mero\u00eftisch" },
            { "crh", "Krim-Tataars" },
            { "ang", "Oudengels" },
            { "OM", "Oman" },
            { "%%PETR1708", "Petr1708" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "Kasjoebisch" },
            { "en_GB", "Brits Engels" },
            { "PE", "Peru" },
            { "ttt", "Moslim Tat" },
            { "PF", "Frans-Polynesi\u00eb" },
            { "PG", "Papoea-Nieuw-Guinea" },
            { "PH", "Filipijnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "Ewondo" },
            { "PM", "Saint-Pierre en Miquelon" },
            { "PN", "Pitcairneilanden" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestijnse gebieden" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "PY", "Paraguay" },
            { "tum", "Toemboeka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Schots standaard-Engels" },
            { "jam", "Jamaicaans Creools" },
            { "pms", "Pi\u00ebmontees" },
            { "niu", "Niueaans" },
            { "QO", "overig Oceani\u00eb" },
            { "ext", "Extremeens" },
            { "lez", "Lezgisch" },
            { "%%FONUPA", "Oeralisch Fonetisch Alfabet" },
            { "tvl", "Tuvaluaans" },
            { "Tavt", "Tai Viet" },
            { "%%SOTAV", "Sotavento-dialectgroep van Kabuverdianu" },
            { "001", "wereld" },
            { "002", "Afrika" },
            { "njo", "Ao Naga" },
            { "003", "Noord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Zuid-Amerika" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Pontisch" },
            { "Rjng", "Rejang" },
            { "009", "Oceani\u00eb" },
            { "%%SURSILV", "Sursilvan" },
            { "RO", "Roemeni\u00eb" },
            { "Qaaw", "Qaaw" },
            { "RS", "Servi\u00eb" },
            { "Mroo", "Mro" },
            { "Qaax", "Qaax" },
            { "Qaau", "Qaau" },
            { "RU", "Rusland" },
            { "Qaav", "Qaav" },
            { "Qaas", "Qaas" },
            { "RW", "Rwanda" },
            { "Qaat", "Qaat" },
            { "Qaaq", "Qaaq" },
            { "Qaar", "Qaar" },
            { "Qaba", "Qaba" },
            { "%%METELKO", "Metelko-alfabet" },
            { "Mani", "Manicheaans" },
            { "Ugar", "Ugaritisch" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "pon", "Pohnpeiaans" },
            { "Mand", "Mandaeans" },
            { "Qaay", "Qaay" },
            { "SB", "Salomonseilanden" },
            { "twq", "Tasawaq" },
            { "Qaaz", "Qaaz" },
            { "011", "West-Afrika" },
            { "SC", "Seychellen" },
            { "Qabh", "Qabh" },
            { "SD", "Soedan" },
            { "Qabi", "Qabi" },
            { "013", "Midden-Amerika" },
            { "SE", "Zweden" },
            { "Qabf", "Qabf" },
            { "014", "Oost-Afrika" },
            { "arc", "Aramees" },
            { "Loma", "Loma" },
            { "Qabg", "Qabg" },
            { "015", "Noord-Afrika" },
            { "SG", "Singapore" },
            { "Qabd", "Qabd" },
            { "SH", "Sint-Helena" },
            { "Qabe", "Qabe" },
            { "017", "Centraal-Afrika" },
            { "SI", "Sloveni\u00eb" },
            { "Qabb", "Qabb" },
            { "018", "Zuidelijk Afrika" },
            { "SJ", "Spitsbergen en Jan Mayen" },
            { "Qabc", "Qabc" },
            { "Bamu", metaValue_bax },
            { "019", "Amerika" },
            { "SK", "Slowakije" },
            { "Qabp", "Qabp" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "Qabq", "Qabq" },
            { "SM", "San Marino" },
            { "Qabn", "Qabn" },
            { "SN", "Senegal" },
            { "Qabo", "Qabo" },
            { "SO", "Somali\u00eb" },
            { "arn", "Mapudungun" },
            { "Qabl", "Qabl" },
            { "Qabm", "Qabm" },
            { "arp", "Arapaho" },
            { "Qabj", "Qabj" },
            { "SR", "Suriname" },
            { "aro", "Araona" },
            { "Qabk", "Qabk" },
            { "SS", "Zuid-Soedan" },
            { "ST", "Sao Tom\u00e9 en Principe" },
            { "arq", "Algerijns Arabisch" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Syri\u00eb" },
            { "yao", "Yao" },
            { "SZ", "Swaziland" },
            { "arw", "Arawak" },
            { "arz", "Egyptisch Arabisch" },
            { "ary", "Marokkaans Arabisch" },
            { "yap", "Yapees" },
            { "rtm", "Rotumaans" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "021", "Noordelijk Amerika" },
            { "TC", "Turks- en Caicoseilanden" },
            { "yav", "Yangben" },
            { "TD", "Tsjaad" },
            { "Qaag", "Qaag" },
            { "Qaah", "Qaah" },
            { "TF", "Franse Gebieden in de zuidelijke Indische Oceaan" },
            { "ase", "Amerikaanse Gebarentaal" },
            { "Qaae", "Qaae" },
            { "TG", "Togo" },
            { "Qaaf", "Qaaf" },
            { "TH", "Thailand" },
            { "Qaac", "Qaac" },
            { "Qaad", "Qaad" },
            { "TJ", "Tadzjikistan" },
            { "Qaaa", "Qaaa" },
            { "029", "Caribisch gebied" },
            { "TK", "Tokelau" },
            { "Qaab", "Qaab" },
            { "TL", "Oost-Timor" },
            { "ybb", "Yemba" },
            { "Qaao", "Qaao" },
            { "TM", "Turkmenistan" },
            { "Qaap", "Qaap" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunesi\u00eb" },
            { "Qaam", "Qaam" },
            { "TO", "Tonga" },
            { "Qaan", "Qaan" },
            { "%%NULIK", "Modern Volap\u00fck" },
            { "Qaak", "Qaak" },
            { "Qaal", "Qaal" },
            { "TR", "Turkije" },
            { "TT", "Trinidad en Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturisch" },
            { "rue", "Roetheens" },
            { "rug", "Roviana" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Ngumba" },
            { "Zzzz", "onbekend schriftsysteem" },
            { "Sind", metaValue_sd },
            { "UA", "Oekra\u00efne" },
            { "lij", "Ligurisch" },
            { "rup", "Aroemeens" },
            { "030", "Oost-Azi\u00eb" },
            { "tyv", "Toevaans" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Zuid-Azi\u00eb" },
            { "hai", "Haida" },
            { "035", "Zuidoost-Azi\u00eb" },
            { "UG", "Oeganda" },
            { "hak", "Hakka" },
            { "039", "Zuid-Europa" },
            { "Sinh", metaValue_si },
            { "UM", "Kleine afgelegen eilanden van de Verenigde Staten" },
            { "liv", "Lijfs" },
            { "US", "Verenigde Staten" },
            { "haw", "Hawa\u00efaans" },
            { "Qabx", "Qabx" },
            { "%%1959ACAD", "Academisch" },
            { "Qabv", "Qabv" },
            { "Qabw", "Qabw" },
            { "UY", "Uruguay" },
            { "prg", "Oudpruisisch" },
            { "Qabt", "Qabt" },
            { "UZ", "Oezbekistan" },
            { "Qabu", "Qabu" },
            { "tzm", "Tamazight (Centraal-Marokko)" },
            { "Qabr", "Qabr" },
            { "Qabs", "Qabs" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vaticaanstad" },
            { "pro", "Oudproven\u00e7aals" },
            { "VC", "Saint Vincent en de Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagdeneilanden" },
            { "VI", "Amerikaanse Maagdeneilanden" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Oudnoors" },
            { "053", "Australazi\u00eb" },
            { "%%AREVMDA", "West-Armeens" },
            { "054", "Melanesi\u00eb" },
            { "WF", "Wallis en Futuna" },
            { "057", "Micronesische regio" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "nov", "Novial" },
            { "avk", "Kotava" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "wal", "Wolaytta" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesi\u00eb" },
            { "%%KSCOR", "Standaardspelling" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "ongeschreven" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "lmo", "Lombardisch" },
            { "fan", "Fang" },
            { "%%BALANKA", "Balanka-dialect van Anii" },
            { "%%ROZAJ", "Resiaans" },
            { "%%SUTSILV", "Sutsilvan" },
            { "fat", "Fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "ZA", "Zuid-Afrika" },
            { "Deva", "Devanagari" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "onbekend gebied" },
            { "Runr", "Runic" },
            { "lol", "Mongo" },
            { "nso", "Noord-Sotho" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "jmc", "Machame" },
            { "hif", "Fijisch Hindi" },
            { "hil", "Hiligaynon" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "hit", "Hettitisch" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Mayahi\u00ebrogliefen" },
            { "lrc", "Noordelijk Luri" },
            { "Copt", metaValue_cop },
            { "nwc", "Klassiek Nepalbhasa" },
            { "udm", "Oedmoerts" },
            { "Khmr", metaValue_km },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "sah", "Jakoets" },
            { "ltg", "Letgaals" },
            { "sam", "Samaritaans-Aramees" },
            { "Aghb", "Kaukasisch Albanees" },
            { "%%SCOUSE", "Liverpools (Scouse)" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Judeo-Perzisch" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Aloekoe-dialect" },
            { "lua", "Luba-Lulua" },
            { "%%BISCAYAN", "Biskajaans" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipijns" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Beloetsji" },
            { "den", "Slavey" },
            { "ban", metaValue_ban },
            { "uga", "Oegaritisch" },
            { "fit", "Tornedal-Fins" },
            { "luy", "Luyia" },
            { "bar", "Beiers" },
            { "bas", "Basa" },
            { "bax", metaValue_bax },
            { "jrb", "Judeo-Arabisch" },
            { "es_ES", "Europees Spaans" },
            { "nzi", "Nzima" },
            { "sco", "Schots" },
            { "scn", "Siciliaans" },
            { "aa", "Afar" },
            { "ab", "Abchazisch" },
            { "bbc", "Batak Toba" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "bbj", "Ghomala\u2019" },
            { "am", "Amhaars" },
            { "Arab", metaValue_ar },
            { "an", "Aragonees" },
            { "%%SOLBA", "Stolvizza/Solbica-dialect" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana of Hiragana" },
            { "as", "Assamees" },
            { "sdc", "Sassarees" },
            { "Lina", "Lineair A" },
            { "av", "Avarisch" },
            { "Linb", "Lineair B" },
            { "sdh", "Pahlavani" },
            { "ay", "Aymara" },
            { "az", "Azerbeidzjaans" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Oseacco/Osojane-dialect" },
            { "%%UNIFON", "Unifon fonetisch alfabet" },
            { "ba", "Basjkiers" },
            { "be", "Wit-Russisch" },
            { "bg", "Bulgaars" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Bretons" },
            { "bs", "Bosnisch" },
            { "see", "Seneca" },
            { "Mymr", metaValue_my },
            { "sei", "Seri" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkoeps" },
            { "ca", "Catalaans" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Tsjetsjeens" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Gewijzigde spelling" },
            { "co", "Corsicaans" },
            { "Orya", metaValue_or },
            { "cr", "Cree" },
            { "cs", "Tsjechisch" },
            { "cu", "Kerkslavisch" },
            { "yrl", "Nheengatu" },
            { "cv", "Tsjoevasjisch" },
            { "cy", "Welsh" },
            { "Yiii", metaValue_ii },
            { "da", "Deens" },
            { "pt_PT", "Europees Portugees" },
            { "de", "Duits" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "jut", "Jutlands" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Oudiers" },
            { "dv", "Divehi" },
            { "es_419", "Latijns-Amerikaans Spaans" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "lzh", "Klassiek Chinees" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "sgs", "Samogitisch" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "el", metaValue_el },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Lazisch" },
            { "es", "Spaans" },
            { "et", "Estisch" },
            { "eu", "Baskisch" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritaans" },
            { "shi", "Tashelhiyt" },
            { "hsb", "Oppersorbisch" },
            { "Hani", "Han" },
            { "%%ULSTER", "Ulster" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Perzisch" },
            { "Hans", "vereenvoudigd" },
            { "Hant", "traditioneel" },
            { "ff", "Fulah" },
            { "shu", "Tsjadisch Arabisch" },
            { "hsn", "Xiangyu" },
            { "fi", "Fins" },
            { "fj", "Fijisch" },
            { "fon", "Fon" },
            { "bgn", "Westers Beloetsji" },
            { "yue", "Kantonees" },
            { "fo", "Faer\u00f6ers" },
            { "umb", "Umbundu" },
            { "fr", "Frans" },
            { "sid", "Sidamo" },
            { "fy", "Fries" },
            { "ga", "Iers" },
            { "gd", "Schots-Gaelisch" },
            { "gl", "Galicisch" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhojpuri" },
            { "und", "onbekende taal" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Ha\u00eftiaans Creools" },
            { "hu", "Hongaars" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Cajun-Frans" },
            { "%%FONIPA", "Internationaal Fonetisch Alfabet" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", metaValue_ii },
            { "frm", "Middelfrans" },
            { "%%RUMGR", "Rumgr" },
            { "ik", "Inupiaq" },
            { "fro", "Oudfrans" },
            { "frp", "Arpitaans" },
            { "io", "Ido" },
            { "frs", "Oost-Fries" },
            { "bjn", "Banjar" },
            { "frr", "Noord-Fries" },
            { "is", "IJslands" },
            { "it", "Italiaans" },
            { "iu", "Inuktitut" },
            { "sli", "Silezisch Duits" },
            { "%%HOGNORSK", "Hoognoors" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Oud Zuid-Arabisch" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "bkm", "Kom" },
            { "sma", "Zuid-Samisch" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavian" },
            { "%%BAUDDHA", "Bauddha" },
            { "mad", "Madoerees" },
            { "smj", "Lule-Samisch" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari-Samisch" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makassaars" },
            { "wuu", "Wuyu" },
            { "sms", "Skolt-Samisch" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Gikuyu" },
            { "mas", "Maa" },
            { "kj", "Kuanyama" },
            { "kk", "Kazachs" },
            { "kl", "Groenlands" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmiri" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", "Avestaans" },
            { "ku", "Koerdisch" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizisch" },
            { "snk", "Soninke" },
            { "Mult", "Multani" },
            { "la", "Latijn" },
            { "Hatr", "Hatran" },
            { "lb", "Luxemburgs" },
            { "lg", "Luganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgs" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulisch" },
            { "lo", metaValue_lo },
            { "lt", "Litouws" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lets" },
            { "sog", "Sogdisch" },
            { "mg", "Malagassisch" },
            { "mh", "Marshallees" },
            { "mi", "Maori" },
            { "mk", "Macedonisch" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "Moksja" },
            { "mde", "Maba" },
            { "dsb", "Nedersorbisch" },
            { "Armi", "Keizerlijk Aramees" },
            { "na", "Nauruaans" },
            { "nb", "Noors - Bokm\u00e5l" },
            { "nd", "Noord-Ndebele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Nederlands" },
            { "nn", "Noors - Nynorsk" },
            { "no", "Noors" },
            { "nr", "Zuid-Ndbele" },
            { "nv", "Navajo" },
            { "kaa", "Karakalpaks" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabylisch" },
            { "%%POLYTON", "Polytonaal" },
            { "oc", "Occitaans" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Vroegmodern Engels" },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "om", "Afaan Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Dusun" },
            { "or", metaValue_or },
            { "Modi", "Modi" },
            { "os", "Ossetisch" },
            { "%%ALALC97", "Romanisering ALA-LC, editie 1997" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardisch" },
            { "mfe", "Morisyen" },
            { "srn", "Sranantongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Het Lipovaz-dialect van het Resiaans" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bakhtiari" },
            { "pl", "Pools" },
            { "dum", "Middelnederlands" },
            { "%%VALLADER", "Vallader" },
            { "ps", "Pasjtoe" },
            { "pt", "Portugees" },
            { "mga", "Middeliers" },
            { "pt_BR", "Braziliaans Portugees" },
            { "%%BOHORIC", "Bohori\u010d-alfabet" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "bra", "Braj" },
            { "%%JAUER", "Jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "Surmiran" },
            { "mgo", "Meta\u2019" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "%%VAIDIKA", "Vaidika" },
            { "stq", "Saterfries" },
            { "Ethi", "Ethiopisch" },
            { "%%JYUTPING", "Jyutping" },
            { "rm", "Reto-Romaans" },
            { "rn", "Kirundi" },
            { "ro", "Roemeens" },
            { "%%SAAHO", metaValue_ssy },
            { "ru", "Russisch" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kaapverdisch Creools" },
            { "mic", "Mi\u2019kmaq" },
            { "suk", "Sukuma" },
            { "en_AU", "Australisch Engels" },
            { "Dupl", "Duployan snelschrift" },
            { "sa", "Sanskriet" },
            { "%%UCCOR", "Eenvormige spelling" },
            { "sc", "Sardijns" },
            { "sus", "Soesoe" },
            { "sd", metaValue_sd },
            { "se", "Noord-Samisch" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Servo-Kroatisch" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Soemerisch" },
            { "sk", "Slowaaks" },
            { "sl", "Sloveens" },
            { "Gran", "Grantha" },
            { "sm", "Samoaans" },
            { "sn", "Shona" },
            { "so", "Somalisch" },
            { "sq", "Albanees" },
            { "sr", "Servisch" },
            { "ss", "Swazi" },
            { "Java", metaValue_jv },
            { "st", "Zuid-Sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-dialect" },
            { "sv", "Zweeds" },
            { "sw", "Swahili" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Azi\u00eb" },
            { "bua", "Boerjatisch" },
            { "143", "Centraal-Azi\u00eb" },
            { "te", metaValue_te },
            { "145", "West-Azi\u00eb" },
            { "tg", "Tadzjieks" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "en_CA", "Canadees Engels" },
            { "tk", "Turkmeens" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaans" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "swb", "Shimaore" },
            { "Cakm", "Chakma" },
            { "tt", "Tataars" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahitiaans" },
            { "%%BISKE", "San Giorgio/Bila-dialect" },
            { "150", "Europa" },
            { "151", "Oost-Europa" },
            { "154", "Noord-Europa" },
            { "dzg", "Dazaga" },
            { "155", "West-Europa" },
            { "ug", "Oeigoers" },
            { "Kore", metaValue_ko },
            { "Ital", "Oud-italisch" },
            { "kgp", "Kaingang" },
            { "Zyyy", "algemeen" },
            { "uk", "Oekra\u00efens" },
            { "zea", "Zeeuws" },
            { "ur", "Urdu" },
            { "%%1994", "Gestandaardiseerde Resiaanse spelling" },
            { "xal", "Kalmuks" },
            { "zen", "Zenaga" },
            { "uz", "Oezbeeks" },
            { "kha", "Khasi" },
            { "%%1996", "Duitse spelling van 1996" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "vi", "Vietnamees" },
            { "kho", "Khotanees" },
            { "khq", "Koyra Chiini" },
            { "%%TARASK", "Taraskievica-spelling" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Klassiek Syrisch" },
            { "Osma", "Osmanya" },
            { "quc", "K\u2019iche\u2019" },
            { "qug", "Kichwa" },
            { "gaa", "Ga" },
            { "wa", "Waals" },
            { "gag", "Gagaoezisch" },
            { "syr", "Syrisch" },
            { "Grek", metaValue_el },
            { "gan", "Ganyu" },
            { "kiu", "Kirmanck\u00ee" },
            { "Lydi", "Lydisch" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "wo", "Wolof" },
            { "zgh", "Standaard Marokkaanse Tamazight" },
            { "ar_001", "modern standaard Arabisch" },
            { "Cans", "Verenigde Canadese Aboriginal-symbolen" },
            { "%%FONXSAMP", "Transcriptie volgens X-SAMPA" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Mantsjoe" },
            { "Latf", "Gotisch Latijns" },
            { "szl", "Silezisch" },
            { "Hluw", "Anatolische hi\u00ebrogliefen" },
            { "gba", "Gbaya" },
            { "mni", metaValue_mni },
            { "Latn", "Latijns" },
            { "Latg", "Gaelisch Latijns" },
            { "xh", "Xhosa" },
            { "byn", "Blin" },
            { "%%PAMAKA", "Pamaka" },
            { "Lyci", "Lycisch" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrisch Dari" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Vroeg modern Frans" },
            { "yi", "Jiddisch" },
            { "mos", "Mossi" },
            { "Syrc", "Syriac" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "es_MX", "Mexicaans Spaans" },
            { "Syrj", "West-Aramees" },
            { "ota", "Ottomaans-Turks" },
            { "Syre", "Estrangelo Aramees" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Carisch" },
            { "kln", "Kalenjin" },
            { "zh", "Chinees" },
            { "Afak", "Defaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Oudpermisch" },
            { "zu", "Zoeloe" },
            { "%%MONOTON", "Monotonaal" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "Cham", "Cham" },
            { "gez", "Ge\u2019ez" },
            { "mrj", "West-Mari" },
            { "Syrn", "Oost-Aramees" },
            { "Elba", "Elbasan" },
            { "Narb", "Oud Noord-Arabisch" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egyptisch demotisch" },
            { "Egyh", "Egyptisch hi\u00ebratisch" },
            { "%%ITIHASA", "Episch Sanskriet" },
            { "Palm", "Palmyreens" },
            { "ebu", "Embu" },
            { "Egyp", "Egyptische hi\u00ebrogliefen" },
            { "Geok", "Georgisch Khutsuri" },
            { "zh_Hans", "vereenvoudigd Chinees" },
            { "koi", "Komi-Permjaaks" },
            { "Hung", "Oudhongaars" },
            { "kok", "Konkani" },
            { "%%1901", "Traditionele Duitse spelling" },
            { "kos", "Kosraeaans" },
            { "vec", "Venetiaans" },
            { "zh_Hant", "traditioneel Chinees" },
            { "Sund", metaValue_su },
            { "vep", "Wepsisch" },
            { "kpe", metaValue_kpe },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valenciaans" },
            { "Cprt", "Cyprisch" },
            { "%%BAKU1926", "Eenvormig Turkse Latijnse alfabet" },
            { "%%IJEKAVSK", "Servisch met Ijekaviaanse uitspraak" },
            { "mua", "Mundang" },
            { "mul", "Meerdere talen" },
            { "%%PUTER", "Puter" },
            { "cad", "Caddo" },
            { "mus", "Creek" },
            { "Glag", "Glagolitisch" },
            { "gil", "Gilbertees" },
            { "%%KKCOR", "Algemene spelling" },
            { "Cher", metaValue_chr },
            { "car", "Caribisch" },
            { "cay", "Cayuga" },
            { "krc", "Karatsjaj-Balkarisch" },
            { "inh", "Ingoesjetisch" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "krl", "Karelisch" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
