/*
 * Copyright (c) 1997, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources.ext;

import sun.util.resources.TimeZoneNamesBundle;

public final class TimeZoneNames_sv extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Acre, normaltid", "ACT",
                                     "Acre, sommartid", "ACST",
                                     "Acre, normaltid", "ACT"};
        String ADELAIDE[] = new String[] {"Central standardtid (Sydaustralien)", "ACST",
                                          "Central sommartid (South Australia)", "ACDT",
                                          "Central tid (Sydaustralien)", "ACT"};
        String AGT[] = new String[] {"Argentina, normaltid", "ART",
                                     "Argentina, sommartid", "ARST",
                                     "Argentinsk tid", "ART"};
        String AKST[] = new String[] {"Alaska, normaltid", "AKST",
                                      "Alaska, sommartid", "AKDT",
                                      "Alaskisk tid", "AKT"};
        String AMT[] = new String[] {"Amazonas, normaltid", "AMT",
                                     "Amazonas, sommartid", "AMST",
                                     "Amazonas-tid", "AMT"};
        String ARAST[] = new String[] {"Arabisk normaltid", "AST",
                                       "Arabisk sommartid", "ADT",
                                       "Arabisk tid", "AT"};
        String ARMT[] = new String[] {"Armenien, normaltid", "AMT",
                                      "Armenien, sommartid", "AMST",
                                      "Armenisk tid", "AMT"};
        String AST[] = new String[] {"Atlantisk normaltid", "AST",
                                     "Atlantisk sommartid", "ADT",
                                     "Atlantisk tid", "AT"};
        String BDT[] = new String[] {"Bangladesh, normaltid", "BDT",
                                     "Bangladesh, sommartid", "BDST",
                                     "Bangladeshisk tid", "BDT"};
        String BRISBANE[] = new String[] {"\u00D6stlig standardtid (Queensland)", "AEST",
                                          "\u00D6stlig sommartid (Queensland)", "AEDT",
                                          "\u00D6stlig tid (Queensland)", "AET"};
        String BROKEN_HILL[] = new String[] {"Central standardtid (Sydaustralien/New South Wales)", "ACST",
                                             "Central sommartid (South Australia/New South Wales)", "ACDT",
                                             "Central tid (Sydaustralien/New South Wales)", "ACT"};
        String BRT[] = new String[] {"Brasilien, normaltid", "BRT",
                                     "Brasilien, sommartid", "BRST",
                                     "Brasiliansk tid", "BRT"};
        String BTT[] = new String[] {"Bhutan, normaltid", "BTT",
                                     "Bhutan, sommartid", "BTST",
                                     "Bhutanesisk tid", "BTT"};
        String CAT[] = new String[] {"Centralafrikansk tid", "CAT",
                                     "Centralafrikansk sommartid", "CAST",
                                     "Centralafrikansk tid", "CAT"};
        String CET[] = new String[] {"Centraleuropeisk tid", "CET",
                                     "Centraleuropeisk sommartid", "CEST",
                                     "Centraleuropeisk tid", "CET"};
        String CHAST[] = new String[] {"Chatham, normaltid", "CHAST",
                                       "Chatham, sommartid", "CHADT",
                                       "Chathams tid", "CHAT"};
        String CHUT[] = new String[] {"Chuuk, normaltid", "CHUT",
                                      "Chuuk, sommartid", "CHUST",
                                      "Chuuk, normaltid", "CHUT"};
        String CIT[] = new String[] {"Centralindonesisk tid", "WITA",
                                     "Centralindonesisk sommartid", "CIST",
                                     "Centralindonesisk tid", "WITA"};
        String CLT[] = new String[] {"Chile, normaltid", "CLT",
                                     "Chile, sommartid", "CLST",
                                     "Chilensk tid", "CLT"};
        String CST[] = new String[] {"Central normaltid", "CST",
                                     "Central sommartid", "CDT",
                                     "Central tid", "CT"};
        String CTT[] = new String[] {"Kina, normaltid", "CST",
                                     "Kina, sommartid", "CDT",
                                     "Kinesisk tid", "CT"};
        String CUBA[] = new String[] {"Kuba, normaltid", "CST",
                                      "Kuba, sommartid", "CDT",
                                      "Kubansk tid", "CT"};
        String DARWIN[] = new String[] {"Central standardtid (Nordterritoriet)", "ACST",
                                        "Central sommartid (Nordterritoriet)", "ACDT",
                                        "Central tid (Nordterritoriet)", "ACT"};
        String DUBLIN[] = new String[] {"Greenwichtid", "GMT",
                                        "Irland, sommartid", "IST",
                                        "Irl\u00E4ndsk tid", "IT"};
        String EAT[] = new String[] {"\u00d6stafrikansk tid", "EAT",
                                     "\u00d6stafrikansk sommartid", "EAST",
                                     "\u00D6stafrikansk tid", "EAT"};
        String EASTER[] = new String[] {"P\u00e5sk\u00f6n, normaltid", "EAST",
                                        "P\u00e5sk\u00f6n, sommartid", "EASST",
                                        "P\u00E5sk\u00F6n-tid", "EAST"};
        String EET[] = new String[] {"\u00d6steuropeisk tid", "EET",
                                     "\u00d6steuropeisk sommartid", "EEST",
                                     "\u00d6steuropeisk tid", "EET"};
        String EGT[] = new String[] {"\u00d6stgr\u00f6nl\u00e4ndsk tid", "EGT",
                                     "\u00d6stgr\u00f6nl\u00e4ndsk sommartid", "EGST",
                                     "\u00D6stgr\u00F6nl\u00E4ndsk tid", "EGT"};
        String EST[] = new String[] {"Eastern, normaltid", "EST",
                                     "Eastern, sommartid", "EDT",
                                     "\u00D6stlig tid", "ET"};
        String EST_NSW[] = new String[] {"\u00D6stlig standardtid (New South Wales)", "AEST",
                                         "\u00D6stlig sommartid (New South Wales)", "AEDT",
                                         "\u00D6stlig tid (New South Wales)", "AET"};
        String FET[] = new String[] {"Kaliningradtid", "FET",
                                     "\u00D6steuropeisk sommartid", "FEST",
                                     "Kaliningradtid", "FET"};
        String GHMT[] = new String[] {"Ghana, normaltid", "GMT",
                                      "Ghana, sommartid", "GHST",
                                      "Ghana, normaltid", "GMT"};
        String GAMBIER[] =  new String[] {"Gambier, normaltid", "GAMT",
                                          "Gambier, sommartid", "GAMST",
                                          "Gambier\u00F6arna-tid", "GAMT"};
        String GMT[] = new String[] {"Greenwichtid", "GMT",
                                     "Greenwichtid", "GMT",
                                     "Greenwichtid", "GMT"};
        String GMTBST[] = new String[] {"Greenwichtid", "GMT",
                                        "Brittisk sommartid", "BST",
                                        "Brittisk tid", "BT"};
        String GST[] = new String[] {"Gulf-normaltid", "GST",
                                     "Gulf-sommartid", "GDT",
                                     "Golfens tid", "GT"};
        String HKT[] =  new String[] {"Hong Kong, normaltid", "HKT",
                                      "Hong Kong, sommartid", "HKST",
                                      "Hongkong-tid", "HKT"};
        String HST[] = new String[] {"Hawaii, normaltid", "HST",
                                     "Hawaii, sommartid", "HDT",
                                     "Hawaiiansk tid", "HT"};
        String ICT[] = new String[] {"Indokinesisk tid", "ICT",
                                     "Indokinesisk sommartid", "ICST",
                                     "Indokinesisk tid", "ICT"};
        String IRKT[] = new String[] {"Irkutsk, normaltid", "IRKT",
                                      "Irkutsk, sommartid", "IRKST",
                                      "Irkutsk-tid", "IRKT"};
        String IRT[] = new String[] {"Iran, normaltid", "IRST",
                                     "Iran, sommartid", "IRDT",
                                     "Iransk tid", "IRT"};
        String ISRAEL[] = new String[] {"Israel, normaltid", "IST",
                                        "Israel, sommartid", "IDT",
                                        "Israelisk tid", "IT"};
        String IST[] = new String[] {"Indien, normaltid", "IST",
                                     "Indien, sommartid", "IDT",
                                     "Indisk tid", "IT"};
        String JST[] = new String[] {"Japan, normaltid", "JST",
                                     "Japan, sommartid", "JDT",
                                     "Japansk tid", "JT"};
        String KRAT[] = new String[] {"Krasnojarsk, normaltid", "KRAT",
                                      "Krasnojarsk, sommartid", "KRAST",
                                      "Krasnojarsk-tid", "KRAT"};
        String KST[] = new String[] {"Korea, normaltid", "KST",
                                     "Korea, sommartid", "KDT",
                                     "Koreansk tid", "KT"};
        String LORD_HOWE[] = new String[] {"Lord Howe, normaltid", "LHST",
                                           "Lord Howe, sommartid", "LHDT",
                                           "Lord Howe-tid", "LHT"};
        String MHT[] = new String[] {"Marshall\u00f6arna, normaltid", "MHT",
                                     "Marshall\u00f6arna, sommartid", "MHST",
                                     "Marshall\u00F6arna-tid", "MHT"};
        String MMT[] = new String[] {"Myanmar, normaltid", "MMT",
                                     "Myanmar, sommartid", "MMST",
                                     "Myanmar-tid", "MMT"};
        String MSK[] = new String[] {"Moskva, normaltid", "MSK",
                                     "Moskva, sommartid", "MSD",
                                     "Moskvas tid", "MT"};
        String MST[] = new String[] {"Mountain, normaltid", "MST",
                                     "Mountain, sommartid", "MDT",
                                     "Mountain-tid", "MT"};
        String MYT[] = new String[] {"Malaysia, normaltid", "MYT",
                                     "Malaysia, sommartid", "MYST",
                                     "Malaysisk tid", "MYT"};
        String NORONHA[] = new String[] {"Fernando de Noronha, normaltid", "FNT",
                                         "Fernando de Noronha, sommartid", "FNST",
                                         "Fernando de Noronha-tid", "FNT"};
        String NOVT[] = new String[] {"Novosibirsk, normaltid", "NOVT",
                                      "Novosibirsk, sommartid", "NOVST",
                                      "Sibirisk tid", "NOVT"};
        String NPT[] = new String[] {"Nepal, normaltid", "NPT",
                                     "Nepal, sommartid", "NPST",
                                     "Nepalesisk tid", "NPT"};
        String NST[] = new String[] {"Newfoundland, normaltid", "NST",
                                     "Newfoundland, sommartid", "NDT",
                                     "Newfoundl\u00E4ndsk tid", "NT"};
        String NZST[] = new String[] {"Nya Zeeland, normaltid", "NZST",
                                      "Nya Zeeland, sommartid", "NZDT",
                                      "Nyzeel\u00E4ndsk tid", "NZT"};
        String PITCAIRN[] = new String[] {"Pitcairn, normaltid", "PST",
                                          "Pitcairn, sommartid", "PDT",
                                          "Pitcairn-tid", "PT"};
        String PKT[] = new String[] {"Pakistan, normaltid", "PKT",
                                     "Pakistan, sommartid", "PKST",
                                     "Pakistansk tid", "PKT"};
        String PONT[] = new String[] {"Pohnpei, normaltid", "PONT",
                                      "Pohnpei, sommartid", "PONST",
                                      "Ponape-tid", "PONT"};
        String PST[] = new String[] {"Stilla havet, normaltid", "PST",
                                     "Stilla havet, sommartid", "PDT",
                                     "Stillahavet", "PT"};
        String SAST[] = new String[] {"Sydafrika, normaltid", "SAST",
                                      "Sydafrika, sommartid", "SAST",
                                      "Sydafrikansk tid", "SAT"};
        String SBT[] = new String[] {"Salomon\u00f6arna, normaltid", "SBT",
                                     "Salomon\u00f6arna, sommartid", "SBST",
                                     "Salomon\u00F6arna-tid", "SBT"};
        String SGT[] = new String[] {"Singapore, normaltid", "SGT",
                                     "Singapore, sommartid", "SGST",
                                     "Singapore-tid", "SGT"};
        String TASMANIA[] = new String[] {"\u00D6stlig standardtid (Tasmania)", "AEST",
                                          "\u00D6stlig sommartid (Tasmanien)", "AEDT",
                                          "\u00D6stlig tid (Tasmania)", "AET"};
        String TMT[] = new String[] {"Turkmenistan, normaltid", "TMT",
                                     "Turkmenistan, sommartid", "TMST",
                                     "Turkmensk tid", "TMT"};
        String ULAT[]= new String[] {"Ulaanbaatar, normaltid", "ULAT",
                                     "Ulaanbaatar, sommartid", "ULAST",
                                     "Ulaanbaatar-tid", "ULAT"};
        String WAT[] = new String[] {"V\u00e4stafrikansk tid", "WAT",
                                     "V\u00e4stafrikansk sommartid", "WAST",
                                     "V\u00E4stafrikansk tid", "WAT"};
        String WET[] = new String[] {"V\u00e4steuropeisk tid", "WET",
                                     "V\u00e4steuropeisk sommartid", "WEST",
                                     "V\u00E4steuropeisk tid", "WET"};
        String WIT[] = new String[] {"V\u00e4stindonesisk tid", "WIB",
                                     "V\u00e4stindonesisk sommartid", "WIST",
                                     "V\u00E4stindonesisk tid", "WIB"};
        String WST_AUS[] = new String[] {"Western Standard Time (Australien)", "AWST",
                                         "V\u00E4stlig sommartid (Australien)", "AWDT",
                                         "V\u00E4stlig tid (Australien)", "AWT"};
        String SAMOA[] = new String[] {"Samoa, normaltid", "SST",
                                       "Samoa, sommartid", "SDT",
                                       "Samoansk tid", "ST"};
        String WST_SAMOA[] = new String[] {"V\u00e4stsamoansk tid", "WSST",
                                           "V\u00e4stsamoansk sommartid", "WSDT",
                                           "V\u00E4stsamoansk tid", "WST"};
        String ChST[] = new String[] {"Chamorro, normaltid", "ChST",
                                      "Chamorro, sommartid", "ChDT",
                                      "Chamorros tid", "ChT"};
        String VICTORIA[] = new String[] {"\u00D6stlig standardtid (Victoria)", "AEST",
                                          "\u00D6stlig sommartid (Victoria)", "AEDT",
                                          "\u00D6stlig tid (Victoria)", "AET"};
        String UTC[] = new String[] {"Koordinerad universell tid", "UTC",
                                     "Koordinerad universell tid", "UTC",
                                     "UTC (koordinerad v\u00E4rldstid)", "UTC"};
        String UZT[] = new String[] {"Uzbekistan, normaltid", "UZT",
                                     "Uzbekistan, sommartid", "UZST",
                                     "Uzbekisk tid", "UZT"};
        String XJT[] = new String[] {"Kina, normaltid", "XJT",
                                     "Kina, sommartid", "XJDT",
                                     "Kinesisk tid", "XJT"};
        String YAKT[] = new String[] {"Jakutsk, normaltid", "YAKT",
                                      "Jakutsk, sommartid", "YAKST",
                                      "Jakutsk-tid", "YAKT"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            {"UTC", UTC},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", GMT},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", EAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", CAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", CAT},
            {"America/Adak", HST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"Paraguay, normaltid", "PYT",
                                               "Paraguay, sommartid", "PYST",
                                               "Paraguayansk tid", "PYT"}},
            {"America/Atikokan", EST},
            {"America/Atka", HST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"Colombia, normaltid", "COT",
                                             "Colombia, sommartid", "COST",
                                             "Kolombiansk tid", "COT"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", EST},
            {"America/Caracas", new String[] {"Venezuela, normaltid", "VET",
                                              "Venezuela, sommartid", "VEST",
                                              "Venezuelansk tid", "VET"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"Franska Guyana, normaltid", "GFT",
                                              "Franska Guyana, sommartid", "GFST",
                                              "Franska Guyana-tid", "GFT"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Nelson", MST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"V\u00e4stra Gr\u00f6nland, normaltid", "WGT",
                                              "V\u00e4stra Gr\u00f6nland, sommartid", "WGST",
                                              "V\u00E4stgr\u00F6nl\u00E4ndsk tid", "WGT"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", AST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"Ecuador, normaltid", "ECT",
                                                "Ecuador, sommartid", "ECST",
                                                "Ecuadoriansk tid", "ECT"}},
            {"America/Guyana", new String[] {"Guyana, normaltid", "GYT",
                                             "Guyana, sommartid", "GYST",
                                             "Guyansk tid", "GYT"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"Bolivia, normaltid", "BOT",
                                             "Bolivia, sommartid", "BOST",
                                             "Boliviansk tid", "BOT"}},
            {"America/Lima", new String[] {"Peru, normaltid", "PET",
                                           "Peru, sommartid", "PEST",
                                           "Peruansk tid", "PET"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", AKST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"Saint-Pierre-et-Miquelon, normaltid", "PMST",
                                               "Saint-Pierre-et-Miquelon, sommartid", "PMDT",
                                               "Saint-Pierre och Miquelons tid", "PMT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"Uruguay, normaltid", "UYT",
                                                 "Uruguay, sommartid", "UYST",
                                                 "Uruguayansk tid", "UYT"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"Surinam, normaltid", "SRT",
                                                 "Surinam, sommartid", "SRST",
                                                 "Surinamsk tid", "SRT"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"Davis, normaltid", "DAVT",
                                               "Davis, sommartid", "DAVST",
                                               "Davis-tid", "DAVT"}},
            {"Antarctica/DumontDUrville", new String[] {"Dumont-d'Urville, normaltid", "DDUT",
                                                        "Dumont-d'Urville, sommartid", "DDUST",
                                                        "Dumont-d'Urville-tid", "DDUT"}},
            {"Antarctica/Macquarie", new String[] {"Macquarie\u00F6n, normaltid", "MIST",
                                                   "Macquarie\u00F6n, sommartid", "MIST",
                                                   "Macquarie\u00F6n, normaltid", "MIST"}},
            {"Antarctica/Mawson", new String[] {"Mawson, normaltid", "MAWT",
                                                "Mawson, sommartid", "MAWST",
                                                "Mawson-tid", "MAWT"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"Rothera, normaltid", "ROTT",
                                                 "Rothera, sommartid", "ROTST",
                                                 "Rothera-tid", "ROTT"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa, normaltid", "SYOT",
                                               "Syowa, sommartid", "SYOST",
                                               "Syowa-tid", "SYOT"}},
            {"Antarctica/Troll", new String[] {"Koordinerad universell tid", "UTC",
                                               "Centraleuropeisk sommartid", "CEST",
                                               "Troll Time", "ATT"}},
            {"Antarctica/Vostok", new String[] {"Vostok, normaltid", "VOST",
                                                "Vostok, sommartid", "VOSST",
                                                "Vostok-tid", "VOST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Alma-Ata, normaltid", "ALMT",
                                          "Alma-Ata, sommartid", "ALMST",
                                          "Alma-Ata-tid", "ALMT"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"Anadyr, normaltid", "ANAT",
                                          "Anadyr, sommartid", "ANAST",
                                          "Anadyr-tid", "ANAT"}},
            {"Asia/Aqtau", new String[] {"Aqtau, normaltid", "AQTT",
                                         "Aqtau, sommartid", "AQTST",
                                         "Aqtau-tid", "AQTT"}},
            {"Asia/Aqtobe", new String[] {"Aqtobe, normaltid", "AQTT",
                                          "Aqtobe, sommartid", "AQTST",
                                          "Aqtobe-tid", "AQTT"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"Azerbajdzjan, normaltid", "AZT",
                                        "Azerbajdzjan, sommartid", "AZST",
                                        "Azerbajdzjansk tid", "AZT"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"Kirgizstan, normaltid", "KGT",
                                           "Kirgizstan, sommartid", "KGST",
                                           "Kirgizisk tid", "KGT"}},
            {"Asia/Brunei", new String[] {"Brunei, normaltid", "BNT",
                                          "Brunei, sommartid", "BNST",
                                          "Bruneisk tid", "BNT"}},
            {"Asia/Calcutta", IST},
            {"Asia/Choibalsan", new String[] {"Choibalsan, normaltid", "CHOT",
                                              "Choibalsan, sommartid", "CHOST",
                                              "Choibalsan-tid", "CHOT"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Chita", YAKT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"Timor-Leste, normaltid", "TLT",
                                        "Timor-Leste, sommartid", "TLST",
                                        "\u00D6sttimor, normaltid", "TLT"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"Tadzjikistan, normaltid", "TJT",
                                            "Tadzjikistan, sommartid", "TJST",
                                            "Tadzjikisk tid", "TJT"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Hovd, normaltid", "HOVT",
                                        "Hovd, sommartid", "HOVST",
                                        "Hovd-tid", "HOVT"}},
            {"Asia/Irkutsk", IRKT},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\u00d6stindonesisk tid", "WIT",
                                            "\u00d6stindonesisk sommartid", "EIST",
                                            "\u00D6stindonesisk tid", "WIT"}},
            {"Asia/Kabul", new String[] {"Afghanistan, normaltid", "AFT",
                                         "Afghanistan, sommartid", "AFST",
                                         "Afghansk tid", "AFT"}},
            {"Asia/Kamchatka", new String[] {"Petropavlovsk-Kamtjatka, normaltid", "PETT",
                                             "Petropavlovsk-Kamtjatka, sommartid", "PETST",
                                             "Petropavlovsk-Kamtjatskij-tid", "PETT"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", XJT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", YAKT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", KRAT},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Magadan, normaltid", "MAGT",
                                           "Magadan, sommartid", "MAGST",
                                           "Magadan-tid", "MAGT"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Filippinerna, normaltid", "PHT",
                                          "Filippinerna, sommartid", "PHST",
                                          "Filippinsk tid", "PHT"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", KRAT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral, normaltid", "ORAT",
                                        "Oral, sommartid", "ORAST",
                                        "Oral-tid", "ORAT"}},
            {"Asia/Omsk", new String[] {"Omsk, normaltid", "OMST",
                                        "Omsk, sommartid", "OMSST",
                                        "Omsk-tid", "OMST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda, normaltid", "QYZT",
                                             "Qyzylorda, sommartid", "QYZST",
                                             "Qyzylorda-tid", "QYZT"}},
            {"Asia/Rangoon", MMT},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"Sakhalin, normaltid", "SAKT",
                                            "Sakhalin, sommartid", "SAKST",
                                            "Sakhalin-tid", "SAKT"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Srednekolymsk", new String[] {"Srednekolymsk Time", "SRET",
                                                 "Srednekolymsk Daylight Time", "SREDT",
                                                 "Srednekolymsk Time", "SRET"}},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"Georgien, normaltid", "GET",
                                           "Georgien, sommartid", "GEST",
                                           "Georgisk tid", "GET"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", XJT},
            {"Asia/Ust-Nera", new String[] {"Ust-Nera, normaltid", "VLAT",
                                            "Ust-Nera, sommartid", "VLAST",
                                            "Ust-Nera, normaltid", "VLAT"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"Vladivostok, normaltid", "VLAT",
                                               "Vladivostok, sommartid", "VLAST",
                                               "Vladivostok-tid", "VLAT"}},
            {"Asia/Yakutsk", YAKT},
            {"Asia/Yangon", MMT},
            {"Asia/Yekaterinburg", new String[] {"Jekaterinburg, normaltid", "YEKT",
                                                 "Jekaterinburg, sommartid", "YEKST",
                                                 "Jekaterinburg-tid", "YEKT"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"Azorerna, normaltid", "AZOT",
                                              "Azorerna, sommartid", "AZOST",
                                              "Azorerna-tid", "AZOT"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"Kap Verde, normaltid", "CVT",
                                                  "Kap Verde, sommartid", "CVST",
                                                  "Kap Verde-tid", "CVT"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"Sydgeorgien, normaltid", "GST",
                                                     "Sydgeorgien, sommartid", "GDT",
                                                     "Sydgeorgisk tid", "GT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"Falklands\u00f6arna, normaltid", "FKT",
                                               "Falklands\u00f6arna, sommartid", "FKST",
                                               "Falklands\u00F6arna-tid", "FKT"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"Central v\u00E4stlig normaltid (Australien)", "ACWST",
                                              "Central v\u00E4stlig sommartid (Australien)", "ACWDT",
                                              "Central v\u00E4stlig tid (Australien)", "ACWT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", MSK},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"Samara, normaltid", "SAMT",
                                            "Samara, sommartid", "SAMST",
                                            "Samara-tid", "SAMT"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", MSK},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"Indiska oceanen, normaltid", "IOT",
                                            "Indiska oceanen, sommartid", "IOST",
                                            "Indiska Ocean\u00F6arna-tid", "IOT"}},
            {"Indian/Christmas", new String[] {"Jul\u00f6n, normaltid", "CXT",
                                               "Jul\u00f6n, sommartid", "CXST",
                                               "Jul\u00F6n-tid", "CIT"}},
            {"Indian/Cocos", new String[] {"Cocos-Keeling\u00f6arna, normaltid", "CCT",
                                           "Cocos-Keeling\u00f6arna, sommartid", "CCST",
                                           "Kokos\u00F6arna-tid", "CCT"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"Franska s\u00f6dra och antarktiska omr\u00e5dena, normaltid", "TFT",
                                               "Franska s\u00f6dra och antarktiska omr\u00e5dena, sommartid", "TFST",
                                               "Franska s\u00F6dra och antarktiska \u00F6arna-tid", "TFT"}},
            {"Indian/Mahe", new String[] {"Seychellerna, normaltid", "SCT",
                                          "Seychellerna, sommartid", "SCST",
                                          "Seychellisk tid", "SCT"}},
            {"Indian/Maldives", new String[] {"Maldiverna, normaltid", "MVT",
                                              "Maldiverna, sommartid", "MVST",
                                              "Maldivisk tid", "MVT"}},
            {"Indian/Mauritius", new String[] {"Mauritius, normaltid", "MUT",
                                               "Mauritius, sommartid", "MUST",
                                               "Mauritiansk tid", "MUT"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"Reunion, normaltid", "RET",
                                             "Reunion, sommartid", "REST",
                                             "Reunion-tid", "RET"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"Mellaneuropeisk tid", "MET",
                                  "Mellaneuropeisk sommartid", "MEST",
                                  "MET", "MET"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Bougainville", new String[] {"Bougainville Standard Time", "BST",
                                                   "Bougainville Daylight Time", "BST",
                                                   "Bougainville Time", "BT"}},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"Vanuatu, normaltid", "VUT",
                                            "Vanuatu, sommartid", "VUST",
                                            "Vanuatu-tid", "VUT"}},
            {"Pacific/Enderbury", new String[] {"Phoenix-\u00f6arna, normaltid", "PHOT",
                                                "Phoenix-\u00f6arna, sommartid", "PHOST",
                                                "Phoenix\u00F6arna-tid", "PHOT"}},
            {"Pacific/Fakaofo", new String[] {"Tokelau, normaltid", "TKT",
                                              "Tokelau, sommartid", "TKST",
                                              "Tokelau-tid", "TKT"}},
            {"Pacific/Fiji", new String[] {"Fiji, normaltid", "FJT",
                                           "Fiji, sommartid", "FJST",
                                           "Fijiansk tid", "FJT"}},
            {"Pacific/Funafuti", new String[] {"Tuvalu, normaltid", "TVT",
                                               "Tuvalu, sommartid", "TVST",
                                               "Tuvalu-tid", "TVT"}},
            {"Pacific/Galapagos", new String[] {"Galapagos, normaltid", "GALT",
                                                "Galapagos, sommartid", "GALST",
                                                "Galapagos-tid", "GALT"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Line-\u00f6arna, normaltid", "LINT",
                                                 "Line-\u00f6arna, sommartid", "LINST",
                                                 "Line Islands-tid", "LINT"}},
            {"Pacific/Kosrae", new String[] {"Kosrae, normaltid", "KOST",
                                             "Kosrae, sommartid", "KOSST",
                                             "Kosrae-tid", "KOST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"Marquesas, normaltid", "MART",
                                                "Marquesas, sommartid", "MARST",
                                                "Marquesas\u00F6arna-tid", "MART"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"Nauru, normaltid", "NRT",
                                            "Nauru, sommartid", "NRST",
                                            "Nauruansk tid", "NRT"}},
            {"Pacific/Niue", new String[] {"Niue, normaltid", "NUT",
                                           "Niue, sommartid", "NUST",
                                           "Niue-tid", "NUT"}},
            {"Pacific/Norfolk", new String[] {"Norfolk, normaltid", "NFT",
                                              "Norfolk, sommartid", "NFST",
                                              "Norfolk-tid", "NFT"}},
            {"Pacific/Noumea", new String[] {"Nya Caledonien, normaltid", "NCT",
                                             "Nya Caledonien, sommartid", "NCST",
                                             "Nya Kaledonien-tid", "NCT"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"Palau, normaltid", "PWT",
                                            "Palau, sommartid", "PWST",
                                            "Palau-tid", "PWT"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"Papua Nya Guinea, normaltid", "PGT",
                                                   "Papua Nya Guinea, sommartid", "PGST",
                                                   "Papua Nya Guinea-tid", "PGT"}},
            {"Pacific/Rarotonga", new String[] {"Cook\u00f6arna, normaltid", "CKT",
                                                "Cook\u00f6arna, sommartid", "CKHST",
                                                "Cook\u00F6arna-tid", "CKT"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"Tahiti, normaltid", "TAHT",
                                             "Tahiti, sommartid", "TAHST",
                                             "Tahiti-tid", "TAHT"}},
            {"Pacific/Tarawa", new String[] {"Gilbert\u00f6arna, normaltid", "GILT",
                                             "Gilbert\u00f6arna, sommartid", "GILST",
                                             "Gilbert\u00F6arna-tid", "GILT"}},
            {"Pacific/Tongatapu", new String[] {"Tonga, normaltid", "TOT",
                                                "Tonga, sommartid", "TOST",
                                                "Tonga-tid", "TOT"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"Wake, normaltid", "WAKT",
                                           "Wake, sommartid", "WAKST",
                                           "Wake-tid", "WAKT"}},
            {"Pacific/Wallis", new String[] {"Wallis & Futuna, normaltid", "WFT",
                                             "Wallis & Futuna, sommartid", "WFST",
                                             "Wallis- och Futuna\u00F6arna-tid", "WFT"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
