/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.SimpleDigest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.log.Logger;

class SimpleLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepository repository;

    public SimpleLocalRepositoryManager(File basedir) {
        this(basedir, "simple");
    }

    public SimpleLocalRepositoryManager(String basedir) {
        this(basedir != null ? new File(basedir) : null, "simple");
    }

    SimpleLocalRepositoryManager(File basedir, String type2) {
        Objects.requireNonNull(basedir, "base directory cannot be null");
        this.repository = new LocalRepository(basedir.getAbsoluteFile(), type2);
    }

    public SimpleLocalRepositoryManager setLogger(Logger logger) {
        return this;
    }

    @Override
    public LocalRepository getRepository() {
        return this.repository;
    }

    String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path2 = new StringBuilder(128);
        path2.append(artifact.getGroupId().replace('.', '/')).append('/');
        path2.append(artifact.getArtifactId()).append('/');
        path2.append(artifact.getBaseVersion()).append('/');
        path2.append(artifact.getArtifactId()).append('-');
        if (local) {
            path2.append(artifact.getBaseVersion());
        } else {
            path2.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path2.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path2.append('.').append(artifact.getExtension());
        }
        return path2.toString();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.getPathForArtifact(artifact, true);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getPathForArtifact(artifact, false);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.getPath(metadata, "local");
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getPath(metadata, this.getRepositoryKey(repository, context));
    }

    String getRepositoryKey(RemoteRepository repository, String context) {
        String key2;
        if (repository.isRepositoryManager()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(repository.getId());
            buffer.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            SimpleDigest digest = new SimpleDigest();
            digest.update(context);
            for (String subKey : subKeys) {
                digest.update(subKey);
            }
            buffer.append(digest.digest());
            key2 = buffer.toString();
        } else {
            key2 = repository.getId();
        }
        return key2;
    }

    private String getPath(Metadata metadata, String repositoryKey) {
        StringBuilder path2 = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path2.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path2.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path2.append(metadata.getVersion()).append('/');
                }
            }
        }
        path2.append(this.insertRepositoryKey(metadata.getType(), repositoryKey));
        return path2.toString();
    }

    private String insertRepositoryKey(String filename, String repositoryKey) {
        int idx = filename.indexOf(46);
        String result = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
        return result;
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path2 = this.getPathForArtifact(request.getArtifact(), false);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file2.isFile()) {
            result.setFile(file2);
            result.setAvailable(true);
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = new LocalMetadataResult(request);
        Metadata metadata = request.getMetadata();
        String context = request.getContext();
        RemoteRepository remote = request.getRepository();
        String path2 = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        if (file2.isFile()) {
            result.setFile(file2);
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
    }
}

