/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstAndJvmFieldPropertiesLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "()V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "substituteGetter", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetFieldImpl;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "substituteSetter", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrSetFieldImpl;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "backend"})
public final class ConstAndJvmFieldPropertiesLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        return super.visitDeclaration(declaration);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(declaration.getDescriptor())) {
            declaration.setGetter(null);
            declaration.setSetter(null);
        }
        return super.visitProperty(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return super.visitMemberAccess(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        FunctionDescriptor descriptor2 = expression2.getDescriptor();
        if (!(descriptor2 instanceof PropertyAccessorDescriptor)) {
            return super.visitCall(expression2);
        }
        PropertyDescriptor property = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(property)) {
            return descriptor2 instanceof PropertyGetterDescriptor ? (IrExpression)this.substituteGetter((PropertyGetterDescriptor)descriptor2, expression2) : (IrExpression)this.substituteSetter((PropertyAccessorDescriptor)descriptor2, expression2);
        }
        if (property instanceof SyntheticJavaPropertyDescriptor) {
            expression2.setDispatchReceiver(expression2.getExtensionReceiver());
            expression2.setExtensionReceiver(null);
        }
        return super.visitCall(expression2);
    }

    private final IrSetFieldImpl substituteSetter(PropertyAccessorDescriptor descriptor2, IrCall expression2) {
        int n = expression2.getStartOffset();
        int n2 = expression2.getEndOffset();
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        IrExpression irExpression = expression2.getDispatchReceiver();
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        IrExpression irExpression2 = expression2.getValueArgument(CollectionsKt.getLastIndex(list2));
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        return new IrSetFieldImpl(n, n2, propertyDescriptor, irExpression, irExpression2, expression2.getOrigin(), expression2.getSuperQualifier());
    }

    private final IrGetFieldImpl substituteGetter(PropertyGetterDescriptor descriptor2, IrCall expression2) {
        int n = expression2.getStartOffset();
        int n2 = expression2.getEndOffset();
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        return new IrGetFieldImpl(n, n2, propertyDescriptor, expression2.getDispatchReceiver(), expression2.getOrigin(), expression2.getSuperQualifier());
    }
}

