/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.testng.TestNGListenerAdapterFactory;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestResultProcessorAdapter;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.internal.time.Clock;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.TestNG;

public class TestNGTestClassProcessor
implements TestClassProcessor {
    private final List<Class<?>> testClasses = new ArrayList();
    private final File testReportDir;
    private final TestNGSpec options;
    private final List<File> suiteFiles;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final ActorFactory actorFactory;
    private ClassLoader applicationClassLoader;
    private Actor resultProcessorActor;
    private TestResultProcessor resultProcessor;

    public TestNGTestClassProcessor(File testReportDir, TestNGSpec options, List<File> suiteFiles, IdGenerator<?> idGenerator, Clock clock, ActorFactory actorFactory) {
        this.testReportDir = testReportDir;
        this.options = options;
        this.suiteFiles = suiteFiles;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.actorFactory = actorFactory;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)resultProcessor);
        this.resultProcessor = (TestResultProcessor)this.resultProcessorActor.getProxy(TestResultProcessor.class);
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void processTestClass(TestClassRunInfo testClass) {
        try {
            this.testClasses.add(this.applicationClassLoader.loadClass(testClass.getTestClassName()));
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not load test class '%s'.", testClass.getTestClassName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.runTests();
        }
        finally {
            this.resultProcessorActor.stop();
        }
    }

    private void runTests() {
        TestNG testNg = new TestNG();
        testNg.setOutputDirectory(this.testReportDir.getAbsolutePath());
        testNg.setDefaultSuiteName(this.options.getDefaultSuiteName());
        testNg.setDefaultTestName(this.options.getDefaultTestName());
        testNg.setParallel(this.options.getParallel());
        testNg.setThreadCount(this.options.getThreadCount());
        this.invokeVerifiedMethod(testNg, "setConfigFailurePolicy", String.class, this.options.getConfigFailurePolicy(), "skip");
        this.invokeVerifiedMethod(testNg, "setPreserveOrder", Boolean.TYPE, this.options.getPreserveOrder(), false);
        this.invokeVerifiedMethod(testNg, "setGroupByInstances", Boolean.TYPE, this.options.getGroupByInstances(), false);
        testNg.setUseDefaultListeners(this.options.getUseDefaultListeners());
        testNg.setVerbose(0);
        testNg.setGroups(CollectionUtils.join((String)",", this.options.getIncludeGroups()));
        testNg.setExcludedGroups(CollectionUtils.join((String)",", this.options.getExcludeGroups()));
        for (String listenerClass : this.options.getListeners()) {
            try {
                testNg.addListener(this.applicationClassLoader.loadClass(listenerClass).newInstance());
            }
            catch (Throwable e) {
                throw new GradleException(String.format("Could not add a test listener with class '%s'.", listenerClass), e);
            }
        }
        if (!this.options.getIncludedTests().isEmpty() || !this.options.getIncludedTestsCommandLine().isEmpty()) {
            testNg.addListener((Object)new SelectedTestsFilter(this.options.getIncludedTests(), this.options.getIncludedTestsCommandLine()));
        }
        if (!this.suiteFiles.isEmpty()) {
            testNg.setTestSuites(GFileUtils.toPaths(this.suiteFiles));
        } else {
            testNg.setTestClasses(this.testClasses.toArray(new Class[0]));
        }
        testNg.addListener((Object)this.adaptListener(new TestNGTestResultProcessorAdapter(this.resultProcessor, this.idGenerator, this.clock)));
        testNg.run();
    }

    private void invokeVerifiedMethod(TestNG testNg, String methodName, Class<?> paramClass, Object value, Object defaultValue) {
        block2: {
            try {
                JavaReflectionUtil.method(TestNG.class, Object.class, (String)methodName, (Class[])new Class[]{paramClass}).invoke((Object)testNg, new Object[]{value});
            }
            catch (NoSuchMethodException e) {
                if (value.equals(defaultValue)) break block2;
                throw e;
            }
        }
    }

    private ITestListener adaptListener(ITestListener listener) {
        TestNGListenerAdapterFactory factory = new TestNGListenerAdapterFactory(this.applicationClassLoader);
        return factory.createAdapter(listener);
    }

    private static class SelectedTestsFilter
    implements IMethodInterceptor {
        private final TestSelectionMatcher matcher;

        public SelectedTestsFilter(Set<String> includedTests, Set<String> includedTestsCommandLine) {
            this.matcher = new TestSelectionMatcher(includedTests, includedTestsCommandLine);
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            ISuite suite = context.getSuite();
            LinkedList<IMethodInstance> filtered = new LinkedList<IMethodInstance>();
            for (IMethodInstance candidate : methods) {
                if (!this.matcher.matchesTest(candidate.getMethod().getTestClass().getName(), candidate.getMethod().getMethodName()) && !this.matcher.matchesTest(suite.getName(), null)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }
    }
}

