/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.net.URI;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public final class NetworkSettings {
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final Logger LOGGER = Logger.getLogger(NetworkSettings.class.getName());
    private static ThreadLocal<Boolean> authenticationDialogSuppressed = new ThreadLocal();

    public static String getProxyHost(URI uRI) {
        ProxyCredentialsProvider proxyCredentialsProvider = (ProxyCredentialsProvider)Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (proxyCredentialsProvider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        return proxyCredentialsProvider == null ? null : proxyCredentialsProvider.getProxyHost(uRI);
    }

    public static String getProxyPort(URI uRI) {
        ProxyCredentialsProvider proxyCredentialsProvider = (ProxyCredentialsProvider)Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (proxyCredentialsProvider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        return proxyCredentialsProvider == null ? null : proxyCredentialsProvider.getProxyPort(uRI);
    }

    public static String getAuthenticationUsername(URI uRI) {
        ProxyCredentialsProvider proxyCredentialsProvider = (ProxyCredentialsProvider)Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (proxyCredentialsProvider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        if (proxyCredentialsProvider != null && proxyCredentialsProvider.isProxyAuthentication(uRI)) {
            return proxyCredentialsProvider.getProxyUserName(uRI);
        }
        return null;
    }

    public static String getKeyForAuthenticationPassword(URI uRI) {
        ProxyCredentialsProvider proxyCredentialsProvider = (ProxyCredentialsProvider)Lookup.getDefault().lookup(ProxyCredentialsProvider.class);
        if (proxyCredentialsProvider == null) {
            LOGGER.warning("No ProxyCredentialsProvider found in lookup " + Lookup.getDefault() + " thus no proxy information will provide!");
        }
        if (proxyCredentialsProvider != null && proxyCredentialsProvider.isProxyAuthentication(uRI)) {
            return PROXY_AUTHENTICATION_PASSWORD;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R suppressAuthenticationDialog(Callable<R> callable) throws Exception {
        try {
            authenticationDialogSuppressed.set(Boolean.TRUE);
            R r = callable.call();
            return r;
        }
        finally {
            authenticationDialogSuppressed.remove();
        }
    }

    public static boolean isAuthenticationDialogSuppressed() {
        return Boolean.TRUE.equals(authenticationDialogSuppressed.get());
    }

    public static abstract class ProxyCredentialsProvider {
        protected abstract String getProxyUserName(URI var1);

        protected abstract char[] getProxyPassword(URI var1);

        protected abstract boolean isProxyAuthentication(URI var1);

        protected abstract String getProxyHost(URI var1);

        protected abstract String getProxyPort(URI var1);
    }
}

