/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.superpom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=SuperPomProvider.class)
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private Model superModel;
    @Requirement
    private ModelProcessor modelProcessor;

    public DefaultSuperPomProvider setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        return this;
    }

    @Override
    public Model getSuperModel(String version) {
        if (this.superModel == null) {
            String resource2 = "/org/apache/maven/model/pom-" + version + ".xml";
            InputStream is2 = this.getClass().getResourceAsStream(resource2);
            if (is2 == null) {
                throw new IllegalStateException("The super POM " + resource2 + " was not found" + ", please verify the integrity of your Maven installation");
            }
            try {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("xml:4.0.0", "xml:4.0.0");
                this.superModel = this.modelProcessor.read(is2, options);
            }
            catch (IOException e2) {
                throw new IllegalStateException("The super POM " + resource2 + " is damaged" + ", please verify the integrity of your Maven installation", e2);
            }
        }
        return this.superModel;
    }
}

