/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.Arrays;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.storage.pack.PackStatistics;

public class DfsPackDescription
implements Comparable<DfsPackDescription> {
    private final DfsRepositoryDescription repoDesc;
    private final String packName;
    private DfsObjDatabase.PackSource packSource;
    private long lastModified;
    private long[] sizeMap;
    private int[] blockSizeMap;
    private long objectCount;
    private long deltaCount;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private PackStatistics packStats;
    private ReftableWriter.Stats refStats;
    private int extensions;
    private int indexVersion;
    private long estimatedPackSize;

    public DfsPackDescription(DfsRepositoryDescription repoDesc, String name2) {
        this.repoDesc = repoDesc;
        int dot = name2.lastIndexOf(46);
        this.packName = dot < 0 ? name2 : name2.substring(0, dot);
        int extCnt = PackExt.values().length;
        this.sizeMap = new long[extCnt];
        this.blockSizeMap = new int[extCnt];
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public void addFileExt(PackExt ext) {
        this.extensions |= ext.getBit();
    }

    public boolean hasFileExt(PackExt ext) {
        return (this.extensions & ext.getBit()) != 0;
    }

    public String getFileName(PackExt ext) {
        return this.packName + '.' + ext.getExtension();
    }

    public DfsStreamKey getStreamKey(PackExt ext) {
        return DfsStreamKey.of(this.getRepositoryDescription(), this.getFileName(ext), ext);
    }

    public DfsObjDatabase.PackSource getPackSource() {
        return this.packSource;
    }

    public DfsPackDescription setPackSource(DfsObjDatabase.PackSource source2) {
        this.packSource = source2;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public DfsPackDescription setLastModified(long timeMillis) {
        this.lastModified = timeMillis;
        return this;
    }

    public long getMinUpdateIndex() {
        return this.minUpdateIndex;
    }

    public DfsPackDescription setMinUpdateIndex(long min2) {
        this.minUpdateIndex = min2;
        return this;
    }

    public long getMaxUpdateIndex() {
        return this.maxUpdateIndex;
    }

    public DfsPackDescription setMaxUpdateIndex(long max2) {
        this.maxUpdateIndex = max2;
        return this;
    }

    public DfsPackDescription setFileSize(PackExt ext, long bytes2) {
        int i = ext.getPosition();
        if (i >= this.sizeMap.length) {
            this.sizeMap = Arrays.copyOf(this.sizeMap, i + 1);
        }
        this.sizeMap[i] = Math.max(0L, bytes2);
        return this;
    }

    public long getFileSize(PackExt ext) {
        int i = ext.getPosition();
        return i < this.sizeMap.length ? this.sizeMap[i] : 0L;
    }

    public int getBlockSize(PackExt ext) {
        int i = ext.getPosition();
        return i < this.blockSizeMap.length ? this.blockSizeMap[i] : 0;
    }

    public DfsPackDescription setBlockSize(PackExt ext, int blockSize) {
        int i = ext.getPosition();
        if (i >= this.blockSizeMap.length) {
            this.blockSizeMap = Arrays.copyOf(this.blockSizeMap, i + 1);
        }
        this.blockSizeMap[i] = Math.max(0, blockSize);
        return this;
    }

    public DfsPackDescription setEstimatedPackSize(long estimatedPackSize) {
        this.estimatedPackSize = Math.max(0L, estimatedPackSize);
        return this;
    }

    public long getEstimatedPackSize() {
        return this.estimatedPackSize;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public DfsPackDescription setObjectCount(long cnt) {
        this.objectCount = Math.max(0L, cnt);
        return this;
    }

    public long getDeltaCount() {
        return this.deltaCount;
    }

    public DfsPackDescription setDeltaCount(long cnt) {
        this.deltaCount = Math.max(0L, cnt);
        return this;
    }

    public PackStatistics getPackStats() {
        return this.packStats;
    }

    DfsPackDescription setPackStats(PackStatistics stats) {
        this.packStats = stats;
        this.setFileSize(PackExt.PACK, stats.getTotalBytes());
        this.setObjectCount(stats.getTotalObjects());
        this.setDeltaCount(stats.getTotalDeltas());
        return this;
    }

    public ReftableWriter.Stats getReftableStats() {
        return this.refStats;
    }

    void setReftableStats(ReftableWriter.Stats stats) {
        this.refStats = stats;
        this.setMinUpdateIndex(stats.minUpdateIndex());
        this.setMaxUpdateIndex(stats.maxUpdateIndex());
        this.setFileSize(PackExt.REFTABLE, stats.totalBytes());
        this.setBlockSize(PackExt.REFTABLE, stats.refBlockSize());
    }

    public DfsPackDescription clearPackStats() {
        this.packStats = null;
        this.refStats = null;
        return this;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public DfsPackDescription setIndexVersion(int version) {
        this.indexVersion = version;
        return this;
    }

    public int hashCode() {
        return this.packName.hashCode();
    }

    public boolean equals(Object b) {
        if (b instanceof DfsPackDescription) {
            DfsPackDescription desc = (DfsPackDescription)b;
            return this.packName.equals(desc.packName) && this.getRepositoryDescription().equals(desc.getRepositoryDescription());
        }
        return false;
    }

    @Override
    public int compareTo(DfsPackDescription b) {
        int cmp;
        DfsObjDatabase.PackSource as = this.getPackSource();
        DfsObjDatabase.PackSource bs = b.getPackSource();
        if (as != null && bs != null && (cmp = as.category - bs.category) != 0) {
            return cmp;
        }
        if (as != null && as == bs && DfsPackDescription.isGC(as) && (cmp = Long.signum(this.getFileSize(PackExt.PACK) - b.getFileSize(PackExt.PACK))) != 0) {
            return cmp;
        }
        cmp = Long.signum(b.getLastModified() - this.getLastModified());
        if (cmp != 0) {
            return cmp;
        }
        return Long.signum(this.getObjectCount() - b.getObjectCount());
    }

    static boolean isGC(DfsObjDatabase.PackSource s) {
        switch (s) {
            case GC: 
            case GC_REST: 
            case GC_TXN: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getFileName(PackExt.PACK);
    }
}

