/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Build {
    public static final Build CURRENT;
    private final boolean isSnapshot;
    private final String shortHash;
    private final String date;

    static URL getElasticsearchCodeSourceLocation() {
        CodeSource codeSource = Build.class.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    public Build(String shortHash, String date, boolean isSnapshot) {
        this.shortHash = shortHash;
        this.date = date;
        this.isSnapshot = isSnapshot;
    }

    public String shortHash() {
        return this.shortHash;
    }

    public String date() {
        return this.date;
    }

    public static Build readBuild(StreamInput in) throws IOException {
        String hash = in.readString();
        String date = in.readString();
        boolean snapshot = in.readBoolean();
        return new Build(hash, date, snapshot);
    }

    public static void writeBuild(Build build, StreamOutput out) throws IOException {
        out.writeString(build.shortHash());
        out.writeString(build.date());
        out.writeBoolean(build.isSnapshot());
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public String toString() {
        return "[" + this.shortHash + "][" + this.date + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        if (this.isSnapshot != build.isSnapshot) {
            return false;
        }
        if (!this.shortHash.equals(build.shortHash)) {
            return false;
        }
        return this.date.equals(build.date);
    }

    public int hashCode() {
        int result = this.isSnapshot ? 1 : 0;
        result = 31 * result + this.shortHash.hashCode();
        result = 31 * result + this.date.hashCode();
        return result;
    }

    static {
        boolean isSnapshot;
        String date;
        String shortHash;
        block20: {
            String urlStr;
            String esPrefix = "elasticsearch-" + Version.CURRENT;
            URL url = Build.getElasticsearchCodeSourceLocation();
            String string = urlStr = url == null ? "" : url.toString();
            if (urlStr.startsWith("file:/") && (urlStr.endsWith(esPrefix + ".jar") || urlStr.endsWith(esPrefix + "-SNAPSHOT.jar"))) {
                try (JarInputStream jar = new JarInputStream(FileSystemUtils.openFileURLStream(url));){
                    Manifest manifest = jar.getManifest();
                    shortHash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    isSnapshot = "true".equals(manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Snapshot"));
                    break block20;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            shortHash = "Unknown";
            date = "Unknown";
            String buildSnapshot = System.getProperty("build.snapshot");
            if (buildSnapshot != null) {
                try {
                    Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("build.snapshot set to [" + buildSnapshot + "] but not running tests");
                }
                isSnapshot = Booleans.parseBoolean(buildSnapshot);
            } else {
                isSnapshot = true;
            }
        }
        if (shortHash == null) {
            throw new IllegalStateException("Error finding the build shortHash. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (date == null) {
            throw new IllegalStateException("Error finding the build date. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        CURRENT = new Build(shortHash, date, isSnapshot);
    }
}

