/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;

public abstract class Condition<T>
implements NamedWriteable {
    public static ObjectParser<Set<Condition>, Void> PARSER = new ObjectParser("conditions", null);
    protected T value;
    protected final String name;

    protected Condition(String name) {
        this.name = name;
    }

    public abstract Result evaluate(Stats var1);

    boolean includedInVersion(Version version) {
        return true;
    }

    public final String toString() {
        return "[" + this.name + ": " + this.value + "]";
    }

    static {
        PARSER.declareString((conditions, s) -> conditions.add(new MaxAgeCondition(TimeValue.parseTimeValue(s, "max_age"))), new ParseField("max_age", new String[0]));
        PARSER.declareLong((conditions, value) -> conditions.add(new MaxDocsCondition((Long)value)), new ParseField("max_docs", new String[0]));
        PARSER.declareString((conditions, s) -> conditions.add(new MaxSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_size"))), new ParseField("max_size", new String[0]));
    }

    public static class Result {
        public final Condition condition;
        public final boolean matched;

        protected Result(Condition condition, boolean matched) {
            this.condition = condition;
            this.matched = matched;
        }
    }

    public static class Stats {
        public final long numDocs;
        public final long indexCreated;
        public final ByteSizeValue indexSize;

        public Stats(long numDocs, long indexCreated, ByteSizeValue indexSize) {
            this.numDocs = numDocs;
            this.indexCreated = indexCreated;
            this.indexSize = indexSize;
        }
    }
}

