/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucket;

public class InternalPercentilesBucket
extends InternalNumericMetricsAggregation.MultiValue
implements PercentilesBucket {
    private double[] percentiles;
    private double[] percents;
    private final transient Map<Double, Double> percentileLookups = new HashMap<Double, Double>();

    public InternalPercentilesBucket(String name, double[] percents, double[] percentiles, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        if (!(percentiles.length == percents.length)) {
            throw new IllegalArgumentException("The number of provided percents and percentiles didn't match. percents: " + Arrays.toString(percents) + ", percentiles: " + Arrays.toString(percentiles));
        }
        this.format = formatter;
        this.percentiles = percentiles;
        this.percents = percents;
        this.computeLookup();
    }

    private void computeLookup() {
        for (int i = 0; i < this.percents.length; ++i) {
            this.percentileLookups.put(this.percents[i], this.percentiles[i]);
        }
    }

    public InternalPercentilesBucket(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.percentiles = in.readDoubleArray();
        this.percents = in.readDoubleArray();
        this.computeLookup();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.percentiles);
        out.writeDoubleArray(this.percents);
    }

    @Override
    public String getWriteableName() {
        return "percentiles_bucket";
    }

    @Override
    public double percentile(double percent) throws IllegalArgumentException {
        Double percentile = this.percentileLookups.get(percent);
        if (percentile == null) {
            throw new IllegalArgumentException("Percent requested [" + String.valueOf(percent) + "] was not one of the computed percentiles.  Available keys are: " + Arrays.toString(this.percents));
        }
        return percentile;
    }

    @Override
    public String percentileAsString(double percent) {
        return this.format.format(this.percentile(percent));
    }

    DocValueFormat formatter() {
        return this.format;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.percents, this.percentiles);
    }

    @Override
    public double value(String name) {
        return this.percentile(Double.parseDouble(name));
    }

    @Override
    public InternalMax doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("values");
        for (double percent : this.percents) {
            double value = this.percentile(percent);
            boolean hasValue = !Double.isInfinite(value) && !Double.isNaN(value);
            String key = String.valueOf(percent);
            builder.field(key, hasValue ? Double.valueOf(value) : null);
            if (!hasValue || this.format == DocValueFormat.RAW) continue;
            builder.field(key + "_as_string", this.percentileAsString(percent));
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalPercentilesBucket that = (InternalPercentilesBucket)obj;
        return Arrays.equals(this.percents, that.percents) && Arrays.equals(this.percentiles, that.percentiles);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Arrays.hashCode(this.percents), Arrays.hashCode(this.percentiles));
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] percents;
        private final double[] percentiles;
        private int i;

        public Iter(double[] percents, double[] percentiles) {
            this.percents = percents;
            this.percentiles = percentiles;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentile next() {
            Percentile next = new Percentile(this.percents[this.i], this.percentiles[this.i]);
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

