/*
 * Decompiled with CFR 0.152.
 */
package esmska.persistence;

import esmska.Context;
import esmska.data.Contacts;
import esmska.data.History;
import esmska.data.Keyring;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContinuousSaveManager {
    private static final Logger logger = Logger.getLogger(ContinuousSaveManager.class.getName());
    private static ActionListener historySaveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Context.persistenceManager.saveHistory();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Could not save history", ex);
            }
        }
    };
    private static ActionListener keyringSaveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Context.persistenceManager.saveKeyring();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Could not save keyring", ex);
            }
        }
    };
    private static ActionListener contactsSaveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Context.persistenceManager.saveContacts();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Could not save contacts", ex);
            }
        }
    };
    private static ValuedListener<Queue.Events, SMS> queueValuedListener = new ValuedListener<Queue.Events, SMS>(){

        @Override
        public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
            switch (e.getEvent()) {
                case QUEUE_CLEARED: 
                case SMS_ADDED: 
                case SMS_POSITION_CHANGED: 
                case SMS_REMOVED: {
                    try {
                        Context.persistenceManager.saveQueue();
                        break;
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "Could not save queue", ex);
                    }
                }
            }
        }
    };

    public static void enableHistory() {
        History.getInstance().addActionListener(historySaveListener);
    }

    public static void enableKeyring() {
        Keyring.getInstance().addActionListener(keyringSaveListener);
    }

    public static void enableContacts() {
        Contacts.getInstance().addActionListener(contactsSaveListener);
    }

    public static void enableQueue() {
        Queue.getInstance().addValuedListener(queueValuedListener);
    }

    public static void disableHistory() {
        History.getInstance().removeActionListener(historySaveListener);
    }

    public static void disableKeyring() {
        Keyring.getInstance().removeActionListener(keyringSaveListener);
    }

    public static void disableContacts() {
        Contacts.getInstance().removeActionListener(contactsSaveListener);
    }

    public static void disableQueue() {
        Queue.getInstance().removeValuedListener(queueValuedListener);
    }
}

