/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ServerEurope
extends Europe
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerEurope.class.getName());

    public ServerEurope(Game game, String id) {
        super(game, id);
    }

    public ServerEurope(Game game, Player owner) {
        super(game, owner);
    }

    @Override
    public boolean equipForRole(Unit unit, Role role, int roleCount) {
        if (!unit.roleIsAvailable(role)) {
            return false;
        }
        List<AbstractGoods> required = unit.getGoodsDifference(role, roleCount);
        int price = this.priceGoods(required);
        if (price < 0 || !unit.getOwner().checkGold(price)) {
            return false;
        }
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        for (AbstractGoods ag : required) {
            int rm;
            if (ag.getAmount() >= 0 || !owner.canTrade(ag.getType(), Market.Access.EUROPE) || (rm = owner.sell(null, ag.getType(), -ag.getAmount())) <= 0) continue;
            owner.addExtraTrade(new AbstractGoods(ag.getType(), rm));
        }
        for (AbstractGoods ag : required) {
            int m;
            if (ag.getAmount() <= 0 || (m = owner.buy(null, ag.getType(), ag.getAmount())) <= 0) continue;
            owner.addExtraTrade(new AbstractGoods(ag.getType(), -m));
        }
        unit.changeRole(role, roleCount);
        return true;
    }

    public void initializeMigration(Random random) {
        UnitType unitType;
        Specification spec = this.getGame().getSpecification();
        if (spec.hasOption("model.option.immigrants")) {
            UnitListOption option = (UnitListOption)spec.getOption("model.option.immigrants");
            for (AbstractUnit au : option.getOptionValues()) {
                unitType = au.getType(spec);
                this.addRecruitable(au.getType(spec));
            }
        } else {
            String unitTypeId;
            String optionId;
            int index = 0;
            while (spec.hasOption(optionId = "model.option.recruitable.slot" + index) && (unitTypeId = spec.getString(optionId)) != null && (unitType = spec.getUnitType(unitTypeId)) != null && this.addRecruitable(unitType)) {
                ++index;
            }
        }
        List recruits = this.generateRecruitablesList();
        while (this.addRecruitable(unitType = (UnitType)RandomChoice.getWeightedRandom(logger, "Recruits", recruits, random))) {
        }
    }

    public void increaseRecruitmentDifficulty() {
        Specification spec = this.getSpecification();
        this.recruitPrice += spec.getInteger("model.option.recruitPriceIncrease");
        this.recruitLowerCap += spec.getInteger("model.option.lowerCapIncrease");
    }

    public UnitType extractRecruitable(int slot, Random random) {
        int count = Europe.MigrationType.getMigrantCount();
        int index = Europe.MigrationType.specificMigrantSlot(slot) ? Europe.MigrationType.migrantSlotToIndex(slot) : RandomUtils.randomInt(logger, "Choose emigrant", random, count);
        UnitType result = (UnitType)this.recruitables.get(index);
        for (int i = index; i < count - 1; ++i) {
            this.recruitables.set(i, this.recruitables.get(i + 1));
        }
        this.recruitables.set(count - 1, RandomChoice.getWeightedRandom(logger, "Replace recruit", this.generateRecruitablesList(), random));
        return result;
    }

    public List<RandomChoice<UnitType>> generateRecruitablesList() {
        Player owner = this.getOwner();
        ArrayList<RandomChoice<UnitType>> recruits = new ArrayList<RandomChoice<UnitType>>();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isRecruitable() || !owner.hasAbility("model.ability.canRecruitUnit", unitType)) continue;
            recruits.add(new RandomChoice<UnitType>(unitType, unitType.getRecruitProbability()));
        }
        return recruits;
    }

    public boolean replaceRecruits(Random random) {
        List recruits = this.generateRecruitablesList();
        boolean result = false;
        int i = 0;
        for (UnitType ut : this.recruitables) {
            if (this.hasAbility("model.ability.canRecruitUnit", ut)) continue;
            UnitType newType = (UnitType)RandomChoice.getWeightedRandom(logger, "Replace recruit", recruits, random);
            this.recruitables.set(i, newType);
            result = true;
            ++i;
        }
        return result;
    }

    public void generateFountainRecruits(int n, Random random) {
        Game game = this.getGame();
        Player owner = this.getOwner();
        List recruits = this.generateRecruitablesList();
        for (int k = 0; k < n; ++k) {
            UnitType ut = (UnitType)RandomChoice.getWeightedRandom(logger, "Choose FoY", recruits, random);
            new ServerUnit(game, this, owner, ut);
        }
    }

    public void increasePrice(UnitType unitType, int price) {
        int increase;
        String baseOption;
        Specification spec = this.getSpecification();
        String option = spec.getBoolean(baseOption = "model.option.priceIncreasePerType") ? "model.option.priceIncrease." + unitType.getSuffix() : "model.option.priceIncrease";
        int n = increase = spec.hasOption(option) ? spec.getInteger(option) : 0;
        if (increase != 0) {
            this.unitPrices.put(unitType, price + increase);
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        logger.finest("ServerEurope.csNewTurn, for " + this);
        for (Unit unit : this.getUnitList()) {
            if (!unit.isNaval() || !unit.isDamaged()) continue;
            ((ServerUnit)unit).csRepairUnit(cs);
        }
    }

    public boolean csEquipForRole(Unit unit, Role role, int roleCount, Random random, ChangeSet cs) {
        boolean ret = this.equipForRole(unit, role, roleCount);
        if (ret) {
            ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold");
            cs.add(ChangeSet.See.only(serverPlayer), unit);
            serverPlayer.flushExtraTrades(random);
            serverPlayer.csFlushMarket(cs);
        }
        return ret;
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverEurope";
    }
}

