/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeCheckerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckerContext;
import org.jetbrains.annotations.NotNull;

public final class NullabilityChecker {
    public static final NullabilityChecker INSTANCE;

    public final boolean isPossibleSubtype(@NotNull TypeCheckerContext context, @NotNull SimpleType subType, @NotNull SimpleType superType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return this.runIsPossibleSubtype(context, subType, superType);
    }

    public final boolean isSubtypeOfAny(@NotNull UnwrappedType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.hasNotNullSupertype(new TypeCheckerContext(false, false, 2, null), FlexibleTypesKt.lowerIfFlexible(type2), TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE);
    }

    private final boolean runIsPossibleSubtype(@NotNull TypeCheckerContext $receiver, SimpleType subType, SimpleType superType) {
        boolean bl;
        boolean bl2 = bl = NewKotlinTypeCheckerKt.isIntersectionType(subType) || NewKotlinTypeCheckerKt.isSingleClassifierType(subType) || $receiver.isAllowedTypeVariable(subType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = NewKotlinTypeCheckerKt.isSingleClassifierType(superType) || $receiver.isAllowedTypeVariable(superType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (superType.isMarkedNullable()) {
            return true;
        }
        if (this.hasNotNullSupertype($receiver, subType, TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if (this.hasNotNullSupertype($receiver, superType, TypeCheckerContext.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if (NewKotlinTypeCheckerKt.isClassType(subType)) {
            return false;
        }
        return this.hasPathByNotMarkedNullableNodes($receiver, subType, superType.getConstructor());
    }

    private final boolean hasNotNullSupertype(@NotNull TypeCheckerContext $receiver, SimpleType type2, TypeCheckerContext.SupertypesPolicy supertypesPolicy) {
        boolean bl;
        block9: {
            TypeCheckerContext this_$iv = $receiver;
            SimpleType it = type2;
            if (NewKotlinTypeCheckerKt.isClassType(it) && !it.isMarkedNullable()) {
                bl = true;
            } else {
                Object object;
                TypeCheckerContext.access$initialize(this_$iv);
                ArrayDeque arrayDeque = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (arrayDeque == null) {
                    Intrinsics.throwNpe();
                }
                ArrayDeque deque$iv = arrayDeque;
                Set set = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                Set visitedSupertypes$iv = set;
                deque$iv.push(type2);
                while (!(object = (Collection)deque$iv).isEmpty()) {
                    TypeCheckerContext.SupertypesPolicy policy$iv;
                    SimpleType current$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        object = "Too many supertypes for type: " + type2 + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes$iv, null, null, null, (int)0, null, null, (int)63, null);
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    SimpleType simpleType2 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"current");
                    if (!visitedSupertypes$iv.add(simpleType2)) continue;
                    it = current$iv;
                    TypeCheckerContext.SupertypesPolicy supertypesPolicy2 = it.isMarkedNullable() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : supertypesPolicy;
                    TypeCheckerContext.SupertypesPolicy it$iv = supertypesPolicy2;
                    if ((Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true ? supertypesPolicy2 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    Iterator<KotlinType> iterator2 = current$iv.getConstructor().getSupertypes().iterator();
                    while (iterator2.hasNext()) {
                        SimpleType newType$iv;
                        KotlinType supertype$iv;
                        KotlinType kotlinType = supertype$iv = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"supertype");
                        it = newType$iv = policy$iv.transformType(kotlinType);
                        if (NewKotlinTypeCheckerKt.isClassType(it) && !it.isMarkedNullable()) {
                            TypeCheckerContext.access$clear(this_$iv);
                            bl = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                TypeCheckerContext.access$clear(this_$iv);
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasPathByNotMarkedNullableNodes(@NotNull TypeCheckerContext $receiver, SimpleType start, TypeConstructor end) {
        boolean bl;
        block9: {
            TypeCheckerContext this_$iv = $receiver;
            SimpleType it = start;
            if (!it.isMarkedNullable() && Intrinsics.areEqual((Object)it.getConstructor(), (Object)end)) {
                bl = true;
            } else {
                Object object;
                TypeCheckerContext.access$initialize(this_$iv);
                ArrayDeque arrayDeque = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (arrayDeque == null) {
                    Intrinsics.throwNpe();
                }
                ArrayDeque deque$iv = arrayDeque;
                Set set = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                Set visitedSupertypes$iv = set;
                deque$iv.push(start);
                while (!(object = (Collection)deque$iv).isEmpty()) {
                    TypeCheckerContext.SupertypesPolicy policy$iv;
                    SimpleType current$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        object = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes$iv, null, null, null, (int)0, null, null, (int)63, null);
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    SimpleType simpleType2 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"current");
                    if (!visitedSupertypes$iv.add(simpleType2)) continue;
                    it = current$iv;
                    TypeCheckerContext.SupertypesPolicy supertypesPolicy = it.isMarkedNullable() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    TypeCheckerContext.SupertypesPolicy it$iv = supertypesPolicy;
                    if ((Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true ? supertypesPolicy : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    Iterator<KotlinType> iterator2 = current$iv.getConstructor().getSupertypes().iterator();
                    while (iterator2.hasNext()) {
                        SimpleType newType$iv;
                        KotlinType supertype$iv;
                        KotlinType kotlinType = supertype$iv = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"supertype");
                        it = newType$iv = policy$iv.transformType(kotlinType);
                        if (!it.isMarkedNullable() && Intrinsics.areEqual((Object)it.getConstructor(), (Object)end)) {
                            TypeCheckerContext.access$clear(this_$iv);
                            bl = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                TypeCheckerContext.access$clear(this_$iv);
                bl = false;
            }
        }
        return bl;
    }

    private NullabilityChecker() {
    }

    static {
        NullabilityChecker nullabilityChecker;
        INSTANCE = nullabilityChecker = new NullabilityChecker();
    }
}

