/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputPropertiesTaskStateChanges
extends SimpleTaskStateChanges {
    private final TaskInternal task;
    private final Set<String> removed;
    private final Set<String> changed;
    private final Set<String> added;

    public InputPropertiesTaskStateChanges(@Nullable TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        ImmutableSortedMap<String, ValueSnapshot> previousInputProperties = previousExecution == null ? ImmutableSortedMap.of() : previousExecution.getInputProperties();
        this.removed = new HashSet<String>((Collection<String>)previousInputProperties.keySet());
        this.changed = new HashSet<String>();
        this.added = new HashSet<String>();
        ImmutableSortedMap<String, ValueSnapshot> currentInputProperties = currentExecution.getInputProperties();
        for (Map.Entry entry : currentInputProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            ValueSnapshot currentSnapshot = (ValueSnapshot)entry.getValue();
            this.removed.remove(propertyName);
            ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
            if (previousSnapshot == null) {
                this.added.add(propertyName);
                continue;
            }
            if (currentSnapshot.equals(previousSnapshot)) continue;
            this.changed.add(propertyName);
        }
        this.task = task;
    }

    @Override
    protected void addAllChanges(List<TaskStateChange> changes) {
        for (String propertyName : this.changed) {
            changes.add(new DescriptiveChange("Value of input property '%s' has changed for %s", propertyName, this.task));
        }
        for (String propertyName : this.added) {
            changes.add(new DescriptiveChange("Input property '%s' has been added for %s", propertyName, this.task));
        }
        for (String propertyName : this.removed) {
            changes.add(new DescriptiveChange("Input property '%s' has been removed for %s", propertyName, this.task));
        }
    }
}

