/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.BuildExecutionAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.TaskGraphExecuter;

public class SelectedTaskExecutionAction
implements BuildExecutionAction {
    public void execute(BuildExecutionContext context) {
        GradleInternal gradle = context.getGradle();
        TaskGraphExecuter taskGraph = gradle.getTaskGraph();
        if (gradle.getStartParameter().isContinueOnFailure()) {
            taskGraph.useFailureHandler(new ContinueOnFailureHandler());
        }
        taskGraph.addTaskExecutionGraphListener(new BindAllReferencesOfProjectsToExecuteListener());
        taskGraph.execute();
    }

    private static class BindAllReferencesOfProjectsToExecuteListener
    implements TaskExecutionGraphListener {
        private BindAllReferencesOfProjectsToExecuteListener() {
        }

        public void graphPopulated(TaskExecutionGraph graph) {
            HashSet seen = Sets.newHashSet();
            for (Task task : graph.getAllTasks()) {
                if (!seen.add(task.getProject())) continue;
                ProjectInternal projectInternal = (ProjectInternal)task.getProject();
                projectInternal.bindAllModelRules();
            }
        }
    }

    private static class ContinueOnFailureHandler
    implements TaskFailureHandler {
        private ContinueOnFailureHandler() {
        }

        public void onTaskFailure(Task task) {
        }
    }
}

