/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.changedetection.changes.DiscoveredInputRecorder;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.nativeplatform.internal.AbstractBinaryToolSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

public abstract class AbstractNativeCompileSpec
extends AbstractBinaryToolSpec
implements NativeCompileSpec {
    private List<File> includeRoots = new ArrayList<File>();
    private List<File> sourceFiles = new ArrayList<File>();
    private List<File> removedSourceFiles = new ArrayList<File>();
    private boolean incrementalCompile;
    private Map<String, String> macros = new LinkedHashMap<String, String>();
    private File objectFileDir;
    private boolean positionIndependentCode;
    private boolean debuggable;
    private boolean optimized;
    private BuildOperationLogger oplogger;
    private File prefixHeaderFile;
    private File preCompiledHeaderObjectFile;
    private Map<File, IncludeDirectives> sourceFileIncludeDirectives;
    private String preCompiledHeader;
    private DiscoveredInputRecorder discoveredInputRecorder;

    public List<File> getIncludeRoots() {
        return this.includeRoots;
    }

    public void include(File ... includeRoots) {
        Collections.addAll(this.includeRoots, includeRoots);
    }

    public void include(Iterable<File> includeRoots) {
        this.addAll(this.includeRoots, includeRoots);
    }

    public List<File> getSourceFiles() {
        return this.sourceFiles;
    }

    public void source(Iterable<File> sources) {
        this.addAll(this.sourceFiles, sources);
    }

    public void setSourceFiles(Collection<File> sources) {
        this.sourceFiles.clear();
        this.sourceFiles.addAll(sources);
    }

    public List<File> getRemovedSourceFiles() {
        return this.removedSourceFiles;
    }

    public void removedSource(Iterable<File> sources) {
        this.addAll(this.removedSourceFiles, sources);
    }

    public void setRemovedSourceFiles(Collection<File> sources) {
        this.removedSourceFiles.clear();
        this.removedSourceFiles.addAll(sources);
    }

    public boolean isIncrementalCompile() {
        return this.incrementalCompile;
    }

    public void setIncrementalCompile(boolean flag) {
        this.incrementalCompile = flag;
    }

    public File getObjectFileDir() {
        return this.objectFileDir;
    }

    public void setObjectFileDir(File objectFileDir) {
        this.objectFileDir = objectFileDir;
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    public void define(String name) {
        this.macros.put(name, null);
    }

    public void define(String name, String value) {
        this.macros.put(name, value);
    }

    public boolean isPositionIndependentCode() {
        return this.positionIndependentCode;
    }

    public void setPositionIndependentCode(boolean positionIndependentCode) {
        this.positionIndependentCode = positionIndependentCode;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public File getPreCompiledHeaderObjectFile() {
        return this.preCompiledHeaderObjectFile;
    }

    public void setPreCompiledHeaderObjectFile(File preCompiledHeaderObjectFile) {
        this.preCompiledHeaderObjectFile = preCompiledHeaderObjectFile;
    }

    public File getPrefixHeaderFile() {
        return this.prefixHeaderFile;
    }

    public void setPrefixHeaderFile(File pchFile) {
        this.prefixHeaderFile = pchFile;
    }

    public String getPreCompiledHeader() {
        return this.preCompiledHeader;
    }

    public void setPreCompiledHeader(String preCompiledHeader) {
        this.preCompiledHeader = preCompiledHeader;
    }

    private void addAll(List<File> list, Iterable<File> iterable) {
        for (File file : iterable) {
            list.add(file);
        }
    }

    public BuildOperationLogger getOperationLogger() {
        return this.oplogger;
    }

    public void setOperationLogger(BuildOperationLogger oplogger) {
        this.oplogger = oplogger;
    }

    public Map<File, IncludeDirectives> getSourceFileIncludeDirectives() {
        return this.sourceFileIncludeDirectives;
    }

    public void setSourceFileIncludeDirectives(Map<File, IncludeDirectives> map) {
        this.sourceFileIncludeDirectives = map;
    }
}

