/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.Linkage;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public SwiftLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        final ConfigurationContainer configurations = project.getConfigurations();
        final ObjectFactory objectFactory = project.getObjects();
        final DefaultSwiftLibrary library = this.componentFactory.newInstance(SwiftLibrary.class, DefaultSwiftLibrary.class, "main");
        project.getExtensions().add(SwiftLibrary.class, "library", (Object)library);
        project.getComponents().add((Object)library);
        Property<String> module = library.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                library.getLinkage().lockNow();
                if (((Set)library.getLinkage().get()).isEmpty()) {
                    throw new IllegalArgumentException("A linkage needs to be specified for the library.");
                }
                boolean sharedLibs = ((Set)library.getLinkage().get()).contains(Linkage.SHARED);
                boolean staticLibs = ((Set)library.getLinkage().get()).contains(Linkage.STATIC);
                ToolChainSelector.Result<SwiftPlatform> result = SwiftLibraryPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                SwiftSharedLibrary debugSharedLibrary = null;
                if (sharedLibs) {
                    String linkageNameSuffix = staticLibs ? "Shared" : "";
                    debugSharedLibrary = library.addSharedLibrary("debug" + linkageNameSuffix, true, false, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    SwiftSharedLibrary releaseSharedLibrary = library.addSharedLibrary("release" + linkageNameSuffix, true, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    SwiftCompile compileDebug = (SwiftCompile)((Object)debugSharedLibrary.getCompileTask().get());
                    SwiftCompile compileRelease = (SwiftCompile)((Object)releaseSharedLibrary.getCompileTask().get());
                    Configuration api = library.getApiDependencies();
                    Configuration debugApiElements = (Configuration)configurations.create("debugSwiftApiElements");
                    debugApiElements.extendsFrom(new Configuration[]{api});
                    debugApiElements.setCanBeResolved(false);
                    debugApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                    debugApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)debugSharedLibrary.isDebuggable());
                    debugApiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)debugSharedLibrary.isOptimized());
                    debugApiElements.getOutgoing().artifact((Object)compileDebug.getModuleFile());
                    Configuration releaseApiElements = (Configuration)configurations.create("releaseSwiftApiElements");
                    releaseApiElements.extendsFrom(new Configuration[]{api});
                    releaseApiElements.setCanBeResolved(false);
                    releaseApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                    releaseApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)releaseSharedLibrary.isDebuggable());
                    releaseApiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)releaseSharedLibrary.isOptimized());
                    releaseApiElements.getOutgoing().artifact((Object)compileRelease.getModuleFile());
                }
                SwiftStaticLibrary debugStaticLibrary = null;
                if (staticLibs) {
                    String linkageNameSuffix = sharedLibs ? "Static" : "";
                    debugStaticLibrary = library.addStaticLibrary("debug" + linkageNameSuffix, true, false, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    SwiftStaticLibrary releaseStaticLibrary = library.addStaticLibrary("release" + linkageNameSuffix, true, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    if (!sharedLibs) {
                        SwiftCompile compileDebug = (SwiftCompile)((Object)debugStaticLibrary.getCompileTask().get());
                        SwiftCompile compileRelease = (SwiftCompile)((Object)releaseStaticLibrary.getCompileTask().get());
                        Configuration api = library.getApiDependencies();
                        Configuration debugApiElements = (Configuration)configurations.create("debugStaticSwiftApiElements");
                        debugApiElements.extendsFrom(new Configuration[]{api});
                        debugApiElements.setCanBeResolved(false);
                        debugApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                        debugApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)debugStaticLibrary.isDebuggable());
                        debugApiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)debugStaticLibrary.isOptimized());
                        debugApiElements.getOutgoing().artifact((Object)compileDebug.getModuleFile());
                        Configuration releaseApiElements = (Configuration)configurations.create("releaseStaticSwiftApiElements");
                        releaseApiElements.extendsFrom(new Configuration[]{api});
                        releaseApiElements.setCanBeResolved(false);
                        releaseApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                        releaseApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)releaseStaticLibrary.isDebuggable());
                        releaseApiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)releaseStaticLibrary.isOptimized());
                        releaseApiElements.getOutgoing().artifact((Object)compileRelease.getModuleFile());
                    }
                }
                if (sharedLibs) {
                    library.getDevelopmentBinary().set(debugSharedLibrary);
                } else {
                    library.getDevelopmentBinary().set(debugStaticLibrary);
                }
                ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
            }
        });
    }
}

