/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.fileTypes;

import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;

public class CharsetUtil {
    private static final Map<LanguageFileType, Boolean> ourSupportsCharsetDetection = new ConcurrentFactoryMap<LanguageFileType, Boolean>(){

        @Override
        @Nullable
        protected Boolean create(LanguageFileType fileType) {
            Class<?> ftClass = fileType.getClass();
            String methodName = "extractCharsetFromFileContent";
            Class declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, String.class);
            Class declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, CharSequence.class);
            return !LanguageFileType.class.equals((Object)declaring1) || !LanguageFileType.class.equals((Object)declaring2);
        }
    };

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile2, @Nullable FileType fileType, @NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/openapi/fileTypes/CharsetUtil", "extractCharsetFromFileContent"));
        }
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.get(fileType).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile2, text2);
        }
        return null;
    }
}

